/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@MythicMechanic(name="hideFromPlayers", aliases={"hideFromPlayer", "hide"}, description="Hides the caster from the targeted player(s)")
public class HideMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="duration", aliases={"ticks", "d", "t"}, description="The duration of the hide effect", defValue="0")
    private final PlaceholderInt duration;

    public HideMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig config) {
        super(manager, file, skill, config);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.duration = config.getPlaceholderInteger(new String[]{"duration", "ticks", "d", "t"}, 0, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer() || target.getUniqueId() == data.getCaster().getEntity().getUniqueId()) {
            return SkillResult.INVALID_TARGET;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_18)) {
            this.hideMe_v2(data, target);
        } else {
            if (!data.getCaster().getEntity().isPlayer()) {
                return SkillResult.CONDITION_FAILED;
            }
            this.hideMe(data, target);
        }
        return SkillResult.SUCCESS;
    }

    public void hideMe(SkillMetadata data, AbstractEntity target) {
        Player player = (Player)target.getBukkitEntity();
        Player caster = BukkitAdapter.adapt(data.getCaster().getEntity().asPlayer());
        int dur = this.duration.get(data, target);
        player.hidePlayer((Plugin)this.getPlugin(), caster);
        if (dur > 0) {
            Schedulers.sync().runLater(() -> player.showPlayer((Plugin)this.getPlugin(), caster), dur);
        }
    }

    public void hideMe_v2(SkillMetadata data, AbstractEntity target) {
        Player player = BukkitAdapter.adapt(target.asPlayer());
        Entity caster = BukkitAdapter.adapt(data.getCaster().getEntity());
        int dur = this.duration.get(data, target);
        player.hideEntity((Plugin)this.getPlugin(), caster);
        if (dur > 0) {
            Schedulers.sync().runLater(() -> player.showEntity((Plugin)this.getPlugin(), caster), dur);
        }
    }
}

