/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="giveitem", aliases={"give", "giveitems", "itemgive"}, description="Gives the target an item or droptable")
public class GiveItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="items", aliases={"item", "i"}, description="The item(s) or droptable to give")
    private DropTable dropTable;
    @MythicField(name="doFakeLooting", aliases={"fl", "fakelooting"}, description="Whether to play the pickup animation from the origin", defValue="false")
    private final boolean doFakeLooting;
    private PlaceholderString itemString;

    public GiveItemMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.doFakeLooting = mlc.getBoolean(new String[]{"dofakelooting", "fakelooting", "fl"}, false);
        this.itemString = mlc.getPlaceholderString(new String[]{"items", "item", "i"}, "", new String[0]);
        if (this.itemString.isStatic()) {
            ((MythicBukkit)this.getPlugin()).getDropManager().queueSecondPass(() -> {
                String itemString = this.itemString.get();
                Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(itemString);
                if (maybeTable.isPresent()) {
                    this.dropTable = maybeTable.get();
                    return;
                }
                if (itemString.startsWith("\"")) {
                    try {
                        itemString = itemString.substring(1, itemString.length() - 1);
                    }
                    catch (Exception ex) {
                        MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
                    }
                    itemString = SkillString.parseMessageSpecialChars(itemString);
                }
                ArrayList<String> items = new ArrayList<String>(Arrays.asList(itemString.split(",")));
                this.dropTable = new DropTable("GiveItemMechanic", "GiveItemMechanic", items);
            });
        } else {
            this.dropTable = null;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        LootBag loot = this.getLoot(data, target);
        if (target.isPlayer()) {
            loot.give(target.asPlayer(), false);
        }
        if (this.doFakeLooting) {
            if (!target.isPlayer()) {
                return SkillResult.SUCCESS;
            }
            Player player = (Player)target.getBukkitEntity();
            Location location = BukkitAdapter.adapt(data.getOrigin());
            for (Drop type : loot.getLootTable()) {
                IDrop drop;
                double amount = type.getAmount();
                if (type instanceof CustomDrop) {
                    if (((CustomDrop)type).getDrop().isEmpty()) continue;
                    drop = ((CustomDrop)type).getDrop().get();
                } else {
                    drop = type;
                }
                if (!(drop instanceof ItemDrop)) continue;
                ItemStack stack = ((BukkitItemStack)((ItemDrop)drop).getDrop(new DropMetadataImpl(data.getCaster(), target), amount)).build();
                int id = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().spawnFakeItem(player, stack, data.getOrigin());
                Schedulers.sync().runLater(() -> ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().collectFakeItem(player, id), 5L);
            }
        }
        return SkillResult.SUCCESS;
    }

    private LootBag getLoot(SkillMetadata data, AbstractEntity target) {
        if (this.dropTable != null) {
            return this.dropTable.generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        }
        String in = target == null ? this.itemString.get(data) : this.itemString.get(data, target);
        Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(in);
        if (maybeTable.isPresent()) {
            return maybeTable.get().generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        }
        ArrayList items = Lists.newArrayList((Object[])in.split(","));
        return new DropTable("GiveItemMechanic", "GiveItemMechanic", items).generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
    }
}

