/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.damage.DamagingMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="consume", description="Deals damage to the target and heals the caster")
public class ConsumeMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    @MythicField(name="damage", aliases={"dmg", "d"}, description="The amount of damage to deal to the target", defValue="1")
    protected final PlaceholderFloat damage;
    @MythicField(name="heal", aliases={"h"}, description="The amount of health to heal", defValue="1")
    protected final PlaceholderFloat heal;

    public ConsumeMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.damage = mlc.getPlaceholderFloat(new String[]{"damage", "dmg", "d"}, 1.0f, new String[0]);
        this.heal = mlc.getPlaceholderFloat(new String[]{"heal", "h"}, 1.0f, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return SkillResult.INVALID_TARGET;
        }
        LivingEntity consumer = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        this.doDamage(data.getCaster(), target, this.damage.get(data, target) * data.getPower());
        float modheal = this.heal.get(data, target) * data.getPower();
        if (consumer.getHealth() + (double)modheal >= consumer.getMaxHealth()) {
            consumer.setHealth(consumer.getMaxHealth());
        } else {
            consumer.setHealth(consumer.getHealth() + (double)modheal);
        }
        return SkillResult.SUCCESS;
    }
}

