/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;

@MythicMechanic(author="Ashijin", name="blockMask", aliases={"effect:blockMask", "e:blockMask"}, description="Temporarily masks a block as a different block")
public class BlockMaskEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="block", aliases={"b", "material", "mat", "m"}, description="The block used for the blockmask. Supports blockdata string", defValue="GRAVEL")
    private final PlaceholderString strMaterial;
    private AbstractBlock block;
    @MythicField(name="radius", aliases={"r"}, description="The radius of the blockmask effect", defValue="0")
    private final PlaceholderInt radius;
    @MythicField(name="radiusy", aliases={"ry"}, description="The radiusy of the blockmask effect", defValue="radius")
    private final PlaceholderInt radiusY;
    @MythicField(name="duration", aliases={"d"}, description="The duration of the blockmask effect", defValue="0")
    private final PlaceholderInt duration;
    @MythicField(name="noise", aliases={"n"}, description="The noise/randomness of the blockmask effect", defValue="0")
    private final PlaceholderDouble randomness;
    @MythicField(name="shape", aliases={"s"}, description="The shape of the blockmask effect - SPHERE/CUBE.", defValue="SPHERE")
    private final boolean sphere;
    private final SkillAudience audience;
    private MaskType maskType;

    public BlockMaskEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strMaterial = mlc.getPlaceholderString(new String[]{"material", "mat", "m", "block", "b"}, "GRAVEL", new String[0]);
        if (this.strMaterial.isStatic()) {
            ((MythicBukkit)this.getPlugin()).getClock().queuePostReload(() -> {
                AbstractBlock block = ((MythicBukkit)this.getPlugin()).getBootstrap().getBlock(this.strMaterial.get());
                if (block instanceof AbstractBlock.InvalidBlock) {
                    MythicLogger.errorMechanicConfig(this, mlc, "'" + this.strMaterial.get() + "' is not a valid block type.");
                    return;
                }
                this.block = block;
            });
        } else {
            this.block = null;
        }
        this.audience = mlc.getAudience(new String[]{"audience"}, "nearby", new String[0]);
        this.radius = mlc.getPlaceholderInteger(new String[]{"radius", "r"}, 0, new String[0]);
        this.radiusY = mlc.getPlaceholderInteger(new String[]{"radiusy", "ry"}, this.radius, new String[0]);
        this.randomness = mlc.getPlaceholderDouble(new String[]{"noise", "n"}, 0.0, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 0, new String[0]);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        boolean noAir = mlc.getBoolean(new String[]{"noair", "na"}, true);
        boolean onlyAir = mlc.getBoolean(new String[]{"onlyair", "oa"}, false);
        this.maskType = noAir && !onlyAir ? MaskType.IGNORE_AIR : (onlyAir ? MaskType.ONLY_AIR : MaskType.ALL);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data, target, target.getLocation());
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data, target);
        return SkillResult.SUCCESS;
    }

    public void playEffect(SkillMetadata data, AbstractLocation location) {
        this.playEffect(data, null, location);
    }

    public void playEffect(SkillMetadata data, AbstractEntity entity, AbstractLocation location) {
        if (this.block == null) {
            String type = entity == null ? this.strMaterial.get(data) : this.strMaterial.get(data, entity);
            AbstractBlock block = ((MythicBukkit)this.getPlugin()).getBootstrap().getBlock(type);
            if (block instanceof AbstractBlock.InvalidBlock) {
                MythicLogger.errorMechanicConfig(this, this.getConfig(), "'" + type + "' is not a valid block type.");
                return;
            }
            blockData = ((BukkitBlock)block).getBlockData();
        } else {
            if (this.block instanceof AbstractBlock.InvalidBlock) {
                String type = entity == null ? this.strMaterial.get(data) : this.strMaterial.get(data, entity);
                MythicLogger.errorMechanicConfig(this, this.getConfig(), "'" + type + "' is not a valid block type.");
                return;
            }
            blockData = ((BukkitBlock)this.block).getBlockData();
        }
        int duration = entity == null ? this.duration.get(data) : this.duration.get(data, entity);
        int radius = entity == null ? this.radius.get(data) : this.radius.get(data, entity);
        int radiusY = entity == null ? this.radiusY.get(data) : this.radiusY.get(data, entity);
        Location baseLocation = BukkitAdapter.adapt(location);
        Collection<AbstractPlayer> audience = this.audience.get(data, entity);
        HashMap blocksToMask = Maps.newHashMap();
        if (radius == 0) {
            blocksToMask.put(location, this.block);
        } else {
            List<Location> blocks = this.getBlocksInRadius(baseLocation, true, radius, radiusY, this.randomness.get(data));
            for (Location maskLocation : blocks) {
                blocksToMask.put(BukkitAdapter.adapt(maskLocation), this.block);
            }
        }
        ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getBlockHandler().sendMultiBlockChange(audience, blocksToMask);
        if (duration > 0) {
            Schedulers.sync().runLater(() -> {
                Location lll = BukkitAdapter.adapt(location);
                if (!lll.getChunk().isLoaded()) {
                    return;
                }
                blocksToMask.replaceAll((k, v) -> null);
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getBlockHandler().sendMultiBlockChange(audience, blocksToMask);
            }, duration);
        }
    }

    private List<Location> getBlocksInRadius(Location l, boolean randomize, int radius, int radiusY, double randomness) {
        ArrayList blocks = Lists.newArrayList();
        if (!l.getChunk().isLoaded()) {
            return blocks;
        }
        double radiusSq = Math.pow(radius, 2.0);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Location newloc = new Location(l.getWorld(), l.getX() + (double)x, l.getY() + (double)y, l.getZ() + (double)z);
                    if (this.sphere && l.distanceSquared(newloc) > radiusSq || randomize && randomness > 0.0 && randomness < Numbers.randomDouble()) continue;
                    if (this.maskType == MaskType.ALL) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType == MaskType.IGNORE_AIR && newloc.getBlock().getType().isOccluding()) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.maskType != MaskType.ONLY_AIR || newloc.getBlock().getType().isOccluding()) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }

    private static enum MaskType {
        ALL,
        IGNORE_AIR,
        ONLY_AIR;

    }
}

