/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractStructure;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import java.util.Set;

@MythicCondition(author="Ashijin", name="structure", aliases={}, description="Tests if the target is within the given list of structures")
public class StructureCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="structures", aliases={"s"}, description="A list of structures to check", defValue="village")
    private Set<AbstractStructure> structures = Sets.newConcurrentHashSet();

    public StructureCondition(String line, MythicLineConfig mlc) {
        super(line);
        String strStructure = mlc.getString(new String[]{"structures", "structure", "s"}, "village", new String[0]);
        for (AbstractStructure structure : StructureCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getStructures()) {
            if (!structure.matches(strStructure)) continue;
            this.structures.add(structure);
        }
    }

    @Override
    public boolean check(AbstractLocation target) {
        Collection<AbstractStructure> structures = StructureCondition.getPlugin().getVolatileCodeHandler().getWorldHandler().getStructures(target);
        for (AbstractStructure struct : structures) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "StructureCondition checking {0} contains {1}", this.structures.toString(), struct.getKey());
            if (!this.structures.contains(struct)) continue;
            return true;
        }
        return false;
    }
}

