/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;

@MythicCondition(author="Joshinn", name="ismoist", aliases={"moist"}, description="Whether or not a location of farmland is moist.")
public class MoistCondition
extends SkillCondition
implements ILocationCondition {
    public MoistCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractLocation l) {
        BlockData blockData = BukkitAdapter.adapt(l).getBlock().getBlockData();
        if (blockData instanceof Farmland) {
            return ((Farmland)blockData).getMoisture() == 7;
        }
        return false;
    }
}

