/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="lastSignal", aliases={}, description="Matches the last signal received by the target mob")
public class LastSignalCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="signal", aliases={"s"}, description="The signal to match")
    private final String signal;

    public LastSignalCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.signal = mlc.getString(new String[]{"signal", "s"}, "DEFAULT", this.conditionVar);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (LastSignalCondition.getPlugin().getMobManager().isActiveMob(entity)) {
            ActiveMob am = LastSignalCondition.getPlugin().getMobManager().getMythicMobInstance(entity);
            return am.getLastSignal().matches(this.signal);
        }
        return false;
    }
}

