/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.numbers.RangedInt;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Phil", name="HasItem", aliases={}, description="Checks the inventory for this item")
public class HasItemCondition
extends SkillCondition
implements IEntityCondition,
ILocationCondition {
    @MythicField(name="item", aliases={"i, material, m"}, description="The item to check for")
    private BukkitItemStack item;
    @MythicField(name="amount", aliases={"a"}, description="The amount to check for")
    private final RangedInt amount;

    public HasItemCondition(String line, MythicLineConfig config) {
        super(line);
        String i = config.getString(new String[]{"item", "i", "material", "m"}, "DIRT", this.conditionVar);
        this.amount = new RangedInt(config.getString(new String[]{"amount", "a"}, ">0", new String[0]));
        try {
            this.item = new BukkitItemStack(i);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorConditionConfig(this, config, "'" + i + "' is not a valid material.");
        }
    }

    @Override
    public boolean check(AbstractEntity e) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking HASITEM Condition...", new Object[0]);
        if (!e.isPlayer()) {
            return false;
        }
        Player player = BukkitAdapter.adapt(e.asPlayer());
        return this.checkInventory((Inventory)player.getInventory());
    }

    @Override
    public boolean check(AbstractLocation l) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking HASITEM Condition...", new Object[0]);
        Location location = BukkitAdapter.adapt(l);
        BlockState blockState = location.getBlock().getState();
        if (!(blockState instanceof Container)) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Location " + location + " is not a container, returning FALSE", new Object[0]);
            return false;
        }
        Container container = (Container)blockState;
        return this.checkInventory(container.getInventory());
    }

    private boolean checkInventory(Inventory inventory) {
        int count = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !this.item.isSimilar(item)) continue;
            count += item.getAmount();
        }
        return this.amount.equals(count);
    }
}

