/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Joikd", name="hasAuraType", aliases={"hasbufftype", "hasdebufftype"}, description="Checks if the target entity has an aura of the given type")
public class HasAuraTypeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="type", aliases={"group", "g", "t", "n"}, description="The name of the aura type to check for")
    private String auraName;

    public HasAuraTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.auraName = mlc.getString(new String[]{"group", "type", "name", "g", "t", "n"}, this.conditionVar, new String[0]);
    }

    @Override
    public boolean check(AbstractEntity target) {
        return HasAuraTypeCondition.getPlugin().getSkillManager().getAuraManager().getAuraRegistry(target).hasAuraType(this.auraName);
    }
}

