/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationComparisonCondition;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="distance", aliases={}, description="Whether the distance between the caster and target is within the given range")
public class DistanceCondition
extends SkillCondition
implements IEntityComparisonCondition,
ILocationComparisonCondition {
    @MythicField(name="distance", aliases={"d"}, description="The distance to match")
    protected RangedDouble distance;

    public DistanceCondition(String line, MythicLineConfig mlc) {
        super(line);
        String d = mlc.getString(new String[]{"distance", "d"}, this.conditionVar, new String[0]);
        this.distance = new RangedDouble(d, true);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        if (!entity.getWorld().equals(target.getWorld())) {
            return false;
        }
        double diffSq = (float)entity.getLocation().distanceSquared(target.getLocation());
        return this.distance.equals(diffSq);
    }

    @Override
    public boolean check(AbstractLocation location, AbstractLocation target) {
        if (target == null) {
            return false;
        }
        if (!location.getWorld().equals(target.getWorld())) {
            return false;
        }
        double diffSq = (float)location.distanceSquared(target);
        return this.distance.equals(diffSq);
    }
}

