/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.auras;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.auras.AuraRegistry;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;

public class AuraManager {
    private final MythicBukkit core;
    private final SkillExecutor skillManager;
    private ConcurrentHashMap<UUID, AuraRegistry> auraRegistries = new ConcurrentHashMap();
    private Terminable garbageCollector;

    public AuraManager(MythicBukkit core, SkillExecutor skillManager) {
        this.core = core;
        this.skillManager = skillManager;
        this.garbageCollector = Schedulers.async().runRepeating(() -> this.auraRegistries.values().forEach(registry -> {}), 20L, 100L);
    }

    public void shutdown() {
        this.garbageCollector.terminate();
    }

    public AuraRegistry getAuraRegistry(AbstractEntity entity) {
        return this.getAuraRegistry(entity.getUniqueId());
    }

    public AuraRegistry getAuraRegistry(UUID uuid) {
        if (this.auraRegistries.containsKey(uuid)) {
            return this.auraRegistries.get(uuid);
        }
        AuraRegistry registry = new AuraRegistry(uuid);
        this.auraRegistries.put(uuid, registry);
        return registry;
    }

    public boolean getHasAura(AbstractEntity entity, String name) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return false;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        return registry.hasAura(name);
    }

    public int getAuraStacks(AbstractEntity entity, String name) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return 0;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        return registry.getStacks(name);
    }

    public void removeAuraStacks(AbstractEntity entity, String buffName, int a) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        registry.removeStack(buffName, a);
    }

    public void sendAuraDebugInfo(CommandSender sender) {
        int registries = 0;
        int auras = 0;
        int auraTrackers = 0;
        for (AuraRegistry registry : this.auraRegistries.values()) {
            ++registries;
            for (Map.Entry<String, Queue<Aura.AuraTracker>> entry : registry.getAuras().entrySet()) {
                ++auras;
                for (Aura.AuraTracker auraTracker : entry.getValue()) {
                    ++auraTrackers;
                }
            }
        }
        CommandHelper.send(sender, "<gold>Aura Registries<gray>: <white>" + registries);
        CommandHelper.send(sender, "<gold>Aura Types<gray>: <white>" + auras);
        CommandHelper.send(sender, "<gold>Aura Trackers<gray>: <white>" + auraTrackers);
    }
}

