/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.audience;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import java.util.ArrayList;
import java.util.Collection;

public class TargeterAudience
extends SkillAudience {
    private IEntitySelector targeter;

    public TargeterAudience(MythicLineConfig mlc, String search) {
        super(mlc);
        SkillTargeter targeter = TargeterAudience.getPlugin().getSkillManager().getTargeter(search);
        if (targeter instanceof IEntitySelector) {
            this.targeter = (IEntitySelector)targeter;
        } else {
            MythicLogger.errorGenericConfig(mlc, "Audience targeter is not supported");
        }
    }

    @Override
    public Collection<AbstractPlayer> get(SkillMetadata data, AbstractEntity target) {
        ArrayList ret = Lists.newArrayList();
        for (AbstractEntity t2 : this.targeter.getEntities(data)) {
            if (!t2.isPlayer()) continue;
            ret.add(t2.asPlayer());
        }
        return ret;
    }
}

