/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.conditions.ICasterCondition;
import io.lumine.mythic.api.skills.conditions.IEntityComparisonCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.IEntityLocationComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.conditions.ConditionAction;
import io.lumine.mythic.core.skills.conditions.CustomCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class SkillCondition
implements ISkillCondition {
    protected Optional<SkillHolder> parent = Optional.empty();
    protected String line;
    protected String conditionVar = "0";
    protected ConditionAction ACTION = ConditionAction.REQUIRED;
    protected PlaceholderString actionVar = null;
    protected ThreadSafetyLevel threadSafetyLevel = ThreadSafetyLevel.EITHER;

    public static MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    public SkillCondition(String line) {
        this.line = line;
        List<String> splitList = MythicUtil.splitIgnoringParentheses(line);
        if (splitList.size() < 2) {
            return;
        }
        if (ConditionAction.isAction(splitList.get(1))) {
            this.ACTION = ConditionAction.get(splitList.get(1));
            if (splitList.size() > 2) {
                this.actionVar = PlaceholderString.of(splitList.get(2));
            }
        } else {
            this.conditionVar = splitList.get(1);
            if (splitList.size() > 2 && ConditionAction.isAction(splitList.get(2))) {
                this.ACTION = ConditionAction.get(splitList.get(2));
                if (splitList.size() > 3) {
                    this.actionVar = PlaceholderString.of(splitList.get(3));
                }
            }
        }
    }

    public String getTypeName() {
        Class<?> clazz = this.getClass();
        if (clazz.isAnnotationPresent(MythicCondition.class)) {
            return clazz.getAnnotation(MythicCondition.class).name();
        }
        return clazz.getSimpleName();
    }

    public void setParent(SkillHolder parent) {
        this.parent = Optional.ofNullable(parent);
    }

    public boolean evaluateEntity(AbstractEntity t2) {
        try {
            CustomCondition customCondition;
            SkillCondition skillCondition = this;
            ISkillCondition condition = skillCondition instanceof CustomCondition && (customCondition = (CustomCondition)skillCondition).getCondition().isPresent() ? customCondition.getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                return this.handleOutcome(entityCondition.check(t2));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(locationCondition.check(t2.getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateToEntity(SkillMetadata data, AbstractEntity t2) {
        try {
            CustomCondition customCondition;
            SkillCondition skillCondition = this;
            ISkillCondition condition = skillCondition instanceof CustomCondition && (customCondition = (CustomCondition)skillCondition).getCondition().isPresent() ? customCondition.getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof ISkillMetaComparisonCondition) {
                return this.handleOutcome(((ISkillMetaComparisonCondition)condition).check(data, t2));
            }
            if (condition instanceof IEntityComparisonCondition) {
                return this.handleOutcome(((IEntityComparisonCondition)condition).check(data.getCaster().getEntity(), t2));
            }
            if (condition instanceof ILocationComparisonCondition) {
                ILocationComparisonCondition locationComparisonCondition = (ILocationComparisonCondition)condition;
                return this.handleOutcome(locationComparisonCondition.check(data.getCaster().getEntity().getLocation(), t2.getLocation()));
            }
            SkillCondition skillCondition2 = this;
            if (skillCondition2 instanceof IEntityLocationComparisonCondition) {
                IEntityLocationComparisonCondition entityLocationComparisonCondition = (IEntityLocationComparisonCondition)((Object)skillCondition2);
                return this.handleOutcome(entityLocationComparisonCondition.check(data.getCaster().getEntity(), t2.getLocation()));
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                return this.handleOutcome(entityCondition.check(t2));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(locationCondition.check(t2.getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateToEntity(AbstractEntity base, AbstractEntity t2) {
        try {
            CustomCondition customCondition;
            SkillCondition skillCondition = this;
            ISkillCondition condition = skillCondition instanceof CustomCondition && (customCondition = (CustomCondition)skillCondition).getCondition().isPresent() ? customCondition.getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof IEntityComparisonCondition) {
                return this.handleOutcome(((IEntityComparisonCondition)condition).check(base, t2));
            }
            if (condition instanceof ILocationComparisonCondition) {
                ILocationComparisonCondition locationComparisonCondition = (ILocationComparisonCondition)condition;
                return this.handleOutcome(locationComparisonCondition.check(base.getLocation(), t2.getLocation()));
            }
            SkillCondition skillCondition2 = this;
            if (skillCondition2 instanceof IEntityLocationComparisonCondition) {
                IEntityLocationComparisonCondition entityLocationComparisonCondition = (IEntityLocationComparisonCondition)((Object)skillCondition2);
                return this.handleOutcome(entityLocationComparisonCondition.check(base, t2.getLocation()));
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                return this.handleOutcome(entityCondition.check(t2));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(locationCondition.check(t2.getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateToLocation(AbstractEntity base, AbstractLocation location) {
        try {
            CustomCondition customCondition;
            SkillCondition skillCondition = this;
            ISkillCondition condition = skillCondition instanceof CustomCondition && (customCondition = (CustomCondition)skillCondition).getCondition().isPresent() ? customCondition.getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof ILocationComparisonCondition) {
                ILocationComparisonCondition locationComparisonCondition = (ILocationComparisonCondition)condition;
                return this.handleOutcome(locationComparisonCondition.check(base.getLocation(), location));
            }
            SkillCondition skillCondition2 = this;
            if (skillCondition2 instanceof IEntityLocationComparisonCondition) {
                IEntityLocationComparisonCondition entityLocationComparisonCondition = (IEntityLocationComparisonCondition)((Object)skillCondition2);
                return this.handleOutcome(entityLocationComparisonCondition.check(base, location));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(locationCondition.check(location));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateCaster(SkillMetadata meta) {
        try {
            CustomCondition customCondition;
            SkillCondition skillCondition = this;
            ISkillCondition condition = skillCondition instanceof CustomCondition && (customCondition = (CustomCondition)skillCondition).getCondition().isPresent() ? customCondition.getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof ISkillMetaComparisonCondition) {
                ISkillMetaComparisonCondition skillMetaComparisonCondition = (ISkillMetaComparisonCondition)condition;
                return this.handleOutcome(meta, skillMetaComparisonCondition.check(meta, meta.getCaster().getEntity()));
            }
            if (condition instanceof ISkillMetaCondition) {
                ISkillMetaCondition metaCondition = (ISkillMetaCondition)condition;
                return this.handleOutcome(meta, metaCondition.check(meta));
            }
            if (condition instanceof ICasterCondition) {
                ICasterCondition casterCondition = (ICasterCondition)condition;
                return this.handleOutcome(meta, casterCondition.check(meta.getCaster()));
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                return this.handleOutcome(meta, entityCondition.check(meta.getCaster().getEntity()));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(meta, locationCondition.check(meta.getCaster().getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateTrigger(SkillMetadata meta) {
        try {
            CustomCondition customCondition;
            SkillCondition skillCondition = this;
            ISkillCondition condition = skillCondition instanceof CustomCondition && (customCondition = (CustomCondition)skillCondition).getCondition().isPresent() ? customCondition.getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (meta.getTrigger() == null) {
                return false;
            }
            SkillCondition skillCondition2 = this;
            if (skillCondition2 instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)((Object)skillCondition2);
                return this.handleOutcome(meta, entityCondition.check(meta.getTrigger()));
            }
            skillCondition2 = this;
            if (skillCondition2 instanceof IEntityComparisonCondition) {
                IEntityComparisonCondition entityComparisonCondition = (IEntityComparisonCondition)((Object)skillCondition2);
                return this.handleOutcome(meta, entityComparisonCondition.check(meta.getCaster().getEntity(), meta.getTrigger()));
            }
            skillCondition2 = this;
            if (skillCondition2 instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)((Object)skillCondition2);
                return this.handleOutcome(meta, locationCondition.check(meta.getTrigger().getLocation()));
            }
            skillCondition2 = this;
            if (skillCondition2 instanceof ILocationComparisonCondition) {
                ILocationComparisonCondition locationComparisonCondition = (ILocationComparisonCondition)((Object)skillCondition2);
                return this.handleOutcome(meta, locationComparisonCondition.check(meta.getCaster().getLocation(), meta.getTrigger().getLocation()));
            }
            skillCondition2 = this;
            if (skillCondition2 instanceof IEntityLocationComparisonCondition) {
                IEntityLocationComparisonCondition entityLocationComparisonCondition = (IEntityLocationComparisonCondition)((Object)skillCondition2);
                return this.handleOutcome(meta, entityLocationComparisonCondition.check(meta.getCaster().getEntity(), meta.getTrigger().getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateTargets(SkillMetadata meta) {
        try {
            ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (meta.getEntityTargets() != null && meta.getEntityTargets().size() > 0) {
                HashSet targets = Sets.newHashSet(meta.getEntityTargets());
                targets.removeIf(target -> {
                    if (target == null || target.isDead() || !target.isValid()) {
                        return true;
                    }
                    if (condition instanceof IEntityCondition) {
                        IEntityCondition entityCondition = (IEntityCondition)condition;
                        return !this.handleOutcome(meta, entityCondition.check((AbstractEntity)target));
                    }
                    if (condition instanceof IEntityComparisonCondition) {
                        return !this.handleOutcome(meta, ((IEntityComparisonCondition)condition).check(meta.getCaster().getEntity(), (AbstractEntity)target));
                    }
                    if (condition instanceof ILocationCondition) {
                        ILocationCondition locationCondition = (ILocationCondition)condition;
                        return !this.handleOutcome(meta, locationCondition.check(target.getLocation()));
                    }
                    if (condition instanceof ILocationComparisonCondition) {
                        return !this.handleOutcome(meta, ((ILocationComparisonCondition)condition).check(meta.getCaster().getLocation(), target.getLocation()));
                    }
                    if (this instanceof IEntityLocationComparisonCondition) {
                        return this.handleOutcome(meta, ((IEntityLocationComparisonCondition)condition).check(meta.getCaster().getEntity(), target.getLocation()));
                    }
                    if (condition instanceof ISkillMetaComparisonCondition) {
                        return this.handleOutcome(meta, ((ISkillMetaComparisonCondition)condition).check(meta, (AbstractEntity)target));
                    }
                    return false;
                });
                meta.setEntityTargets(targets);
                if (targets.size() == 0) {
                    return false;
                }
            } else if (meta.getLocationTargets() != null && meta.getLocationTargets().size() > 0) {
                HashSet targets = Sets.newHashSet(meta.getLocationTargets());
                targets.removeIf(target -> {
                    if (condition instanceof ILocationCondition) {
                        ILocationCondition locationCondition = (ILocationCondition)condition;
                        return !this.handleOutcome(meta, locationCondition.check((AbstractLocation)target));
                    }
                    if (condition instanceof ILocationComparisonCondition) {
                        return !this.handleOutcome(meta, ((ILocationComparisonCondition)condition).check(meta.getCaster().getLocation(), (AbstractLocation)target));
                    }
                    if (this instanceof IEntityLocationComparisonCondition) {
                        return this.handleOutcome(meta, ((IEntityLocationComparisonCondition)condition).check(meta.getCaster().getEntity(), (AbstractLocation)target));
                    }
                    return false;
                });
                meta.setLocationTargets(targets);
                if (targets.size() == 0) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateRandomSpawnPoint(RandomSpawnPoint rsp) {
        try {
            ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                if (rsp.getEntity() != null) {
                    return this.handleOutcome(rsp, entityCondition.check(rsp.getEntity()));
                }
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                if (rsp.getLocation() != null) {
                    return this.handleOutcome(rsp, locationCondition.check(rsp.getLocation()));
                }
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateSpawner(MythicSpawner spawner) {
        try {
            ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(spawner, locationCondition.check(spawner.getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateDropper(DropMetadata meta) {
        try {
            if (!meta.getDropper().isPresent()) {
                return false;
            }
            SkillCaster dropper = meta.getDropper().get();
            ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof ICasterCondition) {
                return this.handleOutcome(meta, ((ICasterCondition)condition).check(dropper));
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                return this.handleOutcome(meta, entityCondition.check(dropper.getEntity()));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(meta, locationCondition.check(dropper.getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    public boolean evaluateDropCause(DropMetadata meta) {
        try {
            if (!meta.getCause().isPresent()) {
                return false;
            }
            AbstractEntity cause = meta.getCause().get();
            ISkillCondition condition = this instanceof CustomCondition && ((CustomCondition)this).getCondition().isPresent() ? ((CustomCondition)this).getCondition().get() : this;
            if (condition instanceof InvalidCondition) {
                return true;
            }
            if (condition instanceof IEntityCondition) {
                IEntityCondition entityCondition = (IEntityCondition)condition;
                return this.handleOutcome(meta, entityCondition.check(cause));
            }
            if (condition instanceof ILocationCondition) {
                ILocationCondition locationCondition = (ILocationCondition)condition;
                return this.handleOutcome(meta, locationCondition.check(cause.getLocation()));
            }
            return false;
        }
        catch (Error | Exception ex) {
            MythicLogger.errorCondition(this, "An internal error occurred", ex);
            return false;
        }
    }

    protected boolean handleOutcome(boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: {
                return !outcome;
            }
            case REQUIRED: {
                return outcome;
            }
        }
        return true;
    }

    protected boolean handleOutcome(SkillMetadata meta, boolean outcome) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Condition {0} outcome {1} action {2}", new Object[]{this.getTypeName(), outcome, this.ACTION});
        switch (this.ACTION) {
            case CAST: {
                if (!outcome) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "~ Outcome true, executing other cast", new Object[0]);
                Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (!maybeSkill.isPresent() || !maybeSkill.get().isUsable(meta)) break;
                maybeSkill.get().execute(meta);
                break;
            }
            case CASTINSTEAD: {
                if (!outcome) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "~ Outcome true, executing castInstead", new Object[0]);
                Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (maybeSkill.isPresent() && maybeSkill.get().isUsable(meta)) {
                    maybeSkill.get().execute(meta);
                }
                return false;
            }
            case ORELSECAST: {
                if (outcome) break;
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "~ Outcome false, executing orElseCast", new Object[0]);
                Optional<Skill> maybeSkill = MythicBukkit.inst().getSkillManager().getSkill(this.actionVar.get(meta));
                if (maybeSkill.isPresent() && maybeSkill.get().isUsable(meta)) {
                    maybeSkill.get().execute(meta);
                }
                return false;
            }
            case CANCEL: {
                if (outcome && this.actionVar != null && meta.getCaster().getEntity().isPlayer()) {
                    meta.getCaster().getEntity().asPlayer().sendMessage(this.actionVar.get(meta));
                }
                return !outcome;
            }
            case POWER: {
                if (!outcome) break;
                try {
                    float powerMod = Float.valueOf(this.actionVar.get(meta)).floatValue();
                    meta.setPower(meta.getPower() * powerMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: {
                if (!outcome && this.actionVar != null && meta.getCaster().getEntity().isPlayer()) {
                    meta.getCaster().getEntity().asPlayer().sendMessage(this.actionVar.get(meta));
                }
                return outcome;
            }
        }
        return true;
    }

    protected boolean handleOutcome(RandomSpawnPoint rsp, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: {
                return !outcome;
            }
            case LEVEL: {
                try {
                    float levelMod = Float.valueOf(this.actionVar.get()).floatValue();
                    rsp.setLevelMod(levelMod);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case REQUIRED: {
                return outcome;
            }
        }
        return true;
    }

    protected boolean handleOutcome(DropMetadata meta, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: {
                return !outcome;
            }
            case REQUIRED: {
                return outcome;
            }
        }
        return true;
    }

    protected boolean handleOutcome(MythicSpawner spawner, boolean outcome) {
        switch (this.ACTION) {
            case CANCEL: {
                return !outcome;
            }
            case REQUIRED: {
                return outcome;
            }
        }
        return true;
    }

    public void setAction(ConditionAction action) {
        this.ACTION = action;
    }

    public String getActionVariable() {
        return this.actionVar.get();
    }

    public Optional<SkillHolder> getParent() {
        return this.parent;
    }

    public String getLine() {
        return this.line;
    }

    public String getConditionVar() {
        return this.conditionVar;
    }

    public void setConditionVar(String conditionVar) {
        this.conditionVar = conditionVar;
    }

    public ConditionAction getACTION() {
        return this.ACTION;
    }

    public PlaceholderString getActionVar() {
        return this.actionVar;
    }

    public void setActionVar(PlaceholderString actionVar) {
        this.actionVar = actionVar;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return this.threadSafetyLevel;
    }
}

