/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.triggers.meta.EmptyMetadata;
import java.util.Optional;

public class EventExecutor
extends ReloadableModule<MythicBukkit> {
    public EventExecutor(MythicBukkit plugin, SkillExecutor manager) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit mythicBukkit) {
    }

    @Override
    public void unload() {
    }

    public TriggeredSkill processTrigger(SkillTrigger trigger, SkillCaster caster, AbstractEntity triggerEntity) {
        return this.processTrigger(trigger, new EmptyMetadata(), caster, triggerEntity, caster.getLocation(), false);
    }

    public TriggeredSkill processTrigger(SkillTrigger trigger, SkillCaster caster, AbstractEntity triggerEntity, boolean sync) {
        return this.processTrigger(trigger, new EmptyMetadata(), caster, triggerEntity, caster.getLocation(), sync);
    }

    public TriggeredSkill processTrigger(SkillTrigger trigger, SkillTriggerMetadata triggerMetadata, SkillCaster caster, AbstractEntity triggerEntity, boolean sync) {
        return this.processTrigger(trigger, triggerMetadata, caster, triggerEntity, caster.getLocation(), sync);
    }

    public TriggeredSkill processTrigger(SkillTrigger trigger, SkillTriggerMetadata triggerMetadata, SkillCaster caster, AbstractEntity triggerEntity, AbstractLocation origin, boolean sync) {
        Optional<StatRegistry> maybeRegistry = ((MythicBukkit)this.getPlugin()).getStatManager().getStatRegistry(caster.getEntity());
        if (maybeRegistry.isPresent()) {
            StatRegistry statRegistry = maybeRegistry.get();
            for (StatType stat : statRegistry.getApplicableStats()) {
                stat.processTrigger(triggerMetadata);
            }
        }
        SkillMetadataImpl data = new SkillMetadataImpl(trigger, caster, triggerEntity);
        if (sync) {
            data.setIsAsync(false);
        } else {
            data.setIsAsync(true);
        }
        if (triggerEntity != null) {
            data.setEntityTarget(triggerEntity);
        }
        triggerMetadata.applyToSkillMetadata(data);
        TriggeredSkill triggeredSkill = new TriggeredSkill(data);
        if (caster instanceof ActiveMob) {
            ActiveMob activeMob = (ActiveMob)caster;
            if (triggerEntity != null) {
                ((ActiveMob)caster).setLastAggroCause(triggerEntity);
            }
            data.setPower(activeMob.getPower());
            MythicLogger.debug(MythicLogger.DebugLevel.TRIGGER, "Skill Trigger {0} fired for ActiveMob {1} (uuid: {2})", trigger, activeMob.getDisplayName(), activeMob.getUniqueId());
            activeMob.getType().executeSkills(data.getCause(), data);
        }
        return triggeredSkill;
    }
}

