/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.targeters.ISkillTargeter;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicTargeterLoadEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomComponentRegistry {
    private final Map<String, Constructor<? extends ISkillMechanic>> mechanics = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillCondition>> conditions = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillTargeter>> targeters = Maps.newConcurrentMap();

    public CustomComponentRegistry(JavaPlugin plugin, String packagePath) {
        this(plugin, Lists.newArrayList((Object[])new String[]{packagePath}));
    }

    public CustomComponentRegistry(JavaPlugin plugin, Collection<String> packages) {
        for (String packagePath : packages) {
            Collection<Class<?>> mechanicsClasses = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicMechanic.class);
            for (Class<?> clazz : mechanicsClasses) {
                try {
                    String name = clazz.getAnnotation(MythicMechanic.class).name();
                    String[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                    if (!ISkillMechanic.class.isAssignableFrom(clazz)) continue;
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz.getConstructor(plugin.getClass(), MythicMechanicLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz.getConstructor(MythicMechanicLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.mechanics.put(name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.mechanics.put(alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to register custom mechanic {0}", clazz.getCanonicalName());
                    ex.printStackTrace();
                }
            }
            Collection<Class<?>> conditionClasses = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicCondition.class);
            for (Class<?> clazz3 : conditionClasses) {
                try {
                    String name = clazz3.getAnnotation(MythicCondition.class).name();
                    String[] aliases = clazz3.getAnnotation(MythicCondition.class).aliases();
                    if (!ISkillCondition.class.isAssignableFrom(clazz3)) continue;
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz3.getConstructor(plugin.getClass(), MythicConditionLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz3.getConstructor(MythicConditionLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.conditions.put(name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.conditions.put(alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to register custom condition {0}", clazz3.getCanonicalName());
                    ex.printStackTrace();
                }
            }
            Collection<Class<?>> collection = AnnotationUtil.getAnnotatedClasses(plugin, packagePath, MythicTargeter.class);
            for (Class<?> clazz4 : collection) {
                try {
                    String name = clazz4.getAnnotation(MythicTargeter.class).name();
                    String[] aliases = clazz4.getAnnotation(MythicTargeter.class).aliases();
                    if (!ISkillTargeter.class.isAssignableFrom(clazz4)) continue;
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz4.getConstructor(plugin.getClass(), MythicTargeterLoadEvent.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz4.getConstructor(MythicTargeterLoadEvent.class);
                    }
                    if (constructor == null) continue;
                    this.targeters.put(name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.targeters.put(alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error("Failed to register custom targeter {0}", clazz4.getCanonicalName());
                    ex.printStackTrace();
                }
            }
        }
        Events.subscribe(MythicMechanicLoadEvent.class).handler(event -> {
            String name = event.getMechanicName().toUpperCase();
            if (this.mechanics.containsKey(name)) {
                Constructor<? extends ISkillMechanic> constructor = this.mechanics.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct mechanic {0}", name);
                    e.printStackTrace();
                }
            }
        });
        Events.subscribe(MythicConditionLoadEvent.class).handler(event -> {
            String name = event.getConditionName().toUpperCase();
            if (this.conditions.containsKey(name)) {
                Constructor<? extends ISkillCondition> constructor = this.conditions.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct condition {0}", name);
                    e.printStackTrace();
                }
            }
        });
        Events.subscribe(MythicTargeterLoadEvent.class).handler(event -> {
            String name = event.getTargeterName().toUpperCase();
            if (this.targeters.containsKey(name)) {
                Constructor<? extends ISkillTargeter> constructor = this.targeters.get(name);
                try {
                    if (constructor.getParameterCount() == 2) {
                        event.register(constructor.newInstance(plugin, event));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                }
                catch (Exception e) {
                    MythicLogger.error("Failed to construct targeter {0}", name);
                    e.printStackTrace();
                }
            }
        });
    }
}

