/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillHelper;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.conditions.ConditionAction;
import io.lumine.mythic.core.skills.targeters.ConsoleTargeter;
import io.lumine.mythic.core.skills.targeters.CustomTargeter;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.skills.targeters.OriginTargeter;
import io.lumine.mythic.core.skills.targeters.TriggerLocationTargeter;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;

public abstract class AbstractSkill
implements SkillHolder {
    protected ThreadSafetyLevel threadSafetyLevel = ThreadSafetyLevel.EITHER;
    private final MythicBukkit plugin;
    private final SkillExecutor manager;
    protected final UUID uuid;
    protected final File file;
    protected Optional<SkillHolder> parent = Optional.empty();
    @MythicField(name="cooldown", aliases={"cd"}, description="The cooldown of the mechanic in seconds. Accepts decimals.", defValue="0")
    protected PlaceholderDouble cooldown = null;
    @MythicField(name="power", description="The power multiplier of the mechanic", defValue="1")
    protected float power = 1.0f;
    @MythicField(name="delay", description="Delays the execution of the mechanic by a set number of ticks", defValue="0")
    protected PlaceholderInt delay = PlaceholderInt.of("0");
    @MythicField(name="repeat", description="The amount of repetitions the mechanic will do")
    protected PlaceholderInt repeat = PlaceholderInt.of("0");
    @MythicField(name="repeatInterval", aliases={"repeatI"}, description="The amount of ticks must elapse between repetitions")
    protected PlaceholderInt repeatInterval = PlaceholderInt.of("0");
    @MythicField(name="targetInterval", aliases={"targetI"}, description="The amount of ticks must elapse between target selection")
    protected PlaceholderDouble targetInterval = PlaceholderDouble.of("0");
    @MythicField(name="chance", description="The likelihood of the mechanic executing. 1 = 100%, 0.5 = 50%")
    protected float chance = 1.0f;
    protected String healthMod = null;
    @MythicField(name="splitPower", aliases={"powersplitbetweentargets", "powersplit"}, description="Whether to split the power between targets")
    protected boolean powerSplitBetweenTargets = false;
    protected SkillTrigger trigger = SkillTriggers.COMBAT;
    @MythicField(name="sourceIsOrigin", aliases={"powersplitbetweentargets", "powersplit"}, description="Whether to split the power between targets")
    protected boolean sourceIsOrigin = false;
    protected Map<UUID, Long> cooldowns = Maps.newConcurrentMap();
    protected Optional<SkillTargeter> targeter = Optional.empty();
    @MythicField(name="targetCreative", description="Whether to target creative players")
    protected boolean target_creative = false;
    protected List<SkillCondition> conditions = null;
    protected List<SkillCondition> conditionsTarget = null;
    protected List<SkillCondition> conditionsTrigger = null;

    public AbstractSkill(SkillExecutor manager, File file) {
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.file = file;
        this.uuid = UUID.randomUUID();
    }

    public String getFilePath() {
        return this.file == null ? "Unknown" : this.file.getAbsolutePath();
    }

    public void setParent(SkillHolder parent) {
        this.parent = Optional.ofNullable(parent);
    }

    public void triggerCooldown(SkillMetadata data) {
        if (this.cooldown != null) {
            this.setCooldown(data.getCaster(), this.cooldown.get(data));
        }
    }

    public boolean onCooldown(SkillCaster skillCaster) {
        return this.getCooldown(skillCaster) > 0.0f;
    }

    public float getCooldown(SkillCaster skillCaster) {
        long last;
        if (this.cooldown == null) {
            return 0.0f;
        }
        long time = System.currentTimeMillis();
        if (time >= (last = this.cooldowns.getOrDefault(skillCaster.getEntity().getUniqueId(), 0L).longValue())) {
            return 0.0f;
        }
        return (float)(last - time) / 1000.0f;
    }

    public void setCooldown(SkillCaster skillCaster, double cooldown) {
        if (cooldown > 0.0) {
            this.cooldowns.put(skillCaster.getEntity().getUniqueId(), (long)((double)System.currentTimeMillis() + cooldown * 1000.0));
        } else {
            this.cooldowns.remove(skillCaster.getEntity().getUniqueId());
        }
    }

    protected boolean rollChance() {
        if (this.chance == 1.0f) {
            return true;
        }
        return !(Numbers.randomDouble() > (double)this.chance);
    }

    protected boolean checkHealth(SkillCaster skillCaster) {
        String[] healthparts;
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Performing Health Check", new Object[0]);
        if (this.healthMod == null) {
            return true;
        }
        String[] stringArray = healthparts = this.healthMod.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double bosshp;
            String health;
            String healthT = health = stringArray[i];
            String skillstr = skillCaster.getEntity().getUniqueId() + this.uuid.toString() + "#" + health;
            healthT = healthT.replace("%", "");
            healthT = healthT.replace("<", "");
            healthT = healthT.replace(">", "");
            healthT = healthT.replace("=", "");
            if (!(healthT = healthT.replace("-", "")).matches("[-+]?[0-9]*.?[0-9]+")) {
                return true;
            }
            double hp = Double.parseDouble(healthT);
            if (health.endsWith("%")) {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / 100.0;
            } else {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / skillCaster.getEntity().getMaxHealth();
            }
            if (health.startsWith(">")) {
                health = health.replace(">", "");
                if (!(bosshp > hp)) continue;
                return true;
            }
            if (health.startsWith("<")) {
                health = health.replace("<", "");
                if (!(bosshp < hp)) continue;
                return true;
            }
            if (health.startsWith("=")) {
                if ((health = health.replace("=", "")).contains("-")) {
                    String[] hps = health.split("-");
                    double hp1 = hps[0].endsWith("%") ? Double.parseDouble(hps[0].substring(0, hps[0].length() - 1)) / 100.0 : Double.parseDouble(hps[0].substring(0, hps[0].length())) / skillCaster.getEntity().getMaxHealth();
                    double hp2 = hps[1].endsWith("%") ? Double.parseDouble(hps[1].substring(0, hps[1].length() - 1)) / 100.0 : Double.parseDouble(hps[1].substring(0, hps[1].length())) / skillCaster.getEntity().getMaxHealth();
                    if (hp2 > hp1) {
                        double hp3 = hp1;
                        hp1 = hp2;
                        hp2 = hp3;
                    }
                    if (!(bosshp > hp2) || !(bosshp < hp1)) continue;
                    return true;
                }
                if (!(bosshp <= hp) || !(skillCaster.getEntity().getHealth() > hp) || SkillHelper.hasUsedSkill(skillstr, skillCaster.getEntity())) continue;
                if (skillCaster instanceof ActiveMob && !((ActiveMob)skillCaster).getType().getRepeatAllSkills().booleanValue()) {
                    MythicBukkit.inst().getMobManager();
                    MobExecutor.setMetaData(skillCaster.getEntity(), skillstr, skillstr);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean checkSkillTrigger(SkillTrigger trigger) {
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", trigger, this.trigger);
        if (trigger.equals(SkillTriggers.SIGNAL)) {
            return true;
        }
        if (SkillTriggers.TIMER.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.API.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SIGNAL.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SPAWN.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD);
        }
        if (SkillTriggers.COMBAT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK);
        }
        if (SkillTriggers.KILL.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.KILL) || trigger.equals(SkillTriggers.KILLPLAYER);
        }
        if (SkillTriggers.DEFAULT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK) || trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD) || trigger.equals(SkillTriggers.DEATH) || trigger.equals(SkillTriggers.TIMER);
        }
        return this.trigger.equals(trigger);
    }

    protected boolean checkSkillTrigger(SkillMetadata meta) {
        SkillTrigger trigger = meta.getCause();
        if (trigger == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "+ Provided SkillTrigger is null", new Object[0]);
            return true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "? Checking SkillTrigger {0} == {1}", trigger, this.trigger);
        if (trigger.equals(SkillTriggers.SIGNAL) || trigger.equals(SkillTriggers.API)) {
            return true;
        }
        if (SkillTriggers.TIMER.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SIGNAL.equals(this.trigger)) {
            return true;
        }
        if (SkillTriggers.SPAWN.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD);
        }
        if (SkillTriggers.COMBAT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK);
        }
        if (SkillTriggers.KILL.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.KILL) || trigger.equals(SkillTriggers.KILLPLAYER);
        }
        if (SkillTriggers.DEFAULT.equals(this.trigger)) {
            return trigger.equals(SkillTriggers.DAMAGED) || trigger.equals(SkillTriggers.ATTACK) || trigger.equals(SkillTriggers.SPAWN) || trigger.equals(SkillTriggers.LOAD) || trigger.equals(SkillTriggers.DEATH) || trigger.equals(SkillTriggers.TIMER);
        }
        return this.trigger.equals(trigger);
    }

    protected SkillTrigger parseSkillTrigger(String strTrigger) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillTrigger {0}", strTrigger);
        String search = strTrigger.contains(":") ? strTrigger.substring(3, strTrigger.indexOf(":")).toUpperCase() : strTrigger.substring(3).toUpperCase();
        return SkillTrigger.get(search);
    }

    protected SkillTargeter parseSkillTargeter(String strTarget) {
        return this.getPlugin().getSkillManager().getTargeter(strTarget);
    }

    protected SkillCondition parseSkillCondition(String strCondition) {
        String search = strCondition.substring(1);
        boolean n = false;
        if (search.startsWith("!")) {
            search = search.substring(1);
            n = true;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, ": Parsing SkillCondition {0}", search);
        SkillCondition cond = this.getPlugin().getSkillManager().getCondition(search);
        if (cond != null && n) {
            cond.setAction(ConditionAction.CANCEL);
        }
        return cond;
    }

    public void setTargetsCreativePlayers(boolean b) {
        this.target_creative = b;
    }

    public boolean targetsCreativePlayers() {
        return this.target_creative;
    }

    public SkillMetadata evaluateTargets(SkillMetadata data) {
        if (this.targeter.isPresent()) {
            return this.evaluateTargets(data, this.targeter.get());
        }
        return data;
    }

    public SkillMetadata evaluateTargets(SkillMetadata data, SkillTargeter targeter) {
        SkillCaster originalCaster;
        block16: {
            originalCaster = data.getCaster();
            SkillCaster skillCaster = data.getCaster();
            if (skillCaster instanceof ActiveMob) {
                ActiveMob activeCaster = (ActiveMob)skillCaster;
                if (targeter.isSudoParent()) {
                    activeCaster.getParent().ifPresent(parent -> data.setCaster(this.getPlugin().getSkillManager().getCaster((AbstractEntity)parent)));
                }
                if (targeter.isSudoOwner()) {
                    activeCaster.getOwner().ifPresent(owner -> {
                        AbstractEntity ownerEntity = MythicBukkit.inst().getBootstrap().getEntity((UUID)owner);
                        if (ownerEntity != null) {
                            data.setCaster(this.getPlugin().getSkillManager().getCaster(ownerEntity));
                        }
                    });
                }
                if (targeter.isSudoTrigger() && data.getTrigger() != null) {
                    data.setCaster(this.getPlugin().getSkillManager().getCaster(data.getTrigger()));
                }
            }
            if (targeter instanceof CustomTargeter && ((CustomTargeter)targeter).getTargeter().isPresent()) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": SkillTargeter is a CUSTOM targeter", new Object[0]);
                targeter = ((CustomTargeter)targeter).getTargeter().get();
            }
            if (targeter instanceof IEntitySelector) {
                try {
                    data.setEntityTargets(((IEntitySelector)targeter).getEntities(data));
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": EntityTargeter found {0} targets", data.getEntityTargets().size());
                    ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
                }
                catch (IllegalArgumentException ex) {
                    data.setEntityTargets(Sets.newHashSet());
                    MythicBukkit.inst().getConfiguration();
                    if (ConfigExecutor.debugLevel <= 0) break block16;
                    ex.printStackTrace();
                }
            }
        }
        if (targeter instanceof ILocationSelector) {
            data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": LocationTargeter found {0} targets", data.getLocationTargets().size());
            ((ILocationSelector)targeter).filter(data);
        } else if (targeter instanceof OriginTargeter) {
            data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting origin", new Object[0]);
        } else if (targeter instanceof TriggerLocationTargeter) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting trigger location", new Object[0]);
            HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
            lTargets.add(data.getTrigger().getLocation());
            data.setLocationTargets(lTargets);
        }
        if (targeter instanceof ConsoleTargeter) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, ": Targeting console", new Object[0]);
            data.setEntityTargets(null);
            data.setLocationTargets(null);
        }
        if (data.getEntityTargets() != null && !data.getEntityTargets().isEmpty() && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getEntityTargets().size());
        }
        if (data.getLocationTargets() != null && !data.getLocationTargets().isEmpty() && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getLocationTargets().size());
        }
        data.setCaster(originalCaster);
        return data;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return this.threadSafetyLevel;
    }

    public void setThreadSafetyLevel(ThreadSafetyLevel threadSafetyLevel) {
        this.threadSafetyLevel = threadSafetyLevel;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public SkillExecutor getManager() {
        return this.manager;
    }

    public File getFile() {
        return this.file;
    }

    public Optional<SkillHolder> getParent() {
        return this.parent;
    }

    public SkillTrigger getTrigger() {
        return this.trigger;
    }

    public Optional<SkillTargeter> getTargeter() {
        return this.targeter;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public List<SkillCondition> getConditionsTarget() {
        return this.conditionsTarget;
    }

    public List<SkillCondition> getConditionsTrigger() {
        return this.conditionsTrigger;
    }

    protected static class DelayedSkill
    implements Runnable {
        private SkillMetadata data;
        private Queue<SkillMechanic> skills;
        private boolean cancelled;

        public DelayedSkill(SkillMetadata data, Queue<SkillMechanic> skills) {
            this.data = data;
            this.skills = skills;
            this.cancelled = false;
        }

        public void cancel() {
            this.skills = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                try {
                    if (this.data.getCaster().getEntity().isDead() && !this.data.getCause().equals(SkillTriggers.DEATH) && !this.data.getCause().equals(SkillTriggers.DESPAWNED) && !this.data.getCause().equals(SkillTriggers.EXPLODE)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Mob is dead, cancelling skill (cause = {0})", this.data.getCause());
                        this.cancel();
                        return;
                    }
                    MetaSkill.execute(this.data, this.skills);
                }
                catch (NullPointerException ex) {
                    this.cancel();
                    ex.printStackTrace();
                }
                return;
            }
        }
    }
}

