/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.players;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicPlayerLoadedEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.storage.players.PlayerRepository;
import io.lumine.mythic.bukkit.utils.storage.players.adapters.file.JsonPlayerStorageAdapter;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.players.factions.FactionProvider;
import io.lumine.mythic.core.players.factions.PermissionFactionProvider;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerManager
extends PlayerRepository<MythicBukkit, PlayerData> {
    protected FactionProvider factionProvider = new PermissionFactionProvider();
    protected Map<UUID, PlayerMovementData> playerPositions = Maps.newConcurrentMap();
    private AtomicBoolean trackingPlayerMovement = new AtomicBoolean(false);
    private ReentrantLock activationLock = new ReentrantLock();

    public PlayerManager(MythicBukkit plugin) {
        super(plugin, PlayerData.class);
        JsonPlayerStorageAdapter<MythicBukkit, PlayerData> storageAdapter = new JsonPlayerStorageAdapter<MythicBukkit, PlayerData>(plugin, PlayerData.class);
        storageAdapter.setDataDirectory("SavedData");
        this.initialize(storageAdapter);
    }

    @Override
    public PlayerData createProfile(UUID id, String name) {
        return new PlayerData(id, name);
    }

    @Override
    public void initProfile(PlayerData profile, Player player) {
        profile.initialize(BukkitAdapter.adapt(player));
        Events.call(new MythicPlayerLoadedEvent(player, profile));
    }

    public PlayerData getProfile(AbstractPlayer player) {
        return (PlayerData)this.getProfile(BukkitAdapter.adapt(player));
    }

    @Override
    public void unloadProfile(PlayerData profile, Player player) {
    }

    public void registerFactionProvider(FactionProvider provider) {
        this.factionProvider = provider;
    }

    public void trackPlayerMovement() {
        if (!this.trackingPlayerMovement.getAndSet(true)) {
            Events.subscribe(PlayerMoveEvent.class, EventPriority.MONITOR).filter(event -> !event.isCancelled()).handler(event -> this.playerPositions.put(event.getPlayer().getUniqueId(), new PlayerMovementData(event.getFrom(), event.getTo()))).bindWith(this);
            Events.subscribe(PlayerQuitEvent.class).handler(event -> {
                Player player = event.getPlayer();
                UUID uuid = player.getUniqueId();
                this.playerPositions.remove(uuid);
            }).bindWith(this);
        }
    }

    public FactionProvider getFactionProvider() {
        return this.factionProvider;
    }

    public Map<UUID, PlayerMovementData> getPlayerPositions() {
        return this.playerPositions;
    }

    public class PlayerMovementData {
        private final long lastMovementTime = System.currentTimeMillis();
        private final Location from;
        private final Location to;

        public PlayerMovementData(Location from, Location to) {
            this.from = from;
            this.to = to;
        }

        public long getLastMovementTime() {
            return this.lastMovementTime;
        }

        public Location getFrom() {
            return this.from;
        }

        public Location getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerMovementData)) {
                return false;
            }
            PlayerMovementData other = (PlayerMovementData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLastMovementTime() != other.getLastMovementTime()) {
                return false;
            }
            Location this$from = this.getFrom();
            Location other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            Location this$to = this.getTo();
            Location other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlayerMovementData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastMovementTime = this.getLastMovementTime();
            result = result * 59 + (int)($lastMovementTime >>> 32 ^ $lastMovementTime);
            Location $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            Location $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        public String toString() {
            return "PlayerManager.PlayerMovementData(lastMovementTime=" + this.getLastMovementTime() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

