/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.bukkit.compatibility.WorldGuardSupport;
import io.lumine.mythic.bukkit.events.MythicMobPreSpawnEvent;
import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import io.lumine.mythic.core.menus.mobs.MobMenuContext;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.DespawnMode;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.mobs.model.MPetsModel;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MobType
implements MythicMob,
SkillHolder,
MenuData<MobMenuContext> {
    private final MythicBukkit plugin;
    private final MobExecutor manager;
    private Pack pack;
    private File file;
    private MythicConfig config;
    private String internalName;
    private ItemStack cachedMenuItem;
    protected String entityTypeString;
    protected MythicEntityType entityType;
    protected BukkitEntityType entityBaseSpawner;
    protected PlaceholderString displayName;
    private String eggDisplay;
    protected String faction;
    private MobModel model;
    private DropTable dropTable;
    private DropTable equipmentTable;
    protected PlaceholderDouble attrHealth;
    protected PlaceholderDouble attrDamage;
    protected PlaceholderDouble attrArmor;
    protected PlaceholderDouble attrMovementSpeed;
    protected PlaceholderDouble attrFlyingSpeed;
    protected double attrKnockbackResist;
    protected double attrFollowRange;
    protected double attrAttackSpeed;
    protected double optionReviveHealth;
    protected double lvlModDamage;
    protected double lvlModHealth;
    protected double lvlModArmor;
    protected double lvlModKBR;
    protected double lvlModPower;
    protected double lvlModSpeed;
    protected double lvlModAttackSpeed;
    protected DespawnMode despawnMode;
    protected boolean optionShowHealthInChat;
    protected boolean optionSilent;
    protected boolean optionNoAI;
    protected boolean optionGlowing;
    protected boolean optionInvincible;
    protected boolean optionCollidable;
    protected boolean optionNoGravity;
    protected boolean optionInteractable;
    protected boolean optionHealOnReload;
    protected Boolean optionLockPitch;
    protected boolean useBossBar;
    protected int bossBarRange;
    protected int bossBarRangeSq;
    protected PlaceholderString bossBarTitle;
    protected AbstractBossBar.BarColor bossBarColor;
    protected AbstractBossBar.BarStyle bossBarStyle;
    protected boolean bossBarCreateFog;
    protected boolean bossBarDarkenSky;
    protected boolean bossBarPlayMusic;
    protected Optional<String> mount;
    protected Optional<String> rider;
    private Map<String, PlaceholderDouble> stats;
    private Map<String, Double> damageModifiers;
    private Map<String, Double> entityDamageModifiers;
    private List<String> levelmods;
    private List<String> aiGoalSelectors;
    private List<String> aiTargetSelectors;
    private Map<String, Float> aiPathfindingMalus;
    private String aiNavigator;
    private boolean hasCombatSkills;
    private Map<SkillTrigger, Queue<SkillMechanic>> skills;
    private Queue<SkillMechanic> timerSkills;
    private Map<String, List<SkillMechanic>> signalSkills;
    private boolean usingTimers;
    int size;
    private int noDamageTicks;
    private int maxAttackRange;
    private int maxAttackableRange;
    private int maxThreatDistance;
    private boolean alwaysShowName;
    private boolean showNameOnDamage;
    private boolean useThreatTable;
    private boolean useImmunityTable;
    private boolean useCustomNameplate;
    private boolean optionTTFromDamage;
    private boolean optionTTDecayUnreachable;
    private Boolean repeatAllSkills;
    private Boolean preventOtherDrops;
    private Boolean preventRandomEquipment;
    private Boolean preventLeashing;
    private Boolean preventRename;
    private Boolean preventEndermanTeleport;
    private Boolean preventItemPickup;
    private Boolean preventSilverfishInfection;
    private Boolean preventSunburn;
    private Boolean preventExploding;
    private Boolean preventMobKillDrops;
    private Boolean preventTransformation;
    private Boolean preventMounts;
    private Boolean passthroughDamage;
    private Boolean applyInvisibility;
    private Boolean digOutOfGround;
    private Boolean usesHealthBar;
    protected double spawnVelocityX;
    protected double spawnVelocityXMax;
    protected double spawnVelocityY;
    protected double spawnVelocityYMax;
    protected double spawnVelocityZ;
    protected double spawnVelocityZMax;
    protected Boolean spawnVelocityXRange;
    protected Boolean spawnVelocityYRange;
    protected Boolean spawnVelocityZRange;
    protected List<PlaceholderString> killMessages;
    private String disguise;
    private boolean fakePlayer;
    private final transient ReentrantLock skillLock;

    public MobType(MobExecutor manager, Pack pack, File file, String internalName, MythicConfig mc) {
        block83: {
            List<String> list;
            List<String> list2;
            List<String> list3;
            this.faction = null;
            this.despawnMode = DespawnMode.NORMAL;
            this.optionShowHealthInChat = false;
            this.optionSilent = false;
            this.optionNoAI = false;
            this.optionGlowing = false;
            this.optionInvincible = false;
            this.optionCollidable = true;
            this.optionNoGravity = true;
            this.optionInteractable = true;
            this.optionHealOnReload = false;
            this.optionLockPitch = false;
            this.useBossBar = false;
            this.mount = Optional.empty();
            this.rider = Optional.empty();
            this.levelmods = Lists.newArrayList();
            this.aiGoalSelectors = Lists.newArrayList();
            this.aiTargetSelectors = Lists.newArrayList();
            this.aiPathfindingMalus = Maps.newConcurrentMap();
            this.hasCombatSkills = false;
            this.skills = Maps.newConcurrentMap();
            this.timerSkills = Queues.newConcurrentLinkedQueue();
            this.signalSkills = Maps.newConcurrentMap();
            this.usingTimers = false;
            this.alwaysShowName = true;
            this.showNameOnDamage = true;
            this.optionTTFromDamage = true;
            this.optionTTDecayUnreachable = true;
            this.repeatAllSkills = false;
            this.preventOtherDrops = false;
            this.preventRandomEquipment = false;
            this.preventLeashing = false;
            this.preventRename = true;
            this.preventEndermanTeleport = true;
            this.preventItemPickup = true;
            this.preventSilverfishInfection = true;
            this.preventSunburn = false;
            this.preventExploding = false;
            this.preventMobKillDrops = false;
            this.preventTransformation = true;
            this.preventMounts = false;
            this.passthroughDamage = false;
            this.applyInvisibility = false;
            this.digOutOfGround = false;
            this.usesHealthBar = false;
            this.spawnVelocityX = 0.0;
            this.spawnVelocityXMax = 0.0;
            this.spawnVelocityY = 0.0;
            this.spawnVelocityYMax = 0.0;
            this.spawnVelocityZ = 0.0;
            this.spawnVelocityZMax = 0.0;
            this.spawnVelocityXRange = false;
            this.spawnVelocityYRange = false;
            this.spawnVelocityZRange = false;
            this.disguise = null;
            this.fakePlayer = false;
            this.skillLock = new ReentrantLock();
            this.plugin = (MythicBukkit)manager.getPlugin();
            this.manager = manager;
            this.pack = pack;
            this.config = mc;
            this.file = file;
            this.internalName = internalName;
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading MythicMob type '{0}'...", this.internalName);
            this.entityTypeString = mc.getString(new String[]{"Type", "MobType", "Mobtype"}, this.entityTypeString, new String[0]);
            if (this.entityTypeString == null) {
                BukkitEntityType me = BukkitEntityType.getMythicEntity(internalName);
                if (me == null) {
                    MythicLogger.errorMobConfig(this, mc, "Could not load MythicMob " + this.internalName + "! No Type specified.");
                    this.entityTypeString = "NULL";
                    this.entityType = MythicEntityType.COD;
                    this.entityBaseSpawner = BukkitEntityType.getMythicEntity(MythicEntityType.COD);
                    this.displayName = PlaceholderString.of("ERROR: MOB TYPE FOR '" + this.internalName + "' IS NOT OPTIONAL");
                    return;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ EntityType is vanilla override for {0}", this.entityTypeString);
                this.entityType = MythicEntityType.get(internalName);
                this.entityBaseSpawner = me;
            } else {
                this.getManager();
                this.entityTypeString = MobExecutor.convertMobTypeAliases(this.entityTypeString);
                this.entityType = MythicEntityType.get(this.entityTypeString);
                this.entityBaseSpawner = BukkitEntityType.getMythicEntity(this.entityType);
            }
            if (this.entityBaseSpawner == null) {
                MythicLogger.error("Could not load MythicMob {0}! Invalid type specified.", this.internalName);
                this.entityTypeString = "NULL";
                this.entityType = MythicEntityType.COD;
                this.entityBaseSpawner = BukkitEntityType.getMythicEntity(MythicEntityType.COD);
                this.displayName = PlaceholderString.of("ERROR: MOB TYPE FOR '" + this.internalName + "' IS INVALID");
                return;
            }
            this.entityBaseSpawner.instantiate(mc);
            String strDisplayName = mc.getString("Display", this.displayName == null ? null : this.displayName.toString());
            strDisplayName = mc.getString("DisplayName", strDisplayName);
            if (strDisplayName != null) {
                this.displayName = PlaceholderString.of(strDisplayName);
            }
            if (mc.isSet("Model")) {
                Schedulers.sync().runLater(() -> {
                    if (mc.isSet("Model.Type")) {
                        String modelType = mc.getString("Model.Type").toUpperCase();
                        if (modelType.startsWith("MPE") || modelType.equalsIgnoreCase("MINIATUREPE")) {
                            if (((MythicBukkit)manager.getPlugin()).getCompatibility().getMiniaturePets().isPresent()) {
                                this.model = new MPetsModel(this, mc);
                            }
                        } else if (((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().isPresent()) {
                            this.model = ((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().get().createMobModel(this, mc);
                        }
                    } else if (((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().isPresent()) {
                        this.model = ((MythicBukkit)manager.getPlugin()).getCompatibility().getModelEngine().get().createMobModel(this, mc);
                    }
                }, 1L);
            } else {
                this.model = null;
            }
            this.eggDisplay = mc.getString("MythicEggDisplay", this.internalName);
            this.attrHealth = mc.getPlaceholderDouble("Health", null);
            this.attrDamage = mc.getPlaceholderDouble("Damage", null);
            this.attrArmor = mc.getPlaceholderDouble(new String[]{"Armor", "Armour"}, null, new String[0]);
            this.optionReviveHealth = mc.getDouble("Options.ReviveHealth", 10.0);
            this.optionInvincible = mc.getBoolean("Options.Invincible", false);
            this.optionInvincible = mc.getBoolean("Options.Invulnerable", this.optionInvincible);
            this.faction = mc.getString("Faction", null);
            String mount = mc.getString("Mount", null);
            mount = mc.getString("Riding", mount);
            this.mount = Optional.ofNullable(mount);
            String rider = mc.getString("Rider", null);
            rider = mc.getString("Passenger", rider);
            this.rider = Optional.ofNullable(rider);
            boolean despawnByDefault = this.getPlugin().getConfiguration().getDespawnMobsByDefault();
            String shouldDespawn = mc.getString("Despawn", despawnByDefault ? "TRUE" : "FALSE");
            shouldDespawn = mc.getString("Options.Despawn", shouldDespawn);
            boolean isPersistent = mc.getBoolean("Persistent", false);
            isPersistent = mc.getBoolean("Options.Persistent", isPersistent);
            if (isPersistent) {
                shouldDespawn = DespawnMode.PERSISTENT.toString();
            }
            this.despawnMode = DespawnMode.get(shouldDespawn);
            this.attrAttackSpeed = mc.getDouble("Options.AttackSpeed", 0.0);
            this.attrMovementSpeed = mc.getPlaceholderDouble("Options.MovementSpeed", null);
            this.attrFlyingSpeed = mc.getPlaceholderDouble("Options.FlyingSpeed", "-1");
            this.attrKnockbackResist = mc.getDouble("Options.KnockbackResistance", 0.0);
            this.attrFollowRange = mc.getDouble("Options.FollowRange", -1.0);
            this.attrAttackSpeed = mc.getDouble("Options.AttackSpeed", 0.0);
            this.optionGlowing = mc.getBoolean("Options.Glowing", false);
            this.optionCollidable = mc.getBoolean("Options.Collidable", true);
            this.optionNoGravity = mc.getBoolean("Options.NoGravity", false);
            this.optionInteractable = mc.getBoolean("Options.Interactable", this.optionInteractable);
            this.optionSilent = mc.getBoolean("Options.Silent", this.optionSilent);
            this.optionNoAI = mc.getBoolean("Options.NoAI", this.optionNoAI);
            this.optionHealOnReload = mc.getBoolean("Options.HealOnReload", this.optionHealOnReload);
            this.noDamageTicks = mc.getInteger("Options.NoDamageTicks", 10) * 2;
            this.optionLockPitch = mc.getBoolean("Options.LockPitch", this.optionLockPitch);
            this.useBossBar = mc.getBoolean("BossBar.Enabled", false);
            this.bossBarTitle = mc.getPlaceholderString("BossBar.Title", this.displayName == null ? "" : this.displayName.toString());
            this.bossBarRange = mc.getInteger("BossBar.Range", 64);
            this.bossBarRangeSq = (int)Math.pow(this.bossBarRange, 2.0);
            String bossBarColor = mc.getString("BossBar.Color", "WHITE");
            String bossBarStyle = mc.getString("BossBar.Style", "SOLID");
            try {
                this.bossBarColor = AbstractBossBar.BarColor.valueOf(bossBarColor);
            }
            catch (Exception ex) {
                this.bossBarColor = AbstractBossBar.BarColor.WHITE;
            }
            try {
                this.bossBarStyle = AbstractBossBar.BarStyle.valueOf(bossBarStyle);
            }
            catch (Exception ex) {
                this.bossBarStyle = AbstractBossBar.BarStyle.SOLID;
            }
            this.bossBarCreateFog = mc.getBoolean("BossBar.CreateFog", false);
            this.bossBarDarkenSky = mc.getBoolean("BossBar.DarkenSky", false);
            this.bossBarPlayMusic = mc.getBoolean("BossBar.PlayMusic", false);
            this.usesHealthBar = mc.getBoolean("HealthBar.Enabled", false);
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Loading mob skills... ", new Object[0]);
            List<String> nSkills = mc.getStringList("Skills");
            int interval = 1;
            for (String string : nSkills) {
                Matcher Rmatcher;
                Pattern Rpattern;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Loading mechanic line: {0}", string);
                String string2 = MythicLineConfigImpl.unparseBlock(string);
                SkillMechanic skillMechanic = this.getPlugin().getSkillManager().getMechanic(mc.getFile(), string2);
                if (skillMechanic == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "-! Mechanic was not found. Skipping.", new Object[0]);
                    continue;
                }
                skillMechanic.setParent(this);
                if (string2.contains("~onTimer")) {
                    Rpattern = Pattern.compile("~onTimer:([0-9]+)");
                    Rmatcher = Rpattern.matcher(string2);
                    Rmatcher.find();
                    try {
                        interval = Integer.parseInt(Rmatcher.group(1));
                    }
                    catch (Exception exception) {
                        MythicLogger.errorMobConfig(this, mc, "Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + string2);
                        continue;
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Mechanic set on timer with interval {0}", interval);
                    skillMechanic.setTimerInterval(interval);
                    this.timerSkills.add(skillMechanic);
                    continue;
                }
                if (string2.contains("~onSignal:")) {
                    String string3;
                    Rpattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                    Rmatcher = Rpattern.matcher(string2);
                    Rmatcher.find();
                    try {
                        string3 = Rmatcher.group(1);
                    }
                    catch (Exception e) {
                        MythicLogger.errorMobConfig(this, mc, "Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + string2);
                        continue;
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Mechanic set on Signal with key '{0}'", string3);
                    if (this.signalSkills.containsKey(string3)) {
                        this.signalSkills.get(string3).add(skillMechanic);
                        continue;
                    }
                    ArrayList<SkillMechanic> signalMechanics = new ArrayList<SkillMechanic>();
                    signalMechanics.add(skillMechanic);
                    this.signalSkills.put(string3, signalMechanics);
                    continue;
                }
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_INFO, "Loading mechanic to base skill tree...", new Object[0]);
                SkillTrigger skillTrigger = skillMechanic.getTrigger();
                if (!this.skills.containsKey(skillTrigger)) {
                    this.skills.put(skillTrigger, Queues.newConcurrentLinkedQueue());
                }
                this.skills.get(skillMechanic.getTrigger()).add(skillMechanic);
            }
            if (this.timerSkills.size() > 0) {
                this.usingTimers = true;
            }
            if (this.hasSkills(SkillTriggers.COMBAT)) {
                this.hasCombatSkills = true;
            }
            this.optionShowHealthInChat = mc.getBoolean("ShowHealth", false);
            this.useThreatTable = mc.getBoolean("Modules.ThreatTable", false);
            this.useImmunityTable = mc.getBoolean("Modules.ImmunityTable", false);
            this.useCustomNameplate = mc.getBoolean("Nameplate.Enabled", false);
            this.useThreatTable = mc.getBoolean("Options.UseThreatTable", this.useThreatTable);
            this.useImmunityTable = mc.getBoolean("Options.UseImmunityTable", this.useImmunityTable);
            this.useThreatTable = mc.getBoolean("ThreatTable.Enabled", this.useThreatTable);
            this.optionTTFromDamage = mc.getBoolean("ThreatTable.UseDamageTaken", true);
            this.optionTTDecayUnreachable = mc.getBoolean("ThreatTable.DecayUnreachable", true);
            this.useThreatTable = mc.getBoolean("ThreatTables.Enabled", this.useThreatTable);
            this.optionTTFromDamage = mc.getBoolean("ThreatTables.UseDamageTaken", this.optionTTFromDamage);
            this.optionTTDecayUnreachable = mc.getBoolean("ThreatTables.DecayUnreachable", this.optionTTDecayUnreachable);
            this.maxAttackRange = mc.getInteger("Options.MaxAttackRange", 64);
            this.maxAttackableRange = mc.getInteger("Options.MaxCombatDistance", 256);
            this.maxAttackableRange = mc.getInteger("Options.MaxAttackableRange", this.maxAttackableRange);
            this.maxThreatDistance = mc.getInteger("Options.MaxThreatDistance", 40);
            this.alwaysShowName = mc.getBoolean("Options.AlwaysShowName", false);
            this.showNameOnDamage = mc.getBoolean("Options.ShowNameOnDamaged", false);
            this.repeatAllSkills = mc.getBoolean("Options.RepeatAllSkills", false);
            this.preventOtherDrops = mc.getBoolean("Options.PreventOtherDrops", this.getPlugin().getConfiguration().getPreventOtherDropsByDefault());
            this.preventRandomEquipment = mc.getBoolean("Options.PreventRandomEquipment", false);
            this.preventLeashing = mc.getBoolean("Options.PreventLeashing", true);
            this.preventRename = mc.getBoolean("Options.PreventRenaming", true);
            this.preventSunburn = mc.getBoolean("Options.PreventSunburn", false);
            this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleport", false);
            this.preventEndermanTeleport = mc.getBoolean("Options.PreventTeleporting", this.preventEndermanTeleport);
            this.preventTransformation = mc.getBoolean("Options.PreventTransformation", true);
            this.preventTransformation = mc.getBoolean("Options.PreventTransforming", this.preventTransformation);
            this.preventTransformation = mc.getBoolean("Options.PreventTransform", this.preventTransformation);
            this.preventMounts = mc.getBoolean("Options.PreventMounts", false);
            this.preventMounts = mc.getBoolean("Options.PreventJockey", this.preventMounts);
            this.preventMounts = mc.getBoolean("Options.PreventJockeyMounts", this.preventMounts);
            this.preventItemPickup = mc.getBoolean("Options.PreventItemPickup", true);
            this.preventMobKillDrops = mc.getBoolean("Options.PreventMobKillDrops", false);
            this.passthroughDamage = mc.getBoolean("Options.PassthroughDamage", false);
            this.applyInvisibility = mc.getBoolean("Options.ApplyInvisibility", false);
            this.applyInvisibility = mc.getBoolean("Options.Invisibility", this.applyInvisibility);
            this.applyInvisibility = mc.getBoolean("Options.Invisible", this.applyInvisibility);
            this.aiNavigator = mc.getString("AINavigator", null);
            List<String> lstAIGoalSelectors = mc.getStringList("AIGoalSelectors");
            if (lstAIGoalSelectors != null) {
                for (String string : lstAIGoalSelectors) {
                    String string4 = MythicLineConfigImpl.unparseBlock(string);
                    this.aiGoalSelectors.add(string4);
                }
            }
            if ((list3 = mc.getStringList("AITargetSelectors")) != null) {
                for (String string : list3) {
                    String string5 = MythicLineConfigImpl.unparseBlock(string);
                    this.aiTargetSelectors.add(string5);
                }
            }
            if ((list2 = mc.getStringList("AIPathfindingMalus")) != null) {
                for (String s5 : list2) {
                    try {
                        String[] split = s5.split(" ");
                        this.aiPathfindingMalus.put(split[0], Float.valueOf(Float.parseFloat(split[1])));
                    }
                    catch (Error | Exception ex) {
                        MythicLogger.errorMobConfig(this, mc, "Invalid format for PathfindingMalus line " + s5);
                        ex.printStackTrace();
                    }
                }
            }
            List<String> list4 = mc.getStringList("Drops");
            this.dropTable = new DropTable(this.file.getAbsolutePath(), "Mob:" + this.internalName, list4, true);
            List<String> equipment = mc.getStringList("Equipment");
            this.equipmentTable = new DropTable(this.file.getAbsolutePath(), "MobEquipment:" + this.internalName, equipment, true);
            List<String> lstStats = mc.getStringList("Stats");
            this.stats = Maps.newConcurrentMap();
            if (!lstStats.isEmpty()) {
                for (String string : lstStats) {
                    try {
                        String[] stringArray = string.split(" ");
                        String type = stringArray[0];
                        PlaceholderDouble value = PlaceholderDouble.of(stringArray[1]);
                        this.stats.put(type, value);
                    }
                    catch (Exception exception) {
                        MythicLogger.errorMobConfig(this, mc, "Invalid syntax for Stat line: " + string);
                    }
                }
            }
            List<String> lstDamageMod = mc.getStringList("DamageModifiers");
            this.damageModifiers = new HashMap<String, Double>();
            if (lstDamageMod != null && !lstDamageMod.isEmpty()) {
                for (String string : lstDamageMod) {
                    try {
                        String[] split = string.split(" ");
                        String type = split[0];
                        Double mod = Double.valueOf(split[1]);
                        this.damageModifiers.put(type, mod);
                    }
                    catch (Exception ex) {
                        MythicLogger.errorMobConfig(this, mc, "Invalid syntax for DamageModifier line: " + string);
                    }
                }
            }
            List<String> list5 = mc.getStringList("EntityDamageModifiers");
            this.entityDamageModifiers = new HashMap<String, Double>();
            if (list5 != null && list5.size() > 0) {
                for (String dm : list5) {
                    try {
                        String[] split = dm.split(" ");
                        String type = split[0];
                        double mod = Double.valueOf(split[1]);
                        this.entityDamageModifiers.put(type, mod);
                    }
                    catch (Exception ex) {
                        MythicLogger.errorMobConfig(this, mc, "Invalid syntax for DamageModifier");
                    }
                }
            }
            if ((list = mc.getStringList("KillMessages")) != null && list.size() > 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Loading mob kill messages...", new Object[0]);
                if (this.killMessages == null) {
                    this.killMessages = new ArrayList<PlaceholderString>();
                }
                list.forEach(message -> this.killMessages.add(PlaceholderString.of(message)));
            }
            this.lvlModDamage = mc.getDouble("LevelModifiers.Damage", -1.0);
            this.lvlModHealth = mc.getDouble("LevelModifiers.Health", -1.0);
            this.lvlModKBR = mc.getDouble("LevelModifiers.KnockbackResistance", -1.0);
            this.lvlModPower = mc.getDouble("LevelModifiers.Power", -1.0);
            this.lvlModArmor = mc.getDouble("LevelModifiers.Armor", -1.0);
            this.lvlModSpeed = mc.getDouble("LevelModifiers.MovementSpeed", -1.0);
            this.lvlModAttackSpeed = mc.getDouble("LevelModifiers.AttackSpeed", -1.0);
            if (this.attrDamage != null && this.attrDamage.isStatic()) {
                try {
                    if (this.lvlModDamage < 0.0) {
                        this.lvlModDamage = ConfigExecutor.defaultLevelModifierDamage.startsWith("+") ? Double.valueOf(ConfigExecutor.defaultLevelModifierDamage.substring(1)) : (ConfigExecutor.defaultLevelModifierDamage.startsWith("*") ? this.attrDamage.get() * Double.valueOf(ConfigExecutor.defaultLevelModifierDamage.substring(1)) : this.attrDamage.get() * Double.valueOf(ConfigExecutor.defaultLevelModifierDamage));
                    }
                }
                catch (Exception ex) {
                    MythicLogger.error("Error calculating Damage Level Modifier: Default configuration is bad.", ex);
                }
            }
            if (this.attrHealth != null && this.attrHealth.isStatic()) {
                try {
                    if (this.lvlModHealth < 0.0) {
                        this.lvlModHealth = ConfigExecutor.defaultLevelModifierHealth.startsWith("+") ? Double.valueOf(ConfigExecutor.defaultLevelModifierHealth.substring(1)) : (ConfigExecutor.defaultLevelModifierHealth.startsWith("*") ? this.attrHealth.get() * Double.valueOf(ConfigExecutor.defaultLevelModifierHealth.substring(1)) : this.attrHealth.get() * Double.valueOf(ConfigExecutor.defaultLevelModifierHealth));
                    }
                }
                catch (Exception ex) {
                    MythicLogger.error("Error calculating Health Level Modifier: Default configuration is bad.", ex);
                }
            }
            try {
                if (this.lvlModPower < 0.0) {
                    this.lvlModPower = ConfigExecutor.defaultLevelModifierPower.startsWith("+") ? Double.valueOf(ConfigExecutor.defaultLevelModifierPower.substring(1)) : (ConfigExecutor.defaultLevelModifierPower.startsWith("*") ? Double.valueOf(ConfigExecutor.defaultLevelModifierPower.substring(1)).doubleValue() : Double.valueOf(ConfigExecutor.defaultLevelModifierPower).doubleValue());
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Error calculating Power Level Modifier: Default configuration is bad.", ex);
            }
            if (this.attrArmor != null && this.attrArmor.isStatic()) {
                try {
                    if (this.lvlModArmor < 0.0) {
                        this.lvlModArmor = ConfigExecutor.defaultLevelModifierArmor.startsWith("+") ? Double.valueOf(ConfigExecutor.defaultLevelModifierArmor.substring(1)) : (ConfigExecutor.defaultLevelModifierArmor.startsWith("*") ? this.attrArmor.get() * Double.valueOf(ConfigExecutor.defaultLevelModifierArmor.substring(1)) : Double.valueOf(ConfigExecutor.defaultLevelModifierArmor));
                    }
                }
                catch (Exception ex) {
                    MythicLogger.error("Error calculating Armor Level Modifier: Default configuration is bad.", ex);
                }
            }
            try {
                if (this.lvlModKBR < 0.0) {
                    this.lvlModKBR = ConfigExecutor.defaultLevelModifierKBR.startsWith("+") ? Double.valueOf(ConfigExecutor.defaultLevelModifierKBR.substring(1)) : (ConfigExecutor.defaultLevelModifierKBR.startsWith("*") ? this.attrKnockbackResist * Double.valueOf(ConfigExecutor.defaultLevelModifierKBR.substring(1)) : Double.valueOf(ConfigExecutor.defaultLevelModifierKBR));
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Error calculating KBR Level Modifier: Default configuration is bad.");
                if (ConfigExecutor.debugLevel <= 0) break block83;
                ex.printStackTrace();
            }
        }
        this.digOutOfGround = mc.getBoolean("Options.DigOutOfGround", false);
        String strSpawnVelocityX = mc.getString("SpawnModifiers.VelocityX", "0");
        String strSpawnVelocityY = mc.getString("SpawnModifiers.VelocityY", "0");
        String strSpawnVelocityZ = mc.getString("SpawnModifiers.VelocityZ", "0");
        if (strSpawnVelocityX.contains("to")) {
            String[] split = strSpawnVelocityX.split("to");
            try {
                this.spawnVelocityX = Double.valueOf(split[0]);
                this.spawnVelocityXMax = Double.valueOf(split[1]);
                this.spawnVelocityXRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityX = Double.valueOf(strSpawnVelocityX);
            }
            catch (Exception ex) {
                this.spawnVelocityX = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityX.", this.internalName);
            }
        }
        if (strSpawnVelocityY.contains("to")) {
            String[] split = strSpawnVelocityY.split("to");
            try {
                this.spawnVelocityY = Double.valueOf(split[0]);
                this.spawnVelocityYMax = Double.valueOf(split[1]);
                this.spawnVelocityYRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityY = Double.valueOf(strSpawnVelocityY);
            }
            catch (Exception ex) {
                this.spawnVelocityY = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityY.", this.internalName);
            }
        }
        if (strSpawnVelocityZ.contains("to")) {
            String[] split = strSpawnVelocityZ.split("to");
            try {
                this.spawnVelocityZ = Double.valueOf(split[0]);
                this.spawnVelocityZMax = Double.valueOf(split[1]);
                this.spawnVelocityZRange = true;
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        } else {
            try {
                this.spawnVelocityZ = Double.valueOf(strSpawnVelocityZ);
            }
            catch (Exception ex) {
                this.spawnVelocityZ = 0.0;
                MythicLogger.error("Error loading MythicMob {0}! Invalid value for SpawnModifier.VelocityZ.", this.internalName);
            }
        }
        if (mc.isSet("Disguise")) {
            this.disguise = mc.getString("Disguise", null);
        }
        this.buildCache(false);
    }

    @Override
    public void buildCache() {
        this.buildCache(true);
    }

    public void buildCache(boolean refreshMobs) {
        this.cachedMenuItem = this.entityBaseSpawner.getHead();
        this.cachedMenuItem = ItemFactory.of(this.cachedMenuItem).hideAttributes().lore("<red> ").lore("<rainbow>\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583").lore("<red> ").lore("<gray>\u22b3 <white>Left-Click to get mob egg").lore("<gray>\u22b3 <white>Right-Click to Edit <red>(ALPHA FEATURE)").build();
        if (refreshMobs) {
            this.getManager().getActiveMobs(am -> am.getType().equals(this)).forEach(mob -> mob.remountType());
        }
    }

    @Override
    public ActiveMob spawn(AbstractLocation location, double level) {
        return this.spawn(location, level, SpawnReason.OTHER);
    }

    @Override
    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason) {
        return this.spawn(location, level, reason, null);
    }

    @Override
    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawn(location, level, reason, prespawnFunc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveMob spawn(AbstractLocation location, double level, SpawnReason reason, Consumer<Entity> prespawnFunc, MythicSpawner spawner) {
        this.getManager();
        MobExecutor.spawnflag = true;
        try {
            WorldGuardSupport worldGuardSupport;
            MythicMobPreSpawnEvent preEvent = Events.callAndReturn(new MythicMobPreSpawnEvent(this, location, level, reason));
            if (preEvent.isCancelled()) {
                ActiveMob activeMob = null;
                return activeMob;
            }
            if (this.getPlugin().getCompatibility().getWorldGuard().isPresent() && !(worldGuardSupport = this.getPlugin().getCompatibility().getWorldGuard().get()).getLocationAllowsMobSpawning(BukkitAdapter.adapt(location))) {
                ActiveMob activeMob = null;
                return activeMob;
            }
            if (this.entityBaseSpawner == null) {
                ActiveMob activeMob = null;
                return activeMob;
            }
            Entity e = BukkitAdapter.adapt(this.entityBaseSpawner.spawn(location, reason, (Entity entity) -> {
                if (this.applyInvisibility.booleanValue() && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
                }
                if (prespawnFunc != null) {
                    prespawnFunc.accept((Entity)entity);
                }
            }));
            ActiveMob am = new ActiveMob(BukkitAdapter.adapt(e), this, 0.0);
            if (spawner != null) {
                am.setSpawner(spawner);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Calling MythicMobSpawnEvent for " + this.getInternalName() + " (level: " + level + ")", new Object[0]);
            MythicMobSpawnEvent event = new MythicMobSpawnEvent(am, level, reason);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                e.remove();
                ActiveMob activeMob = null;
                return activeMob;
            }
            this.getManager().registerActiveMob(am);
            level = event.getMobLevel();
            am.setLevel(level);
            am = this.applySpawnModifiers(am);
            if (this.hasSkills(SkillTriggers.SPAWN)) {
                new TriggeredSkill(SkillTriggers.SPAWN, am, null);
            }
            ActiveMob activeMob = am;
            return activeMob;
        }
        finally {
            this.getManager();
            MobExecutor.spawnflag = false;
        }
    }

    @Override
    public ActiveMob applyMobOptions(ActiveMob am, double level) {
        AbstractEntity aEntity = am.getEntity();
        Entity entity = aEntity.getBukkitEntity();
        if (am.getEntity().isLiving()) {
            double flyingSpeed;
            double movementSpeed;
            double damage;
            double armor;
            double health;
            LivingEntity asLiving = (LivingEntity)entity;
            if (asLiving.isDead()) {
                entity.remove();
                am.unregister(true);
                return am;
            }
            if (am.getDespawnMode().getDespawnWithoutNearbyPlayers().booleanValue()) {
                asLiving.setRemoveWhenFarAway(true);
            } else {
                asLiving.setRemoveWhenFarAway(false);
            }
            if (am.getDespawnMode().getSavesToDisk().booleanValue()) {
                asLiving.setPersistent(true);
            } else {
                asLiving.setPersistent(false);
            }
            if (this.alwaysShowName) {
                asLiving.setCustomNameVisible(true);
            }
            if (this.preventItemPickup.booleanValue()) {
                asLiving.setCanPickupItems(false);
            }
            if (this.applyInvisibility.booleanValue()) {
                asLiving.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
            }
            if ((health = this.getHealth(am)) > 0.0) {
                if (this.optionHealOnReload) {
                    aEntity.setHealthAndMax(health);
                } else {
                    double hp = aEntity.getHealth();
                    if (hp < aEntity.getMaxHealth()) {
                        double ratio = hp / aEntity.getMaxHealth();
                        aEntity.setMaxHealth(health);
                        aEntity.setHealth(health * ratio);
                    } else {
                        aEntity.setHealthAndMax(health);
                    }
                }
            }
            if ((armor = this.getArmor(am)) > 0.0) {
                aEntity.setArmor(armor);
            }
            if ((damage = this.getDamage(am)) >= 0.0) {
                aEntity.setDamage(damage);
            }
            if ((movementSpeed = this.getMovementSpeed(am)) >= 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(movementSpeed);
            }
            if ((flyingSpeed = this.getFlyingSpeed(am)) >= 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_FLYING_SPEED).setBaseValue(flyingSpeed);
            }
            if (this.attrAttackSpeed != 0.0 && asLiving.getAttribute(Attribute.GENERIC_ATTACK_SPEED) != null) {
                asLiving.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(this.getAttackSpeed(level));
            }
            if (this.attrFollowRange >= 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(this.attrFollowRange);
            }
            if (this.attrKnockbackResist != 0.0) {
                asLiving.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).setBaseValue(this.getKnockbackResistance(level));
            }
            if (!this.optionCollidable) {
                asLiving.setCollidable(false);
            }
            asLiving.setMaximumNoDamageTicks(this.noDamageTicks);
            ActiveMob amm = am;
            Schedulers.sync().runLater(() -> {
                EntityEquipment ee;
                if (amm.getEntity() == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MythicMob {0} failed to spawn - was despawned by other plugin", this.internalName);
                    return;
                }
                if (this.preventRandomEquipment.booleanValue()) {
                    ee = asLiving.getEquipment();
                    assert (ee != null);
                    ee.clear();
                    ee.setArmorContents(new ItemStack[]{new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR)});
                }
                this.equipmentTable.generate(new DropMetadataImpl(amm, amm.getEntity())).equip(amm.getEntity());
                ee = asLiving.getEquipment();
                assert (ee != null);
                if (asLiving instanceof Creature) {
                    ee.setItemInMainHandDropChance(0.0f);
                    ee.setItemInOffHandDropChance(0.0f);
                    ee.setHelmetDropChance(0.0f);
                    ee.setChestplateDropChance(0.0f);
                    ee.setLeggingsDropChance(0.0f);
                    ee.setBootsDropChance(0.0f);
                }
                if (this.useCustomNameplate) {
                    amm.setShowCustomNameplate(true);
                }
            }, 5L);
            if (this.getDisplayName() != null) {
                am.getEntity().setCustomName(am.getDisplayName());
            }
        }
        if (this.optionInvincible) {
            entity.setInvulnerable(true);
        }
        if (this.optionGlowing) {
            entity.setGlowing(true);
        }
        if (this.optionNoGravity) {
            entity.setGravity(false);
        }
        if (this.optionSilent) {
            entity.setSilent(true);
        }
        if (this.model != null) {
            this.model.apply(am.getEntity());
        }
        am.getEntity().setMetadata("mobname", this.getInternalName());
        am.getEntity().setMetadata("mythicmob", "true");
        if (this.mount.isPresent()) {
            this.getManager();
            if (!MobExecutor.mountflag && this.getManager().getMythicMob(this.mount.get()) != null) {
                this.getManager();
                MobExecutor.mountflag = true;
                if (entity.getVehicle() != null) {
                    entity.getVehicle().remove();
                }
                AbstractEntity mount = this.getManager().getMythicMob(this.mount.get()).get().spawn(am.getLocation(), level, SpawnReason.SUMMON).getEntity();
                this.getManager();
                MobExecutor.mountflag = false;
                mount.setPassenger(entity);
                ActiveMob mountInstance = this.getManager().getMythicMobInstance(mount);
                am.setMount(mountInstance);
                mountInstance.setParent(am);
            }
        }
        if (this.rider.isPresent()) {
            this.getManager();
            if (!MobExecutor.mountflag && this.getManager().getMythicMob(this.rider.get()) != null) {
                this.getManager();
                MobExecutor.mountflag = true;
                AbstractEntity rider = this.getManager().getMythicMob(this.rider.get()).get().spawn(am.getLocation(), level, SpawnReason.SUMMON).getEntity();
                this.getManager();
                MobExecutor.mountflag = false;
                rider.setPassenger(entity);
                ActiveMob riderInstance = this.getManager().getMythicMobInstance(rider);
                riderInstance.setMount(am);
                riderInstance.setParent(am);
            }
        }
        return am;
    }

    @Override
    public ActiveMob applyMobVolatileOptions(ActiveMob am) {
        Entity e = am.getEntity().getBukkitEntity();
        if (this.hasFaction()) {
            e.setMetadata("Faction", (MetadataValue)new FixedMetadataValue((Plugin)this.getPlugin(), (Object)this.getFaction()));
        }
        if (am.getEntity().isMob()) {
            if (this.optionNoAI) {
                am.getEntity().setAI(false);
            }
            if (ConfigExecutor.EnableAIModifiers) {
                if (this.aiNavigator != null) {
                    this.getPlugin().getVolatileCodeHandler().getAIHandler().setNavigationController(am.getEntity(), this.aiNavigator);
                }
                if (this.getAIGoalSelectors() != null) {
                    this.getPlugin().getVolatileCodeHandler().getAIHandler().addPathfinderGoals((LivingEntity)e, this.getAIGoalSelectors());
                }
                if (this.getAITargetSelectors() != null) {
                    this.getPlugin().getVolatileCodeHandler().getAIHandler().addTargetGoals((LivingEntity)e, this.getAITargetSelectors());
                }
                if (!this.aiPathfindingMalus.isEmpty()) {
                    for (Map.Entry<String, Float> entry : this.aiPathfindingMalus.entrySet()) {
                        this.getPlugin().getVolatileCodeHandler().getAIHandler().setPathfindingMalus(am.getEntity(), entry.getKey(), entry.getValue().floatValue());
                    }
                }
            }
        }
        if (this.disguise != null && CompatibilityManager.LibsDisguises != null) {
            Schedulers.sync().run(() -> CompatibilityManager.LibsDisguises.setDisguise(am, this.disguise));
        }
        return am;
    }

    @Override
    public ActiveMob applySpawnModifiers(ActiveMob am) {
        double vl;
        AbstractEntity e = am.getEntity();
        AbstractVector v = e.getVelocity();
        if (this.spawnVelocityXRange.booleanValue()) {
            vl = Numbers.randomDouble() * (this.spawnVelocityXMax - this.spawnVelocityX) + this.spawnVelocityX;
            v.setX(vl);
        } else {
            v.setX(this.spawnVelocityX);
        }
        if (this.spawnVelocityYRange.booleanValue()) {
            vl = Numbers.randomDouble() * (this.spawnVelocityYMax - this.spawnVelocityY) + this.spawnVelocityY;
            v.setY(vl);
        } else {
            v.setY(this.spawnVelocityY);
        }
        if (this.spawnVelocityZRange.booleanValue()) {
            vl = Numbers.randomDouble() * (this.spawnVelocityZMax - this.spawnVelocityZ) + this.spawnVelocityZ;
            v.setZ(vl);
        } else {
            v.setZ(this.spawnVelocityZ);
        }
        e.setVelocity(v);
        return am;
    }

    @Override
    public void executeSkills(SkillTrigger cause, SkillMetadata data) {
        block8: {
            try {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Running Mechanics for ActiveMob {0} (uuid: {1})", this.internalName, data.getCaster().getEntity().getUniqueId());
                if (data.getCaster().getEntity() == null || !data.getCaster().getEntity().getWorld().isLoaded()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "! Mob is not loaded. Ignoring skills.", new Object[0]);
                    return;
                }
                if (data.getIsAsync()) {
                    for (SkillMechanic ms : this.getSkills(cause)) {
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Running Mechanics for ActiveMob '{0}' (uuid: {1})", this.internalName, data.getCaster().getEntity().getUniqueId());
                        if (ms.getRunAsync() || !ms.isUsableFromCaster(data)) continue;
                        ms.execute(data.deepClone().setIsAsync(false));
                    }
                    Schedulers.async().run(() -> {
                        for (SkillMechanic ms : this.getSkills(cause)) {
                            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", ms.getConfigLine());
                            if (!ms.getRunAsync() || !ms.isUsableFromCaster(data)) continue;
                            ms.execute(data);
                        }
                    });
                } else {
                    for (SkillMechanic ms : this.getSkills(cause)) {
                        if (!ms.isUsableFromCaster(data)) continue;
                        ms.execute(data);
                    }
                }
            }
            catch (Error | Exception ex) {
                MythicLogger.errorMobConfig(this, this.config, "Error processing skills for mob " + this.internalName + ". Mob type may no longer exist, or may have become corrupted by a server crash, and will be removed.");
                if (ConfigExecutor.debugLevel > 0) {
                    ex.printStackTrace();
                }
                if (data.getCaster() == null || !(data.getCaster() instanceof ActiveMob)) break block8;
                this.getPlugin().getMobManager().unregisterActiveMob((ActiveMob)data.getCaster());
            }
        }
    }

    @Override
    public void executeSignalSkill(String signal, SkillMetadata data) {
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Executing signal skills...", new Object[0]);
        if (this.signalSkills.containsKey(signal)) {
            for (SkillMechanic ms : this.signalSkills.get(signal)) {
                if (!ms.isUsableFromCaster(data)) continue;
                ms.execute(data);
            }
        }
        for (SkillMechanic ms : this.getSkills(SkillTriggers.SIGNAL)) {
            if (!ms.isUsableFromCaster(data)) continue;
            ms.execute(data);
        }
    }

    @Override
    public Queue<SkillMechanic> getSkills(SkillTrigger trigger) {
        if (this.hasCombatSkills && (trigger == SkillTriggers.SPAWN || trigger == SkillTriggers.ATTACK || trigger == SkillTriggers.DAMAGED || trigger == SkillTriggers.DEATH)) {
            Queue skills = this.skills.getOrDefault(trigger, new LinkedList());
            skills.addAll((Collection)this.skills.get(SkillTriggers.COMBAT));
            return skills;
        }
        return this.skills.getOrDefault(trigger, new LinkedList());
    }

    @Override
    public boolean hasSkills(SkillTrigger trigger) {
        return this.skills.containsKey(trigger);
    }

    @Override
    public Queue<SkillMechanic> getTimerSkills() {
        return this.timerSkills;
    }

    @Override
    public void setEntityType(MythicEntityType type) {
        this.entityTypeString = type.toString();
        this.entityType = type;
        this.entityBaseSpawner = BukkitEntityType.getMythicEntity(this.entityType);
        this.entityBaseSpawner.instantiate(this.config);
        this.config.set("Type", this.entityTypeString);
    }

    @Override
    public String getEntityTypeString() {
        return this.entityTypeString;
    }

    @Override
    public BukkitEntityType getMythicEntity() {
        return this.entityBaseSpawner;
    }

    @Override
    public DespawnMode getDespawnMode() {
        return this.despawnMode;
    }

    @Override
    public double getPerLevelHealth() {
        return this.lvlModHealth;
    }

    @Override
    public double getPerLevelDamage() {
        return this.lvlModDamage;
    }

    @Override
    public double getPerLevelPower() {
        return this.lvlModPower;
    }

    @Override
    public PlaceholderDouble getArmor() {
        return this.attrArmor;
    }

    @Override
    public double getPerLevelArmor() {
        return this.lvlModArmor;
    }

    @Override
    public double getArmor(ActiveMob am) {
        if (this.attrArmor == null) {
            return -1.0;
        }
        double level = am.getLevel();
        double attr = this.attrArmor.get(am);
        if (level > 1.0 && this.lvlModArmor > 0.0) {
            attr += this.lvlModArmor * (level - 1.0);
        }
        return attr;
    }

    @Override
    public PlaceholderDouble getDamage() {
        return this.attrDamage;
    }

    @Override
    public double getDamage(ActiveMob am) {
        if (this.attrDamage == null) {
            return -1.0;
        }
        double level = am.getLevel();
        double damage = this.attrDamage.get(am);
        if (this.lvlModDamage > 0.0) {
            if (level > 1.0) {
                damage += this.lvlModDamage * (level - 1.0);
            }
        } else if (this.getPlugin().getConfiguration().getScalingEquationDamage() != null) {
            damage = this.getPlugin().getConfiguration().getScalingEquationDamage().setVariable("v", damage).setVariable("l", am.getLevel()).evaluate();
        }
        return damage;
    }

    @Override
    public double getMovementSpeed(ActiveMob am) {
        if (this.attrMovementSpeed == null) {
            return -1.0;
        }
        double level = am.getLevel();
        double attr = this.attrMovementSpeed.get(am);
        if (level > 1.0 && this.lvlModSpeed > 0.0) {
            attr += this.lvlModSpeed * (level - 1.0);
        }
        return attr;
    }

    @Override
    public double getReviveHealth(ActiveMob am) {
        return this.optionReviveHealth <= 0.0 ? this.getHealth(am) : this.optionReviveHealth;
    }

    @Override
    public double getFlyingSpeed(ActiveMob am) {
        return this.attrFlyingSpeed.get(am);
    }

    @Override
    public double getKnockbackResistance(double level) {
        double attr = this.attrKnockbackResist;
        if (level > 1.0 && this.lvlModKBR > 0.0) {
            attr += this.lvlModKBR * (level - 1.0);
        }
        return attr;
    }

    @Override
    public double getAttackSpeed(double level) {
        double attr = this.attrAttackSpeed;
        if (level > 1.0 && this.lvlModAttackSpeed > 0.0) {
            attr += this.lvlModAttackSpeed * (level - 1.0);
        }
        return attr;
    }

    @Override
    public boolean hasFaction() {
        return this.faction != null;
    }

    @Override
    public String getFaction() {
        return this.faction;
    }

    @Override
    public PlaceholderDouble getHealth() {
        return this.attrHealth;
    }

    @Override
    public double getHealth(ActiveMob am) {
        if (this.attrHealth == null) {
            return -1.0;
        }
        double health = this.attrHealth.get(am);
        double level = am.getLevel();
        if (this.lvlModHealth > 0.0) {
            if (level > 1.0) {
                health += this.lvlModHealth * (level - 1.0);
            }
        } else if (this.getPlugin().getConfiguration().getScalingEquationHealth() != null) {
            health = this.getPlugin().getConfiguration().getScalingEquationHealth().setVariable("v", health).setVariable("l", am.getLevel()).evaluate();
        }
        return health;
    }

    @Override
    public boolean getIsInvincible() {
        return this.optionInvincible;
    }

    @Override
    public boolean usesThreatTable() {
        return this.useThreatTable;
    }

    @Override
    public boolean usesImmunityTable() {
        return this.useImmunityTable;
    }

    @Override
    public boolean getThreatTableUseDamageTaken() {
        return this.optionTTFromDamage;
    }

    @Override
    public boolean getThreatTableDecaysUnreachable() {
        return this.optionTTDecayUnreachable;
    }

    @Override
    public List<String> getLevelModifiers() {
        return this.levelmods;
    }

    @Override
    public List<String> getAIGoalSelectors() {
        return this.aiGoalSelectors;
    }

    @Override
    public List<String> getAITargetSelectors() {
        return this.aiTargetSelectors;
    }

    @Override
    public boolean hasKillMessages() {
        return this.killMessages != null && this.killMessages.size() > 0;
    }

    @Override
    public PlaceholderString getKillMessage() {
        if (!this.hasKillMessages()) {
            return null;
        }
        return this.killMessages.get(Numbers.randomInt(this.killMessages.size()));
    }

    @Override
    public double getSpawnVelocityX() {
        return this.spawnVelocityX;
    }

    @Override
    public double getSpawnVelocityY() {
        return this.spawnVelocityY;
    }

    @Override
    public double getSpawnVelocityZ() {
        return this.spawnVelocityZ;
    }

    @Override
    public boolean getIsInteractable() {
        return this.optionInteractable;
    }

    @Override
    public boolean usesBossBar() {
        return this.useBossBar;
    }

    @Override
    public int getBossBarRangeSquared() {
        return this.bossBarRangeSq;
    }

    @Override
    public Optional<AbstractBossBar> getBossBar() {
        if (!this.useBossBar) {
            return Optional.empty();
        }
        AbstractBossBar bar = this.getPlugin().getBootstrap().createBossBar(" ", this.bossBarColor, this.bossBarStyle);
        bar.setProgress(1.0);
        if (this.bossBarCreateFog) {
            bar.setCreateFog(true);
        }
        if (this.bossBarDarkenSky) {
            bar.setDarkenSky(true);
        }
        if (this.bossBarPlayMusic) {
            bar.setPlayBossMusic(true);
        }
        return Optional.of(bar);
    }

    @Override
    public PlaceholderString getBossBarTitle() {
        return this.bossBarTitle;
    }

    public boolean equals(Object o) {
        if (o instanceof MobType) {
            return ((MobType)o).getInternalName().equals(this.internalName);
        }
        return false;
    }

    public String toString() {
        return "MythicMob{" + this.internalName + "}";
    }

    @Override
    public int compareTo(MythicMob mm4) {
        return this.internalName.compareTo(mm4.getInternalName());
    }

    @Override
    public boolean getShowHealthInChat() {
        return this.optionShowHealthInChat;
    }

    @Override
    public boolean getShowNameOnDamaged() {
        return this.showNameOnDamage;
    }

    @Override
    public Icon<MobMenuContext> getIcon() {
        return IconBuilder.create().itemStack(this.cachedMenuItem).hideFlags(true).name(this.internalName).lore(a -> {
            String display = this.displayName == null ? "<red>None" : this.displayName.get();
            return Lists.newArrayList((Object[])new String[]{"<red>", Text.colorizeLegacy("<gold>Type<white>: " + this.entityType.toString()), Text.colorizeLegacy("<gold>Display<white>: " + display), Text.colorizeLegacy("<red> "), Text.colorizeLegacy("<gray>\u22b3 <yellow>Left-Click to get Mob Egg"), Text.colorizeLegacy("<gray>\u22b3 <yellow>Right-Click to Edit")});
        }).click((context, player) -> {
            player.performCommand("mythicmobs egg get " + this.internalName);
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }).rightClick((context, player) -> {
            MobEditorMenuContext ctx = new MobEditorMenuContext(this, (MobMenuContext)context);
            this.getPlugin().getMenuManager().getMobEditorMenu().open((Player)player, ctx);
        }).build();
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public MobExecutor getManager() {
        return this.manager;
    }

    @Override
    public Pack getPack() {
        return this.pack;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public MythicConfig getConfig() {
        return this.config;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public ItemStack getCachedMenuItem() {
        return this.cachedMenuItem;
    }

    @Override
    public MythicEntityType getEntityType() {
        return this.entityType;
    }

    public BukkitEntityType getEntityBaseSpawner() {
        return this.entityBaseSpawner;
    }

    @Override
    public PlaceholderString getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(PlaceholderString displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getEggDisplay() {
        return this.eggDisplay;
    }

    @Override
    public void setFaction(String faction) {
        this.faction = faction;
    }

    @Override
    public MobModel getModel() {
        return this.model;
    }

    @Override
    public DropTable getDropTable() {
        return this.dropTable;
    }

    @Override
    public DropTable getEquipmentTable() {
        return this.equipmentTable;
    }

    @Override
    public PlaceholderDouble getAttrHealth() {
        return this.attrHealth;
    }

    @Override
    public void setAttrHealth(PlaceholderDouble attrHealth) {
        this.attrHealth = attrHealth;
    }

    @Override
    public PlaceholderDouble getAttrDamage() {
        return this.attrDamage;
    }

    @Override
    public void setAttrDamage(PlaceholderDouble attrDamage) {
        this.attrDamage = attrDamage;
    }

    @Override
    public PlaceholderDouble getAttrArmor() {
        return this.attrArmor;
    }

    @Override
    public void setAttrArmor(PlaceholderDouble attrArmor) {
        this.attrArmor = attrArmor;
    }

    @Override
    public PlaceholderDouble getAttrMovementSpeed() {
        return this.attrMovementSpeed;
    }

    @Override
    public void setAttrMovementSpeed(PlaceholderDouble attrMovementSpeed) {
        this.attrMovementSpeed = attrMovementSpeed;
    }

    public PlaceholderDouble getAttrFlyingSpeed() {
        return this.attrFlyingSpeed;
    }

    public void setAttrFlyingSpeed(PlaceholderDouble attrFlyingSpeed) {
        this.attrFlyingSpeed = attrFlyingSpeed;
    }

    public double getAttrKnockbackResist() {
        return this.attrKnockbackResist;
    }

    public void setAttrKnockbackResist(double attrKnockbackResist) {
        this.attrKnockbackResist = attrKnockbackResist;
    }

    public double getAttrFollowRange() {
        return this.attrFollowRange;
    }

    public void setAttrFollowRange(double attrFollowRange) {
        this.attrFollowRange = attrFollowRange;
    }

    public double getAttrAttackSpeed() {
        return this.attrAttackSpeed;
    }

    public void setAttrAttackSpeed(double attrAttackSpeed) {
        this.attrAttackSpeed = attrAttackSpeed;
    }

    public double getOptionReviveHealth() {
        return this.optionReviveHealth;
    }

    public void setOptionReviveHealth(double optionReviveHealth) {
        this.optionReviveHealth = optionReviveHealth;
    }

    @Override
    public Boolean getOptionLockPitch() {
        return this.optionLockPitch;
    }

    @Override
    public Map<String, PlaceholderDouble> getStats() {
        return this.stats;
    }

    @Override
    public Map<String, Double> getDamageModifiers() {
        return this.damageModifiers;
    }

    @Override
    public Map<String, Double> getEntityDamageModifiers() {
        return this.entityDamageModifiers;
    }

    @Override
    public String getAiNavigator() {
        return this.aiNavigator;
    }

    @Override
    public boolean isUsingTimers() {
        return this.usingTimers;
    }

    @Override
    public int getNoDamageTicks() {
        return this.noDamageTicks;
    }

    @Override
    public int getMaxAttackRange() {
        return this.maxAttackRange;
    }

    @Override
    public int getMaxAttackableRange() {
        return this.maxAttackableRange;
    }

    @Override
    public int getMaxThreatDistance() {
        return this.maxThreatDistance;
    }

    @Override
    public boolean isUseCustomNameplate() {
        return this.useCustomNameplate;
    }

    @Override
    public Boolean getRepeatAllSkills() {
        return this.repeatAllSkills;
    }

    @Override
    public Boolean getPreventOtherDrops() {
        return this.preventOtherDrops;
    }

    @Override
    public Boolean getPreventRandomEquipment() {
        return this.preventRandomEquipment;
    }

    @Override
    public Boolean getPreventLeashing() {
        return this.preventLeashing;
    }

    @Override
    public Boolean getPreventRename() {
        return this.preventRename;
    }

    @Override
    public Boolean getPreventEndermanTeleport() {
        return this.preventEndermanTeleport;
    }

    @Override
    public Boolean getPreventItemPickup() {
        return this.preventItemPickup;
    }

    @Override
    public Boolean getPreventSilverfishInfection() {
        return this.preventSilverfishInfection;
    }

    @Override
    public Boolean getPreventSunburn() {
        return this.preventSunburn;
    }

    @Override
    public Boolean getPreventExploding() {
        return this.preventExploding;
    }

    @Override
    public Boolean getPreventMobKillDrops() {
        return this.preventMobKillDrops;
    }

    @Override
    public Boolean getPreventTransformation() {
        return this.preventTransformation;
    }

    @Override
    public Boolean getPreventMounts() {
        return this.preventMounts;
    }

    @Override
    public Boolean getPassthroughDamage() {
        return this.passthroughDamage;
    }

    @Override
    public Boolean getApplyInvisibility() {
        return this.applyInvisibility;
    }

    @Override
    public Boolean getDigOutOfGround() {
        return this.digOutOfGround;
    }

    @Override
    public Boolean getUsesHealthBar() {
        return this.usesHealthBar;
    }

    @Override
    public double getSpawnVelocityXMax() {
        return this.spawnVelocityXMax;
    }

    @Override
    public double getSpawnVelocityYMax() {
        return this.spawnVelocityYMax;
    }

    @Override
    public double getSpawnVelocityZMax() {
        return this.spawnVelocityZMax;
    }

    @Override
    public Boolean getSpawnVelocityXRange() {
        return this.spawnVelocityXRange;
    }

    @Override
    public Boolean getSpawnVelocityYRange() {
        return this.spawnVelocityYRange;
    }

    @Override
    public Boolean getSpawnVelocityZRange() {
        return this.spawnVelocityZRange;
    }

    @Override
    public String getDisguise() {
        return this.disguise;
    }

    @Override
    public boolean isFakePlayer() {
        return this.fakePlayer;
    }
}

