/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.mobs.editor;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.mobs.MobEditorButton;
import io.lumine.mythic.core.menus.mobs.MobEditorButtons;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditAttrButton
extends MobEditorButton {
    private String attribute;
    private Material icon;
    private Function<MythicMob, String> currentValue;
    private BiConsumer<MythicMob, String> saveValue;
    private String option;

    public EditAttrButton(MobEditorButtons parent, int sort, String attribute, Material icon, Function<MythicMob, String> currentValue, BiConsumer<MythicMob, String> saveValue) {
        this(parent, sort, attribute, null, icon, currentValue, saveValue);
    }

    public EditAttrButton(MobEditorButtons parent, int sort, String attribute, String option, Material icon, Function<MythicMob, String> currentValue, BiConsumer<MythicMob, String> saveValue) {
        super(parent, sort);
        this.attribute = attribute;
        this.icon = icon;
        this.currentValue = currentValue;
        this.saveValue = saveValue;
        this.option = option;
    }

    @Override
    public Icon<MobEditorMenuContext> getIcon() {
        return IconBuilder.create().material(this.icon).name("<green>Set " + this.attribute).hideFlags().lore(context -> {
            try {
                String currentVal = this.currentValue.apply(context.getMob());
                if (currentVal == null) {
                    return Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>None"});
                }
                return Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>" + currentVal});
            }
            catch (Error | Exception ex) {
                return Lists.newArrayList((Object[])new String[]{"&c", "<yellow>Current: <white>None", "<red> ", "<gray>\u22b3 <yellow>Left-Click to Edit Attribute", "<gray>\u22b3 <yellow>Right-Click to Reset Attribute"});
            }
        }).click((context, player) -> {
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the " + this.attribute + " Value you'd like to use.", "<white>You can use math and placeholders, such as <aqua><mob.level>", "Type cancel to abort editing.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                MythicMob editing = context.getMob();
                this.saveValue.accept(editing, input);
                editing.getConfig().setSave(this.option == null ? this.attribute : this.option, input);
                editing.buildCache();
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).rightClick((context, player) -> {
            MythicMob editing = context.getMob();
            this.saveValue.accept(editing, null);
            editing.getConfig().unsetSave(this.option);
            editing.buildCache();
        }).build();
    }
}

