/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items.editor;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.commands.items.edit.EditEnchantsCommand;
import io.lumine.mythic.bukkit.commands.items.edit.ItemEditCommand;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.menus.items.ItemEditorButton;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;

public class EditEnchantsButton
extends ItemEditorButton {
    public EditEnchantsButton(ItemEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public Icon<ItemEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.ENCHANTED_BOOK).name("<green>Edit Enchantments").lore(context -> {
            ArrayList lore = Lists.newArrayList((Object[])new String[]{"<white>Left-click add an enchantment", "<white>Right-click to edit enchantments", "&c", "<yellow>Current:", "&c"});
            for (Map.Entry<Enchantment, PlaceholderInt> entry : context.getItem().getEnchantments().entrySet()) {
                lore.add("<gray>" + entry.getKey().getName() + " " + entry.getValue().toString());
            }
            return lore;
        }).click((context, player) -> {
            player.closeInventory();
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the Enchantment you'd like to add.", "Format: [enchantment_type] [amount]", "Type cancel to abort editing.");
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                if (!context.getItem().addEnchantment(input)) {
                    CommandHelper.sendError((CommandSender)player, "Invalid enchantment supplied");
                    CommandHelper.sendEditorMessage((CommandSender)player, "Type in the Enchantment you'd like to add.", "Format: [enchantment_type] [amount]", "Type cancel to abort editing.");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                EditEnchantsCommand.saveEnchants(context.getItem());
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> {
                context.getItem().buildItemCache();
                context.openMenu((Player)player);
            });
        }).rightClick((context, player) -> {
            ItemEditCommand.lastEdited.put(player.getUniqueId(), (ItemEditorMenuContext)context);
            player.performCommand("mm i edit enchants " + context.getItem().getInternalName());
            player.closeInventory();
        }).build();
    }
}

