/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items;

import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import java.util.function.Predicate;
import org.bukkit.inventory.ItemStack;

public abstract class ItemEditorButton
implements Comparable,
MenuData<ItemEditorMenuContext> {
    private final int sortIndex;

    public ItemEditorButton(ItemEditorButtons parent, int sort) {
        this.sortIndex = sort;
        parent.buttons.add(this);
    }

    @Override
    public abstract Icon<ItemEditorMenuContext> getIcon();

    public boolean isApplicable(ItemStack itemStack) {
        return true;
    }

    public boolean isApplicable(ItemStack itemStack, Predicate<ItemStack> predicate) {
        return predicate.test(itemStack);
    }

    public int compareTo(Object o) {
        if (o instanceof ItemEditorButton) {
            ItemEditorButton button = (ItemEditorButton)o;
            return button.getSortIndex() - this.sortIndex;
        }
        return 0;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }
}

