/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.types.MenuProp;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.menu.ReloadableMenu;
import io.lumine.mythic.core.menus.MenuManager;
import org.bukkit.entity.Player;

public abstract class MythicMenu<T>
extends ReloadableMenu<T> {
    protected MythicBukkit plugin;
    protected MenuManager menuManager;

    public MythicMenu(MythicBukkit core, MenuManager manager, String menuFile) {
        super(new MenuProp(core, core.getPropertyFileInternal(core.getClass().getResourceAsStream(menuFile)), "Menu", null));
        this.plugin = core;
        this.menuManager = manager;
    }

    public MythicMenu(MythicBukkit core, MenuManager manager, String menuFile, boolean buildOnOpen) {
        super(new MenuProp(core, core.getPropertyFileInternal(core.getClass().getResourceAsStream(menuFile)), "Menu", null), buildOnOpen);
        this.plugin = core;
        this.menuManager = manager;
    }

    public EditableMenuBuilder<T> addPageButtons(EditableMenuBuilder<T> builder) {
        builder.getIcon("NEXT_PAGE").ifPresent(icon -> icon.getBuilder().click((profile, player) -> {
            player.playSound(player.getLocation(), "item.book.page_turn", 1.0f, 1.0f);
            this.nextPage((Player)player);
        }));
        builder.getIcon("PREVIOUS_PAGE").ifPresent(icon -> icon.getBuilder().click((profile, player) -> {
            player.playSound(player.getLocation(), "item.book.page_turn", 1.0f, 1.0f);
            this.previousPage((Player)player);
        }));
        return builder;
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }
}

