/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.volatilecode.VolatileMaterial;
import io.lumine.mythic.api.volatilecode.handlers.VolatileItemHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.events.MythicApplyEnchantEvent;
import io.lumine.mythic.bukkit.events.MythicMobItemGenerateEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.adventure.text.serializer.gson.GsonComponentSerializer;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.ConfigExecutor;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.menus.items.ItemMenuContext;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.jnbt.ByteTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTagBuilder;
import io.lumine.mythic.core.utils.jnbt.DoubleTag;
import io.lumine.mythic.core.utils.jnbt.IntTag;
import io.lumine.mythic.core.utils.jnbt.ListTag;
import io.lumine.mythic.core.utils.jnbt.ListTagBuilder;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class MythicItem
implements Comparable<MythicItem>,
MenuData<ItemMenuContext> {
    private final MythicConfig config;
    private ItemStack cachedBaseItem;
    private ItemStack cachedMenuItem;
    private final String internalName;
    private final Pack pack;
    private final File file;
    private String group = "OTHER";
    private String displayName;
    private String strMaterial;
    private Material material;
    private int customModelData;
    @Deprecated
    private byte data;
    private int amount = 1;
    private PlaceholderInt durability;
    private PlaceholderInt maxEnchantments;
    private int maxCustomDurability = 0;
    private boolean preventEnchanting;
    private boolean preventAnvil;
    private String color;
    private String player;
    private String skinURL;
    private String skinTexture;
    private UUID skinUUID;
    private List<PlaceholderString> lore;
    private Map<Enchantment, PlaceholderInt> enchantments = Maps.newConcurrentMap();
    private List<String> potionEffects;
    private List<String> bannerLayers;
    private List<String> fireworkColors;
    private List<String> fireworkFadeColors;
    private Map<String, Object> itemNBT = new HashMap<String, Object>();
    private ListTag tagItemAttributes = null;
    private Map<String, Tag> itemOptions = new HashMap<String, Tag>();
    private List<String> hideOptions = new ArrayList<String>();
    private List<String> placeOptions = new ArrayList<String>();
    private List<String> breakOptions = new ArrayList<String>();
    private boolean unbreakable;
    private boolean hideFlags;
    private String mythicTypeOverride;
    private Boolean appendType = true;
    private boolean preventStacking = false;
    private int itemVersion = 1;

    private static final MythicBukkit getPlugin() {
        return MythicBukkit.inst();
    }

    private static final VolatileItemHandler getItemHandler() {
        return MythicItem.getPlugin().getVolatileCodeHandler().getItemHandler();
    }

    public MythicItem(Pack pack, File file, String internalName) {
        this.pack = pack;
        this.file = file;
        this.internalName = internalName;
        this.config = new MythicConfigImpl(internalName, file);
        this.config.load();
        this.config.set("Material", "STONE");
        this.config.set("Model", 0);
        this.config.set("Display", internalName);
        this.config.save();
        this.loadItem();
    }

    public MythicItem(Pack pack, File file, String internalName, MythicConfig mc) {
        this.pack = pack;
        this.config = mc;
        this.file = file;
        this.internalName = internalName;
        this.loadItem();
    }

    private void loadItem() {
        block53: {
            List<String> canBreak;
            List<String> canPlaceOn;
            List<String> hideOptions;
            double mmoPvEDamage;
            boolean repairable;
            int repairCost;
            this.itemNBT.clear();
            this.itemOptions.clear();
            this.hideOptions.clear();
            this.placeOptions.clear();
            this.breakOptions.clear();
            this.mythicTypeOverride = this.internalName;
            this.data = (byte)this.config.getInteger("Data", 0);
            this.durability = this.config.getPlaceholderInt(new String[]{"Durability", "Options.Durability"}, String.valueOf(this.data));
            if (this.config.isSet("ItemStack")) {
                ItemStack is = this.config.getItemStack("ItemStack", null);
                if (is != null) {
                    this.cachedBaseItem = is;
                    try {
                        this.displayName = is.getItemMeta().getDisplayName();
                        this.lore = new ArrayList<PlaceholderString>();
                        for (String s2 : is.getItemMeta().getLore()) {
                            this.lore.add(PlaceholderString.of(s2));
                        }
                    }
                    catch (Exception ex) {
                        MythicLogger.errorItemConfig(this, this.config, "Couldn't get name/lore of ItemStack");
                    }
                } else {
                    MythicLogger.errorItemConfig(this, this.config, "Failed to load imported Bukkit ItemStack");
                    this.cachedBaseItem = new ItemStack(Material.STONE);
                }
            } else {
                this.strMaterial = this.config.getString(new String[]{"Id", "Material"}, "STONE", new String[0]).toUpperCase();
                this.setupMaterial(this.strMaterial);
            }
            this.group = this.config.getString(new String[]{"Group", "ItemType", "Options.Group", "Options.ItemType"}, "OTHER", new String[0]);
            this.amount = this.config.getInteger("Amount", 1);
            this.displayName = SkillString.parseMessageSpecialChars(this.config.getColorString("Display"));
            this.lore = this.config.getPlaceholderStringList("Lore");
            this.potionEffects = this.config.getStringList("PotionEffects");
            this.bannerLayers = this.config.getStringList("BannerLayers");
            this.fireworkColors = this.config.getStringList("Firework.Colors");
            this.fireworkFadeColors = this.config.getStringList("Firework.FadeColors");
            this.color = this.config.getString("Options.Color");
            this.player = this.config.getString("Options.Player");
            this.skinURL = this.config.getString("Options.SkinURL");
            this.skinTexture = this.config.getString("Options.SkinTexture");
            if (this.skinTexture != null) {
                this.skinUUID = MythicUtil.getUUIDFromString(this.skinTexture);
            } else if (this.skinURL != null) {
                this.skinUUID = MythicUtil.getUUIDFromString(this.skinURL);
            }
            this.unbreakable = this.config.getBoolean("Options.Indestructable", false);
            this.unbreakable = this.config.getBoolean("Options.Unbreakable", this.unbreakable);
            this.hideFlags = this.config.getBoolean("Options.HideFlags", false);
            this.appendType = this.config.getBoolean("Options.AppendType", true);
            this.preventEnchanting = this.config.getBoolean("Options.PreventEnchanting", false);
            this.preventAnvil = this.config.getBoolean("Options.PreventAnvil", false);
            this.customModelData = this.config.getInteger("Model", -1);
            this.customModelData = this.config.getInteger("Options.Model", this.customModelData);
            this.customModelData = this.config.getInteger("Options.CustomModelData", this.customModelData);
            this.customModelData = this.config.getInteger("CustomModelData", this.customModelData);
            this.maxEnchantments = PlaceholderInt.of(this.config.getString("Options.MaxEnchants", "-1"));
            this.itemVersion = this.config.getInteger("ItemVersion", 1);
            this.maxCustomDurability = this.config.getInteger("CustomDurability.Durability", 0);
            if (this.customModelData > -1) {
                this.itemOptions.put("CustomModelData", new IntTag(this.customModelData));
            }
            if (this.unbreakable) {
                this.itemOptions.put("Unbreakable", new ByteTag(1));
            }
            if (this.hideFlags) {
                this.itemOptions.put("HideFlags", new IntTag(127));
            }
            if (this.preventAnvil) {
                this.itemOptions.put("PreventAnvil", new ByteTag(1));
            }
            if (this.preventEnchanting) {
                this.itemOptions.put("PreventEnchanting", new ByteTag(1));
            }
            if ((repairCost = this.config.getInteger("Options.RepairCost", -1)) >= 0) {
                this.itemOptions.put("RepairCost", new IntTag(repairCost));
            }
            if (!(repairable = this.config.getBoolean("Options.Repairable", true))) {
                this.itemOptions.put("RepairCost", new IntTag(Integer.MAX_VALUE));
            }
            if ((mmoPvEDamage = this.config.getDouble("MMOItemsStats.PvEDamage", -1.0)) > -1.0) {
                this.itemOptions.put("MMOITEMS_PVE_DAMAGE", new DoubleTag(mmoPvEDamage));
            }
            if ((hideOptions = this.config.getStringList("Hide")) != null) {
                for (String hide : hideOptions) {
                    String f = "HIDE_" + hide.toUpperCase();
                    this.hideOptions.add(f);
                }
            }
            if ((canPlaceOn = this.config.getStringList("CanPlaceOn")) != null) {
                this.placeOptions.addAll(canPlaceOn);
            }
            if ((canBreak = this.config.getStringList("CanBreak")) != null) {
                this.breakOptions.addAll(canBreak);
            }
            this.preventStacking = this.config.getBoolean("Options.PreventStacking", false);
            if (this.config.isSet("NBT")) {
                try {
                    this.itemNBT = this.parseNBTNode("NBT");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MythicLogger.errorItemConfig(this, this.config, "NBT tags are configured incorrectly.");
                }
            }
            if (this.config.isSet("Attributes")) {
                try {
                    ListTagBuilder itemAttributesBuilder = ListTagBuilder.create(CompoundTag.class);
                    UUID tagUUID = MythicUtil.getUUIDFromString(this.internalName);
                    for (String slot : this.config.getKeys("Attributes")) {
                        for (String attr : this.config.getKeys("Attributes." + slot)) {
                            String strValue = this.config.getString("Attributes." + slot + "." + attr);
                            String attributeKey = MythicBukkit.inst().getItemManager().getItemAttribute(attr);
                            int operation = -1;
                            CompoundTag tagAttribute = MythicItem.getPlugin().getVolatileCodeHandler().createCompoundTag(new HashMap<String, Tag>());
                            if (strValue.contains(" ")) {
                                String[] split = strValue.split(" ");
                                strValue = split[0];
                                switch (split[1].toUpperCase()) {
                                    case "0": 
                                    case "ADD": 
                                    case "ADD_NUMBER": {
                                        operation = 0;
                                        break;
                                    }
                                    case "1": 
                                    case "MULTIPLY_BASE": 
                                    case "ADD_SCALAR": {
                                        operation = 1;
                                        break;
                                    }
                                    case "2": 
                                    case "MULTIPLY": 
                                    case "MULTIPLY_SCALAR": {
                                        operation = 2;
                                        break;
                                    }
                                    default: {
                                        operation = -1;
                                    }
                                }
                            }
                            if (strValue.endsWith("%")) {
                                strValue = strValue.substring(0, strValue.length() - 1);
                                if (operation == -1) {
                                    operation = 1;
                                }
                                strValue = String.valueOf(Double.valueOf(strValue) / 100.0);
                            }
                            PlaceholderDouble value = PlaceholderDouble.of(strValue);
                            if (operation == -1) {
                                operation = attributeKey.equals("generic.attackSpeed") || attributeKey.equals("generic.attack_speed") || attributeKey.equals("generic.movementSpeed") || attributeKey.equals("generic.movement_speed") ? 1 : 0;
                            }
                            CompoundTagBuilder builder = tagAttribute.createBuilder();
                            builder.putString("Name", attributeKey).putString("AttributeName", attributeKey).putPlaceholderDouble("Amount", value).putInt("Operation", operation);
                            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
                                builder.putUUID("UUID", tagUUID);
                            } else {
                                builder.putLong("UUIDMost", tagUUID.getMostSignificantBits()).putLong("UUIDLeast", tagUUID.getLeastSignificantBits());
                            }
                            if (!slot.equalsIgnoreCase("all")) {
                                builder.putString("Slot", slot);
                            }
                            itemAttributesBuilder.add(builder.build());
                        }
                    }
                    this.tagItemAttributes = itemAttributesBuilder.build();
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "Attributes are configured incorrectly.");
                    if (ConfigExecutor.debugLevel <= 0) break block53;
                    ex.printStackTrace();
                }
            }
        }
        MythicItem.getPlugin().getClock().queuePostReload(() -> {
            List<String> enchantmentsIn = this.config.getStringList("Enchantments");
            for (String in : enchantmentsIn) {
                if (this.addEnchantment(in)) continue;
                MythicLogger.errorItemConfig(this, this.config, "Invalid enchantment configured: " + in);
            }
            this.buildItemCache();
        });
    }

    private Map<String, Object> parseNBTNode(String node) {
        MythicConfig config = this.config;
        ConcurrentMap tags = Maps.newConcurrentMap();
        for (String baseKey : config.getKeys(node)) {
            String innerNode = node + "." + baseKey;
            if (config.isConfigurationSection(innerNode)) {
                tags.put(baseKey, this.parseNBTNode(innerNode));
                continue;
            }
            if (config.isList(innerNode)) {
                tags.put(baseKey, config.getStringList(innerNode));
                continue;
            }
            Object nbtValue = this.getNbtValue(config.getString(innerNode));
            tags.put(baseKey, nbtValue);
        }
        return tags;
    }

    private Object getNbtValue(String string) {
        if (string.startsWith("int/")) {
            return Integer.parseInt(string.substring(4));
        }
        if (string.startsWith("float/")) {
            return Float.valueOf(Float.parseFloat(string.substring(6)));
        }
        if (string.startsWith("double/")) {
            return Double.parseDouble(string.substring(7));
        }
        if (string.startsWith("byte/")) {
            return Byte.parseByte(string.substring(5));
        }
        if (string.startsWith("bool/")) {
            return Boolean.parseBoolean(string.substring(5));
        }
        if (string.startsWith("boolean/")) {
            return Boolean.parseBoolean(string.substring(8));
        }
        return string;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void buildItemCache() {
        this.cachedMenuItem = BukkitAdapter.adapt(this.generateItemStack(1));
        String displayName = this.displayName == null ? "<gray>(No Display Name)" : this.displayName;
        String materialName = this.material == null ? "<gray>Material Not Set" : this.material.toString();
        this.cachedMenuItem = ItemFactory.of(this.cachedMenuItem).hideAttributes().name("<green><bold>" + this.internalName).clearLore().lore("<red> ").lore("<yellow>" + materialName + " <gray>(Model: <aqua>" + this.customModelData + "<gray>)").lore("<red> ").lore(displayName).lore(this.getLore()).lore("<red> ").lore("<rainbow>\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583\u2583").lore("<red> ").lore("<gray>\u22b3 <yellow>Left-Click to get Item").lore("<gray>\u22b3 <yellow>Right-Click to Edit").build();
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    @Deprecated
    public String getMaterialName() {
        return this.strMaterial;
    }

    public boolean setMaterial(String material) {
        if (this.setupMaterial(material)) {
            if (this.config.isSet("Id")) {
                this.config.setSave("Id", material);
            } else {
                this.config.setSave("Material", material);
            }
            this.buildItemCache();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setupMaterial(String material) {
        this.strMaterial = material;
        try {
            if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                this.material = Material.AIR;
                try {
                    Material material2 = this.material = this.data == 0 ? Material.valueOf((String)this.strMaterial) : LegacyItemConverter.getMaterial(this.strMaterial, this.data);
                    if (this.material != null || this.data <= 0) return true;
                    this.material = Material.valueOf((String)this.strMaterial);
                    return true;
                }
                catch (Exception ex) {
                    this.material = LegacyItemConverter.getMaterial(this.strMaterial, this.data);
                    if (this.material != null || this.data <= 0) return true;
                    this.material = Material.valueOf((String)this.strMaterial);
                    return true;
                }
                finally {
                    this.cachedBaseItem = new ItemStack(this.material);
                }
            } else if (this.strMaterial.matches("[0-9]*")) {
                this.material = LegacyItemConverter.getMaterial(this.strMaterial, (byte)0);
                this.cachedBaseItem = new BukkitItemStack(this.material).data(this.data).amount(this.amount * this.amount).build();
                return true;
            } else {
                this.material = Material.valueOf((String)this.strMaterial);
                this.cachedBaseItem = new BukkitItemStack(this.material).data(this.data).amount(this.amount * this.amount).build();
            }
            return true;
        }
        catch (Exception ex) {
            this.material = Material.STONE;
            this.cachedBaseItem = new ItemStack(this.material);
            MythicLogger.errorItemConfig(this, this.config, "Material type '" + this.strMaterial + "' not found");
            return false;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        ArrayList ret = Lists.newArrayList();
        for (PlaceholderString pl : this.lore) {
            ret.add(pl.toString());
        }
        return ret;
    }

    public List<PlaceholderString> getLoreRaw() {
        return this.lore;
    }

    public int getMaxCustomDurability() {
        return this.maxCustomDurability;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean addEnchantment(String in) {
        try {
            PlaceholderInt enchLevel;
            String[] split = in.contains(":") ? in.split(":") : in.split(" ");
            Enchantment ench = Enchantment.getByName((String)split[0]);
            PlaceholderInt placeholderInt = enchLevel = split.length > 1 ? PlaceholderInt.of(split[1]) : PlaceholderInt.of("1");
            if (ench == null) {
                MythicLogger.errorItemConfig(this, this.config, "Enchantment '" + split[0] + "' not found");
                return false;
            }
            this.enchantments.put(ench, enchLevel);
            return true;
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public AbstractItemStack generateItemStack(int amount) {
        return this.generateItemStack(null, amount);
    }

    @Deprecated
    public AbstractItemStack generateItemStack(int amount, AbstractEntity dropper, AbstractEntity trigger) {
        return this.generateItemStack(null, amount);
    }

    public AbstractItemStack generateItemStack(DropMetadata meta, int amount) {
        int durability;
        ItemMeta im;
        AbstractEntity trigger;
        AbstractEntity dropper;
        if (meta != null) {
            dropper = meta.getDropper().isPresent() ? meta.getDropper().get().getEntity() : null;
            trigger = meta.getCause().isPresent() ? meta.getCause().get() : null;
        } else {
            dropper = null;
            trigger = null;
        }
        Entity d = dropper == null ? null : BukkitAdapter.adapt(dropper);
        Entity k = trigger == null ? null : BukkitAdapter.adapt(trigger);
        ItemStack stack = this.cachedBaseItem.clone();
        stack.setAmount(stack.getAmount() * amount);
        CompoundTagBuilder compoundTag = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(stack).createBuilder();
        if (this.itemNBT.size() > 0) {
            try {
                compoundTag = this.generateNBT(compoundTag, this.itemNBT);
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "Failed to add Item NBT - is this version supported?");
            }
        }
        boolean usesDisplayTag = false;
        CompoundTagBuilder displayTag = CompoundTagBuilder.create();
        if (this.displayName != null) {
            usesDisplayTag = true;
            displayTag.putString("Name", (String)GsonComponentSerializer.gson().serialize(Text.parse(this.displayName)));
        }
        if (this.lore != null && this.lore.size() > 0) {
            usesDisplayTag = true;
            ListTagBuilder loreBuilder = ListTagBuilder.create(StringTag.class);
            for (PlaceholderString placeholderString : this.lore) {
                String str = placeholderString.get(meta);
                if ((str = SkillString.parseMessageSpecialChars(str)).contains("{")) {
                    Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                    while (pMatcher.find()) {
                        int min2 = Integer.parseInt(pMatcher.group(1));
                        int max = Integer.parseInt(pMatcher.group(2));
                        int num = Numbers.randomInt(max - min2) + min2;
                        str = str.replace(pMatcher.group(0), "" + num);
                    }
                }
                loreBuilder.add(new StringTag((String)GsonComponentSerializer.gson().serialize(Text.parse(str))));
            }
            displayTag.put("Lore", loreBuilder.build());
        }
        if (usesDisplayTag) {
            compoundTag.put("display", displayTag.build());
        }
        if (this.preventStacking) {
            compoundTag.putUUID("UUID", UUID.randomUUID());
        }
        compoundTag.putAll(this.itemOptions);
        if (this.tagItemAttributes != null) {
            compoundTag.put("AttributeModifiers", this.tagItemAttributes);
        }
        if (this.appendType.booleanValue()) {
            compoundTag.putString("MYTHIC_TYPE", this.mythicTypeOverride);
        }
        if (this.itemVersion > 1) {
            compoundTag.putInt("MYTHIC_ITEM_VERSION", this.itemVersion);
        }
        if (this.maxCustomDurability != 0) {
            compoundTag.putInt("MYTHIC_MAX_CUSTOM_DURABILITY", this.maxCustomDurability);
            compoundTag.putInt("MYTHIC_CURRENT_CUSTOM_DURABILITY", 0);
        }
        if ((im = (stack = MythicItem.getItemHandler().setNBTData(stack, compoundTag.build(), meta)).getItemMeta()) == null && (im = Bukkit.getItemFactory().getItemMeta(stack.getType())) == null) {
            MythicLogger.errorItemConfig(this, this.config, "Failed to apply ItemMeta to item");
            return BukkitAdapter.adapt(stack);
        }
        if (this.lore != null && !this.lore.isEmpty() && !ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            ArrayList parsedLore = Lists.newArrayList();
            for (PlaceholderString pl : this.lore) {
                String str = pl.get(meta);
                if ((str = SkillString.parseMessageSpecialChars(str)).contains("{")) {
                    Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                    while (pMatcher.find()) {
                        int min3 = Integer.parseInt(pMatcher.group(1));
                        int max = Integer.parseInt(pMatcher.group(2));
                        int num = Numbers.randomInt(max - min3) + min3;
                        str = str.replace(pMatcher.group(0), "" + num);
                    }
                }
                parsedLore.add(str);
            }
            im.setLore((List)parsedLore);
        }
        if (!this.bannerLayers.isEmpty() && im instanceof BannerMeta) {
            im = this.buildBanner(im);
        }
        try {
            if (stack.getType().equals((Object)Material.SHIELD)) {
                im = this.buildShield(im);
            }
        }
        catch (Exception parsedLore) {
        }
        catch (Error parsedLore) {
            // empty catch block
        }
        if (stack.getType() == Material.POTION || stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.LINGERING_POTION || stack.getType() == Material.TIPPED_ARROW) {
            im = this.buildPotion(im);
        }
        if (stack.getType().equals((Object)VolatileMaterial.PLAYER_HEAD) || stack.getType().equals((Object)VolatileMaterial.PLAYER_WALL_HEAD)) {
            im = MythicItem.buildSkull((SkullMeta)im, this);
        }
        if (stack.getType().equals((Object)VolatileMaterial.FIREWORK_ROCKET)) {
            im = this.buildFirework(im);
        }
        if (stack.getType().equals((Object)VolatileMaterial.FIREWORK_STAR)) {
            im = this.buildFireworkCharge(im);
        }
        if (meta instanceof MapMeta && this.data > 0) {
            ((MapMeta)meta).setMapId((int)this.data);
            ((MapMeta)meta).setMapView(Bukkit.getMap((int)this.data));
        }
        try {
            if (this.displayName != null && !ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
                im.setDisplayName(this.displayName);
            }
        }
        catch (Exception parsedLore) {
            // empty catch block
        }
        if (this.hideOptions != null) {
            for (String string : this.hideOptions) {
                ItemFlag flag = ItemFlag.valueOf((String)string);
                im.addItemFlags(new ItemFlag[]{flag});
            }
        }
        if ((durability = this.durability.get()) != 0 && im instanceof Damageable) {
            Damageable damageable = (Damageable)im;
            damageable.setDamage(durability);
        }
        if (ServerVersion.isPaper()) {
            if (this.placeOptions != null) {
                ArrayList<NamespacedKey> arrayList = new ArrayList<NamespacedKey>();
                for (String material : this.placeOptions) {
                    arrayList.add(new NamespacedKey("minecraft", material.toLowerCase()));
                }
                im.setPlaceableKeys(arrayList);
            }
            if (this.breakOptions != null) {
                ArrayList<NamespacedKey> arrayList = new ArrayList<NamespacedKey>();
                for (String material : this.breakOptions) {
                    arrayList.add(new NamespacedKey("minecraft", material.toLowerCase()));
                }
                im.setDestroyableKeys(arrayList);
            }
        }
        stack.setItemMeta(im);
        if (this.enchantments != null) {
            stack = this.setEnchantments(dropper, stack);
        }
        if (this.color != null) {
            stack = MythicItem.setLeatherColor(stack, this);
        }
        MythicMobItemGenerateEvent mythicMobItemGenerateEvent = new MythicMobItemGenerateEvent(this, stack);
        Events.callSync(mythicMobItemGenerateEvent);
        stack = mythicMobItemGenerateEvent.getItemStack();
        return BukkitAdapter.adapt(stack);
    }

    private CompoundTagBuilder generateNBT(CompoundTagBuilder builder, Map<String, Object> pairs) {
        if (builder == null) {
            builder = CompoundTagBuilder.create();
        }
        for (Map.Entry<String, Object> entry : pairs.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof Map) {
                builder.put(entry.getKey(), this.generateNBT(null, (Map)val).build());
                continue;
            }
            if (val instanceof List) {
                builder.putStringList(entry.getKey(), (List)val);
                continue;
            }
            if (val instanceof Integer) {
                builder.putInt(entry.getKey(), (Integer)val);
                continue;
            }
            if (val instanceof Double) {
                builder.putDouble(entry.getKey(), (Double)val);
                continue;
            }
            if (val instanceof Float) {
                builder.putFloat(entry.getKey(), ((Float)val).floatValue());
                continue;
            }
            if (val instanceof Boolean) {
                builder.putBoolean(entry.getKey(), (Boolean)val);
                continue;
            }
            if (val instanceof Byte) {
                builder.putByte(entry.getKey(), (Byte)val);
                continue;
            }
            builder.putString(entry.getKey(), val.toString());
        }
        return builder;
    }

    private ItemStack setEnchantments(AbstractEntity entity, ItemStack stack) {
        if (this.enchantments == null || this.enchantments.isEmpty()) {
            return stack;
        }
        int maxEnchants = entity == null ? this.maxEnchantments.get() : this.maxEnchantments.get(entity);
        if (maxEnchants > 0) {
            ArrayList enchantsToApply = Lists.newArrayList(this.enchantments.keySet());
            Collections.shuffle(enchantsToApply);
            int enchants = 0;
            for (Enchantment enchant : enchantsToApply) {
                int enchantLevel = this.enchantments.get(enchant).get(entity);
                if (enchantLevel == 0) continue;
                this.applyEnchantToItem(stack, enchant, enchantLevel);
                if (maxEnchants <= 0 || ++enchants < maxEnchants) continue;
                break;
            }
        } else {
            for (Map.Entry<Enchantment, PlaceholderInt> entry : this.enchantments.entrySet()) {
                Enchantment enchant = entry.getKey();
                int enchantLevel = entry.getValue().get(entity);
                if (enchantLevel == 0) continue;
                this.applyEnchantToItem(stack, enchant, enchantLevel);
            }
        }
        return stack;
    }

    private void applyEnchantToItem(ItemStack stack, Enchantment enchant, int enchantLevel) {
        MythicApplyEnchantEvent event = new MythicApplyEnchantEvent(stack, enchant, enchantLevel);
        if ((event = Events.callAndReturn(event)).getWasHandled().booleanValue()) {
            return;
        }
        if (stack.getType() != Material.ENCHANTED_BOOK) {
            stack.addUnsafeEnchantment(enchant, enchantLevel);
        } else {
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
            esm.addStoredEnchant(enchant, enchantLevel, true);
            stack.setItemMeta((ItemMeta)esm);
        }
    }

    private ItemMeta buildPotion(ItemMeta im) {
        PotionMeta pm = (PotionMeta)im;
        if (this.color != null) {
            try {
                String[] rgb = this.color.split(",");
                int r = new RandomInt(rgb[0]).get();
                int g2 = new RandomInt(rgb[1]).get();
                int b = new RandomInt(rgb[2]).get();
                pm.setColor(Color.fromRGB((int)r, (int)g2, (int)b));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.potionEffects != null) {
            pm.clearCustomEffects();
            for (String s2 : this.potionEffects) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 3) {
                        MythicLogger.errorItemConfig(this, this.config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s2);
                        continue;
                    }
                    PotionEffectType pet = PotionEffectType.getByName((String)sp[0].toUpperCase());
                    int duration = Integer.parseInt(sp[1]);
                    int level = Integer.parseInt(sp[2]);
                    PotionEffect p = new PotionEffect(pet, duration, level - 1, true);
                    pm.addCustomEffect(p, false);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s2);
                }
            }
        }
        return im;
    }

    private ItemMeta buildFirework(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        FireworkMeta pm = (FireworkMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.addEffect(builder.build());
        return im;
    }

    private ItemMeta buildFireworkCharge(ItemMeta im) {
        int b;
        int g2;
        int r;
        String[] rgb;
        FireworkEffectMeta pm = (FireworkEffectMeta)im;
        FireworkEffect.Builder builder = FireworkEffect.builder();
        if (this.fireworkColors != null) {
            for (String s2 : this.fireworkColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.fireworkFadeColors != null) {
            for (String s2 : this.fireworkFadeColors) {
                try {
                    rgb = s2.split(",");
                    r = Integer.parseInt(rgb[0]);
                    g2 = Integer.parseInt(rgb[1]);
                    b = Integer.parseInt(rgb[2]);
                    builder.withColor(Color.fromRGB((int)r, (int)g2, (int)b));
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A firework fade color is configured incorrectly. Format is 'red,green,blue'. Line=" + s2);
                }
            }
        }
        if (this.config.getBoolean("Firework.Flicker", false)) {
            builder.withFlicker();
        }
        if (this.config.getBoolean("Firework.Trail", false)) {
            builder.withTrail();
        }
        pm.setEffect(builder.build());
        return im;
    }

    private ItemMeta buildBanner(ItemMeta im) {
        if (this.color != null) {
            try {
                ((BannerMeta)im).setBaseColor(DyeColor.valueOf((String)this.color));
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "A banner color is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
            }
        }
        if (this.bannerLayers != null) {
            for (String s2 : this.bannerLayers) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 2) {
                        MythicLogger.errorItemConfig(this, this.config, "A banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                        continue;
                    }
                    DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                    PatternType pt = PatternType.valueOf((String)sp[1]);
                    Pattern p = new Pattern(dc, pt);
                    ((BannerMeta)im).addPattern(p);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                }
            }
        }
        return im;
    }

    private ItemMeta buildShield(ItemMeta im) {
        if (this.color == null && this.bannerLayers.isEmpty()) {
            return im;
        }
        BlockStateMeta meta = (BlockStateMeta)im;
        Banner banner = (Banner)meta.getBlockState();
        if (this.color != null) {
            try {
                banner.setBaseColor(DyeColor.valueOf((String)this.color));
            }
            catch (Exception ex) {
                MythicLogger.errorItemConfig(this, this.config, "The shield color is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
            }
        }
        if (this.bannerLayers != null) {
            for (String s2 : this.bannerLayers) {
                try {
                    String[] sp = s2.split(" ");
                    if (sp.length < 2) {
                        MythicLogger.errorItemConfig(this, this.config, "A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                        continue;
                    }
                    DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                    PatternType pt = PatternType.valueOf((String)sp[1]);
                    Pattern p = new Pattern(dc, pt);
                    banner.addPattern(p);
                }
                catch (Exception ex) {
                    MythicLogger.errorItemConfig(this, this.config, "A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s2);
                }
            }
        }
        banner.update();
        meta.setBlockState((BlockState)banner);
        return meta;
    }

    private static ItemStack setLeatherColor(ItemStack item, MythicItem mi) {
        if (item.getType().equals((Object)Material.LEATHER_CHESTPLATE) || item.getType().equals((Object)Material.LEATHER_BOOTS) || item.getType().equals((Object)Material.LEATHER_LEGGINGS) || item.getType().equals((Object)Material.LEATHER_HELMET) || item.getType().equals((Object)Material.LEATHER_HORSE_ARMOR)) {
            ItemMeta im = item.getItemMeta();
            LeatherArmorMeta la = (LeatherArmorMeta)im;
            if (mi.color.contains(",")) {
                String[] rgb = mi.color.split(",");
                int r = new RandomInt(rgb[0]).get();
                int g2 = new RandomInt(rgb[1]).get();
                int b = new RandomInt(rgb[2]).get();
                la.setColor(Color.fromRGB((int)r, (int)g2, (int)b));
            } else {
                DyeColor dColor = DyeColor.valueOf((String)mi.color);
                la.setColor(dColor.getColor());
            }
            item.setItemMeta((ItemMeta)la);
        }
        return item;
    }

    private static ItemMeta buildSkull(SkullMeta meta, MythicItem mi) {
        if (mi.player != null) {
            meta.setOwner(mi.player);
        } else if (mi.skinTexture != null) {
            GameProfile profile = new GameProfile(mi.skinUUID, null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", mi.skinTexture));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else if (mi.skinURL != null) {
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + mi.skinURL + "\"}}}"))));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return meta;
    }

    @Override
    public int compareTo(MythicItem o) {
        return this.internalName.compareTo(o.getInternalName());
    }

    @Override
    public Icon<ItemMenuContext> getIcon() {
        return IconBuilder.create().itemStack(this.cachedMenuItem).hideFlags().click((context, player) -> {
            player.performCommand("mythicmobs i get " + this.internalName);
            player.playSound(player.getLocation(), "entity.experience_orb.pickup", 1.0f, 1.0f);
        }).rightClick((context, player) -> {
            ItemEditorMenuContext ctx = new ItemEditorMenuContext(this, (ItemMenuContext)context);
            MythicItem.getPlugin().getMenuManager().getItemEditorMenu().open((Player)player, ctx);
        }).build();
    }

    public ItemStack getCachedBaseItem() {
        return this.cachedBaseItem;
    }

    public ItemStack getCachedMenuItem() {
        return this.cachedMenuItem;
    }

    public Pack getPack() {
        return this.pack;
    }

    public String getGroup() {
        return this.group;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setStrMaterial(String strMaterial) {
        this.strMaterial = strMaterial;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    public void setLore(List<PlaceholderString> lore) {
        this.lore = lore;
    }

    public Map<Enchantment, PlaceholderInt> getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(Map<Enchantment, PlaceholderInt> enchantments) {
        this.enchantments = enchantments;
    }

    public List<String> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(List<String> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public List<String> getBannerLayers() {
        return this.bannerLayers;
    }

    public void setBannerLayers(List<String> bannerLayers) {
        this.bannerLayers = bannerLayers;
    }

    public List<String> getFireworkColors() {
        return this.fireworkColors;
    }

    public void setFireworkColors(List<String> fireworkColors) {
        this.fireworkColors = fireworkColors;
    }

    public List<String> getFireworkFadeColors() {
        return this.fireworkFadeColors;
    }

    public void setFireworkFadeColors(List<String> fireworkFadeColors) {
        this.fireworkFadeColors = fireworkFadeColors;
    }

    public Map<String, Object> getItemNBT() {
        return this.itemNBT;
    }

    public String getMythicTypeOverride() {
        return this.mythicTypeOverride;
    }

    public void setMythicTypeOverride(String mythicTypeOverride) {
        this.mythicTypeOverride = mythicTypeOverride;
    }

    public Boolean getAppendType() {
        return this.appendType;
    }

    public void setAppendType(Boolean appendType) {
        this.appendType = appendType;
    }

    public int getItemVersion() {
        return this.itemVersion;
    }
}

