/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.holograms.types;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.holograms.HologramManager;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.utils.MythicUtil;
import java.util.UUID;

public class SpeechBubble
implements Terminable {
    private final SkillCaster activemob;
    private final HologramManager manager;
    private IHologram hologram;
    private String text = "";
    private String linePrefix = "";
    private int lineLength = 24;
    private double yOffset;
    private double currentOffset = this.yOffset = 0.4;
    private TerminableRegistry components = TerminableRegistry.create();

    public SpeechBubble(HologramManager manager, SkillCaster am) {
        this.manager = manager;
        this.activemob = am;
        if (am instanceof ActiveMob) {
            this.yOffset = ((ActiveMob)am).getType().getConfig().getDouble("Speech.Offset", this.yOffset);
        }
        this.hologram = manager.createHologram("#TempSpeechBubble" + this.activemob.getEntity().getUniqueId().toString(), this.getLocation(), " ");
        this.components.accept(this.hologram);
        this.components.accept(Events.subscribe(MythicMobDeathEvent.class).handler(event -> {
            UUID uuid = event.getEntity().getUniqueId();
            if (this.activemob.getEntity().getUniqueId().equals(uuid)) {
                this.terminate();
            }
        }));
        this.components.accept(Events.subscribe(MythicMobDespawnEvent.class).handler(event -> {
            UUID uuid = event.getEntity().getUniqueId();
            if (this.activemob.getEntity().getUniqueId().equals(uuid)) {
                this.terminate();
            }
        }));
        this.components.accept(Schedulers.async().runRepeating(() -> this.check(), 1L, 10L));
        this.components.accept(Schedulers.async().runRepeating(() -> this.teleport(), 1L, 1L));
    }

    public boolean check() {
        if (this.activemob.getEntity().isDead() || !this.activemob.getEntity().isValid()) {
            this.terminate();
            return false;
        }
        return true;
    }

    public void teleport() {
        AbstractLocation location = this.getLocation();
        if (location == null) {
            this.terminate();
        } else {
            this.hologram.teleport(this.getLocation());
        }
    }

    @Override
    public void close() {
        this.components.terminate();
    }

    private AbstractLocation getLocation() {
        return this.activemob.getEntity().getEyeLocation().add(0.0, this.currentOffset, 0.0);
    }

    public void setText(String text) {
        if (text.length() > this.lineLength) {
            String[] lines = MythicUtil.wrapString(text, this.lineLength);
            this.currentOffset = this.yOffset + (double)lines.length * 0.25;
            this.hologram.setText(lines, this.linePrefix);
        } else {
            this.currentOffset = this.yOffset;
            this.hologram.setText(this.linePrefix + text);
        }
    }

    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(double yOffset) {
        this.yOffset = yOffset;
    }
}

