/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.holograms.types;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.holograms.HologramManager;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.UUID;
import org.bukkit.ChatColor;

public class HealthBar
implements Terminable {
    private final ActiveMob activemob;
    private final HologramManager manager;
    private IHologram hologram;
    private double yOffset;
    private TerminableRegistry components = TerminableRegistry.create();

    public HealthBar(HologramManager manager, ActiveMob am) {
        this.manager = manager;
        this.activemob = am;
        this.yOffset = am.getType().getConfig().getDouble("HealthBar.Offset", am.getType().isFakePlayer() ? (double)0.3f : am.getType().getMythicEntity().getHealthbarOffset());
        this.hologram = manager.createHologram("#TempHealthBar" + this.activemob.getUniqueId().toString(), this.getLocation(), this.getLine());
        this.components.accept(this.hologram);
        this.components.accept(Events.subscribe(MythicMobDeathEvent.class).handler(event -> {
            UUID uuid = event.getEntity().getUniqueId();
            if (this.activemob.getUniqueId().equals(uuid)) {
                this.terminate();
            }
        }));
        this.components.accept(Events.subscribe(MythicMobDespawnEvent.class).handler(event -> {
            UUID uuid = event.getEntity().getUniqueId();
            if (this.activemob.getUniqueId().equals(uuid)) {
                this.terminate();
            }
        }));
        this.components.accept(Schedulers.async().runRepeating(() -> this.check(), 1L, 10L));
        this.components.accept(Schedulers.async().runRepeating(() -> this.teleport(), 1L, 1L));
    }

    public boolean check() {
        if (this.activemob.isDead() || !this.activemob.getEntity().isValid() || this.activemob.getEntity().getHealth() == this.activemob.getEntity().getMaxHealth()) {
            this.terminate();
            return false;
        }
        return true;
    }

    public void teleport() {
        AbstractLocation location = this.getLocation();
        if (location == null) {
            this.terminate();
        } else {
            this.hologram.teleport(this.getLocation());
        }
    }

    @Override
    public void close() {
        this.components.closeAndReportException();
    }

    private AbstractLocation getLocation() {
        return this.activemob.getEntity().getEyeLocation().add(0.0, this.yOffset, 0.0);
    }

    public void update() {
        this.hologram.setText(this.getLine());
    }

    private String getLine() {
        int hp = (int)this.activemob.getEntity().getHealth();
        double percent = this.activemob.getEntity().getHealth() / this.activemob.getEntity().getMaxHealth();
        String sHP = String.valueOf(hp);
        int hplength = sHP.length();
        int length = 10 + hplength;
        int gray = (int)Math.floor(percent * (double)length);
        StringBuilder line = new StringBuilder().append(ChatColor.DARK_RED).append("[");
        boolean passed = false;
        for (int i = 0; i < length; ++i) {
            if (!passed && i > gray) {
                passed = true;
            }
            if (i < 5) {
                line.append(passed ? ChatColor.DARK_GRAY : ChatColor.RED);
                line.append("|");
                continue;
            }
            if (i < 5 + hplength) {
                line.append(passed ? ChatColor.GRAY : ChatColor.DARK_RED);
                try {
                    line.append(sHP.substring(i - 5, i - 4));
                }
                catch (Exception exception) {}
                continue;
            }
            if (i == hplength + 2 && !passed) {
                line.append(ChatColor.RED);
            }
            line.append(passed ? ChatColor.DARK_GRAY : ChatColor.RED);
            line.append("|");
        }
        return line.append(ChatColor.DARK_RED).append("]").toString();
    }
}

