/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.config.MemorySection;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.file.YamlConfiguration;
import io.lumine.mythic.core.config.GenericConfig;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MythicConfigImpl
implements GenericConfig,
Cloneable,
MythicConfig {
    private String configName;
    private File file;
    private FileConfiguration fc;

    public MythicConfigImpl(FileConfiguration fc) {
        this(null, null, fc);
    }

    public MythicConfigImpl(String name, FileConfiguration fc) {
        this(name, null, fc);
    }

    public MythicConfigImpl(MythicConfig config, String name) {
        this(name, config.getFile(), config.getFileConfiguration());
    }

    public MythicConfigImpl(File file) {
        this("", file);
    }

    public MythicConfigImpl(String name, File file) {
        this(name, file, null);
        this.fc = new YamlConfiguration();
        try {
            this.fc.load(file);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        if (!this.fc.isConfigurationSection(this.configName)) {
            this.fc.createSection(this.configName);
        }
    }

    public MythicConfigImpl(String name, File file, FileConfiguration fc) {
        this.configName = name;
        this.file = file;
        this.fc = fc;
    }

    @Override
    public void setKey(String key) {
        this.configName = key;
    }

    @Override
    public String getKey() {
        return this.configName;
    }

    @Override
    public String getFileName() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        if (this.configName != null) {
            return "Nested Configuration '" + this.configName + "'";
        }
        return "API";
    }

    @Override
    public FileConfiguration getFileConfiguration() {
        return this.fc;
    }

    public String getNode() {
        if (this.configName == null || this.configName.length() == 0) {
            return "";
        }
        return this.configName + ".";
    }

    @Override
    public void deleteNodeAndSave() {
        this.fc.set(this.getNode(), null);
        this.save();
    }

    @Override
    public boolean isSet(String field) {
        return this.fc.isSet(this.getNode() + field);
    }

    @Override
    public void set(String key, Object value) {
        this.fc.set(this.getNode() + key, value);
    }

    @Override
    public void setSave(String key, Object value) {
        this.fc.set(this.getNode() + key, value);
        this.save();
    }

    @Override
    public void unset(String key) {
        this.fc.set(this.getNode() + key, null);
    }

    @Override
    public void unsetSave(String key) {
        this.unset(key);
        this.save();
    }

    @Override
    public void load() {
        this.fc = YamlConfiguration.loadConfiguration(this.file);
    }

    @Override
    public void save() {
        if (this.file == null) {
            MythicLogger.errorGenericConfig("Save operation not supported on null file: " + this.getFileName());
            return;
        }
        try {
            this.fc.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MythicConfig getNestedConfig(String field) {
        return new MythicConfigImpl(this.getNode() + field, this.file, this.fc);
    }

    @Override
    public Map<String, MythicConfig> getNestedConfigs(String key) {
        HashMap<String, MythicConfig> map = new HashMap<String, MythicConfig>();
        if (!this.isSet(key)) {
            return map;
        }
        for (String k : this.getKeys(key)) {
            map.put(k, new MythicConfigImpl(this.getNode() + key + "." + k, this.fc));
        }
        return map;
    }

    @Override
    public String getString(String field) {
        String key = this.getNode() + field;
        return this.fc.getString(key, this.fc.getString(key.toLowerCase()));
    }

    @Override
    public String getString(String[] key) {
        return this.getString(key, null, new String[0]);
    }

    @Override
    public String getString(String field, String def) {
        String key = this.getNode() + field;
        return this.fc.getString(key, this.fc.getString(key.toLowerCase(), def));
    }

    @Override
    public String getString(String[] key, String def, String ... args) {
        String s2 = null;
        for (String k : key) {
            s2 = this.getString(k, null);
            if (s2 == null) continue;
            return s2;
        }
        for (String a : args) {
            if (a == null) continue;
            return a;
        }
        return def;
    }

    @Override
    public PlaceholderString getPlaceholderString(String field) {
        String key = this.getNode() + field;
        String s2 = this.fc.getString(key);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    @Override
    public PlaceholderString getPlaceholderString(String field, String def) {
        String key = this.getNode() + field;
        String s2 = this.fc.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderString.of(s2);
    }

    @Override
    public String getColorString(String field) {
        String key = this.getNode() + field;
        String s2 = this.fc.getString(key);
        if (s2 != null) {
            s2 = ChatColor.translateAlternateColorCodes((char)'&', (String)s2);
        }
        return s2;
    }

    @Override
    public String getColorString(String field, String def) {
        String key = this.getNode() + field;
        String s2 = this.fc.getString(key, def);
        if (s2 != null) {
            s2 = ChatColor.translateAlternateColorCodes((char)'&', (String)s2);
        }
        return s2;
    }

    @Override
    public boolean getBoolean(String field) {
        String key = this.getNode() + field;
        return this.fc.getBoolean(this.getNode() + field);
    }

    @Override
    public boolean getBoolean(String field, boolean def) {
        return this.fc.getBoolean(this.getNode() + field, def);
    }

    @Override
    public int getInteger(String field) {
        String key = this.getNode() + field;
        return this.fc.getInt(key, this.fc.getInt(key.toLowerCase()));
    }

    @Override
    public int getInteger(String field, int def) {
        String key = this.getNode() + field;
        return this.fc.getInt(key, this.fc.getInt(key.toLowerCase(), def));
    }

    @Override
    public int getInteger(String[] keys, int def) {
        for (String string : keys) {
            String string2 = this.getNode() + string;
            if (!this.fc.isInt(string2)) continue;
            return this.fc.getInt(string2);
        }
        return def;
    }

    @Override
    @Deprecated
    public int getInt(String field) {
        String key = this.getNode() + field;
        return this.fc.getInt(this.getNode() + field);
    }

    @Override
    @Deprecated
    public int getInt(String field, int def) {
        String key = this.getNode() + field;
        return this.fc.getInt(this.getNode() + field, def);
    }

    @Override
    public float getFloat(String field) {
        return (float)this.getDouble(field);
    }

    @Override
    public float getFloat(String field, float def) {
        return (float)this.getDouble(field, def);
    }

    @Override
    public double getDouble(String field) {
        String key = this.getNode() + field;
        return this.fc.getDouble(this.getNode() + field);
    }

    @Override
    public double getDouble(String field, double def) {
        String key = this.getNode() + field;
        return this.fc.getDouble(this.getNode() + field, def);
    }

    @Override
    public List<String> getStringList(String field) {
        String key = this.getNode() + field;
        return this.fc.getStringList(this.getNode() + field);
    }

    @Override
    public List<String> getColorStringList(String field) {
        String key = this.getNode() + field;
        List<String> list = this.fc.getStringList(this.getNode() + field);
        ArrayList<String> parsed = new ArrayList<String>();
        if (list != null) {
            for (String str : list) {
                parsed.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
            }
        }
        return parsed;
    }

    @Override
    public List<PlaceholderString> getPlaceholderStringList(String field) {
        String key = this.getNode() + field;
        List<String> list = this.fc.getStringList(this.getNode() + field);
        ArrayList<PlaceholderString> parsed = new ArrayList<PlaceholderString>();
        if (list != null) {
            for (String str : list) {
                parsed.add(PlaceholderString.of(str));
            }
        }
        return parsed;
    }

    @Override
    public List<Map<?, ?>> getMapList(String field) {
        String key = this.getNode() + field;
        return this.fc.getMapList(this.getNode() + field);
    }

    @Override
    public List<?> getList(String field) {
        String key = this.getNode() + field;
        if (this.fc.isSet(key)) {
            return this.fc.getList(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getList(key.toLowerCase());
        }
        return null;
    }

    @Override
    public List<Byte> getByteList(String field) {
        String key = this.getNode() + field;
        if (this.fc.isSet(key)) {
            return this.fc.getByteList(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getByteList(key.toLowerCase());
        }
        return null;
    }

    @Override
    public ItemStack getItemStack(String field, String def) {
        String key = this.getNode() + field;
        if (this.fc.isSet(key)) {
            return this.fc.getItemStack(key);
        }
        if (this.fc.isSet(key.toLowerCase())) {
            return this.fc.getItemStack(key.toLowerCase());
        }
        try {
            return new ItemStack(Material.valueOf((String)def));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean isConfigurationSection(String section) {
        String key = this.getNode() + section;
        return this.fc.isConfigurationSection(this.getNode() + section);
    }

    @Override
    public Set<String> getKeys(String section) {
        String key = this.getNode() + section;
        return this.fc.getConfigurationSection(this.getNode() + section).getKeys(false);
    }

    @Override
    public boolean isList(String section) {
        String key = this.getNode() + section;
        return this.fc.isList(this.getNode() + section);
    }

    @Override
    public PlaceholderInt getPlaceholderInt(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInt(String[] key, String def) {
        String s2 = this.getString(key, def, new String[0]);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderInt getPlaceholderInt(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderInt.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String key, String def) {
        String s2 = this.getString(key, def);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public PlaceholderDouble getPlaceholderDouble(String[] key, String def, String ... args) {
        String s2 = this.getString(key, def, args);
        if (s2 == null) {
            return null;
        }
        return PlaceholderDouble.of(s2);
    }

    @Override
    public <T extends Enum> T getEnum(String field, Class<T> clazz, T def) {
        try {
            String in = this.getString(field);
            if (in == null) {
                return def;
            }
            T value = Enum.valueOf(clazz, in.toUpperCase());
            if (value == null) {
                return def;
            }
            return value;
        }
        catch (Error | Exception ex) {
            return def;
        }
    }

    @Override
    public void merge(MythicConfig tmplConfig, List<String> keysToIgnore) {
        FileConfiguration thisFile = this.fc;
        FileConfiguration tmplFile = tmplConfig.getFileConfiguration();
        String thisMob = this.configName;
        String tmplMob = tmplConfig.getKey();
        for (String key : tmplConfig.getKeys("")) {
            Object templateStringList;
            if (keysToIgnore.contains(key)) continue;
            if (this.getStringList(key).size() > 0) {
                templateStringList = tmplConfig.getStringList(key);
                List<String> currentStringList = this.getStringList(key);
                templateStringList.addAll(currentStringList);
                this.set(key, templateStringList);
                continue;
            }
            if (!this.isSet(key)) {
                this.set(key, tmplFile.get(tmplMob + "." + key));
                continue;
            }
            templateStringList = thisFile.get(thisMob + "." + key);
            if (!(templateStringList instanceof MemorySection)) continue;
            MemorySection thisMemory = (MemorySection)templateStringList;
            MemorySection templateMemory = (MemorySection)tmplFile.get(tmplMob + "." + key);
            for (String node : templateMemory.getKeys(false)) {
                if (thisMemory.isSet(node)) continue;
                Object nodeValue = templateMemory.get(node);
                thisMemory.set(node, nodeValue);
            }
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

