/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import io.lumine.mythic.api.config.ConfigManager;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.skills.SkillString;
import java.io.File;
import java.util.HashSet;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.Material;

public class ConfigExecutor
extends ReloadableModule<MythicBukkit>
implements ConfigManager {
    private IOLoader<MythicBukkit> settings;
    private MythicConfig config;
    private int clockIntervalMain = 1;
    private int clockIntervalRandomSpawning = 1;
    public static int debugLevel = -1;
    public static boolean debugMode = false;
    public static boolean debugSpawners = false;
    public static boolean errorLogging = true;
    public static int SaveInteval = 300;
    public static int SpawningInterval = 1;
    public static int timerupdate;
    public static int walkupdate;
    public static int ShowHealthRadius;
    public static int ScanInterval;
    public static int ClnrInterval;
    private Boolean allowMetrics = true;
    public static boolean UseCompatibilityMode;
    public static boolean UseVolatileFeatures;
    public static String ShowHealthFormat;
    public static String KillMessagePrefix;
    public static boolean AllowUpdateChecking;
    public static int SpawnerRange;
    private static int bossBarUpdateInterval;
    private Boolean skillsIgnoreArmorStandsByDefault = true;
    private Boolean mobsDespawnByDefault = false;
    private Boolean preventOtherDropsByDefault = false;
    public static boolean EnableAIModifiers;
    public static boolean EnableTimerSkills;
    public static boolean EnableThreatTables;
    public static boolean EnablePlayerFactions;
    public static boolean EnableLegacySkills;
    public static String defaultLevelModifierHealth;
    public static String defaultLevelModifierDamage;
    public static String defaultLevelModifierPower;
    public static String defaultLevelModifierArmor;
    public static String defaultLevelModifierKBR;
    public static boolean targetSelf;
    public static boolean targetPlayers;
    public static boolean targetArmorStands;
    public static boolean targetMarkers;
    public static boolean targetCreativeMode;
    public static boolean targetSpectatorMode;
    public static boolean targetCitizensNPCs;
    public static boolean targetAnimals;
    public static boolean targetCreatures;
    public static boolean targetMonsters;
    public static boolean targetWaterMobs;
    public static boolean targetFlyingMobs;
    public static boolean targetSameFaction;
    public static boolean targetOwner;
    public static boolean targetNonMythic;
    public static boolean targetVillagers;
    public static boolean apiUseDeathEvent;
    public static boolean apiUseSkillEvent;
    public static boolean apiUseCustomSkillEvent;
    public static boolean compatHeroesXPEnable;
    public static boolean compatHeroesShowXPMessage;
    public static String compatHeroesXPMessageFormat;
    public static boolean compatSkillAPIShowXPMessage;
    public static String compatSkillAPIXPMessageFormat;
    public static boolean compatVaultShowMoneyMessage;
    public static String compatVaultMoneyMessageFormat;
    public static boolean compatMcMMOShowXPMessage;
    public static String compatMcMMOXPMessageFormat;
    private static boolean rsGeneratePoints;
    private static int rsMaxMobsPerChunk;
    private int randomSpawningPlayerRadiusMax = 64;
    private int randomSpawningPlayerRadiusMin = 16;
    private int randomSpawningPlayerRadiusY = 16;
    private static int rsPointsPerSecondLand;
    private static int rsPointsPerSecondAir;
    private static int rsPointsPerSecondSea;
    private static int rsPointsPerSecondLava;
    private static int rsPointsPerSecondGround;
    private static int rsMaxGenerationTimeMillis;
    private static boolean rsDespawnVanillaOutsideRadius;
    private static boolean vanillaSpawnsDisabled;
    private static boolean loadExampleConfigs;
    private Expression scalingEquationDamage = null;
    private Expression scalingEquationHealth = null;
    public static boolean updateItems;
    private static HashSet<Material> transparentBlocks;

    public ConfigExecutor(MythicBukkit core) {
        super(core, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.settings = new IOLoader<MythicBukkit>(plugin, "config.yml");
        this.loadSettings();
        plugin.getClock().setReloadingPause(true);
        try {
            plugin.reloadConfiguration();
            plugin.getPackManager().loadPacks();
            plugin.getItemManager().load(plugin);
            plugin.getSkillManager().loadSkills();
            plugin.getMobManager().loadMobs();
            plugin.getDropManager().loadDropTables();
            plugin.getRandomSpawningManager().loadRandomSpawns();
            plugin.getSpawnerManager().loadSpawners();
        }
        finally {
            plugin.getClock().setReloadingPause(false);
        }
        plugin.getClock().runSecondPass();
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getMobManager().getMobTypes().size() + " mobs.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getMobManager().getVanillaTypes().size() + " vanilla mob overrides.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getMobManager().getMobStacks().size() + " mob stacks.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getSkillManager().getSkills().size() + " skills.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getRandomSpawningManager().getNumberOfSpawners() + " random spawns.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getItemManager().getItems().size() + " mythic items.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getDropManager().getDropTables().size() + " drop tables.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getSpawnerManager().getSpawners().size() + " mob spawners.");
    }

    public void save() {
        Schedulers.async().run(() -> {
            try {
                ((MythicBukkit)this.getPlugin()).getMobManager().saveCachedActiveMobs();
                ((MythicBukkit)this.getPlugin()).getPlayerManager().saveAll();
                ((MythicBukkit)this.getPlugin()).getWorldManager().saveAll();
                ((MythicBukkit)this.getPlugin()).getVariableManager().save();
                ((MythicBukkit)this.getPlugin()).getSpawnerManager().saveSpawners();
            }
            catch (Error | Exception ex) {
                MythicLogger.log(ConsoleColor.RED + ConsoleColor.ERROR_MARK + ConsoleColor.WHITE + "An error occurred while saving data");
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void unload() {
        this.save();
        ((MythicBukkit)this.plugin).getDropManager().unload();
        ((MythicBukkit)this.plugin).getItemManager().unload();
    }

    public void loadSettings() {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Settings...", new Object[0]);
        MythicConfigImpl mc = new MythicConfigImpl("Configuration", this.settings.getCustomConfig());
        this.allowMetrics = mc.getBoolean("General.AllowMetrics", true);
        if (debugLevel == -1) {
            debugLevel = mc.getInteger("General.DebugLevel", 0);
        }
        errorLogging = mc.getBoolean("General.ErrorLogging", true);
        UseCompatibilityMode = mc.getBoolean("General.Compatibilitymode", false);
        UseVolatileFeatures = mc.getBoolean("General.UseVolatileFeatures", true);
        AllowUpdateChecking = mc.getBoolean("General.CheckForUpdates", true);
        int i = mc.getInteger("Clock.SaveInterval", 5);
        SaveInteval = i * 60;
        this.clockIntervalMain = mc.getInteger(new String[]{"Clock.ClockInterval", "Clock.Main"}, 1);
        this.clockIntervalRandomSpawning = mc.getInteger(new String[]{"Clock.RandomSpawning"}, 1);
        SpawningInterval = mc.getInteger("Clock.SpawnsInterval", 2);
        ScanInterval = mc.getInteger("Clock.ScannerInterval", 10);
        ClnrInterval = mc.getInteger("Clock.CleanupInterval", 600);
        targetSelf = mc.getBoolean("Targeters.Filters.Default.TargetSelf", false);
        targetPlayers = mc.getBoolean("Targeters.Filters.Default.TargetPlayers", true);
        targetArmorStands = mc.getBoolean("Targeters.Filters.Default.TargetArmorStands", false);
        targetMarkers = mc.getBoolean("Targeters.Filters.Default.TargetMarkers", false);
        targetCreativeMode = mc.getBoolean("Targeters.Filters.Default.TargetCreativeMode", true);
        targetSpectatorMode = mc.getBoolean("Targeters.Filters.Default.TargetSpectatorMode", true);
        targetCitizensNPCs = mc.getBoolean("Targeters.Filters.Default.TargetCitizensNPCs", false);
        targetAnimals = mc.getBoolean("Targeters.Filters.Default.TargetAnimals", true);
        targetCreatures = mc.getBoolean("Targeters.Filters.Default.TargetCreatures", true);
        targetMonsters = mc.getBoolean("Targeters.Filters.Default.TargetMonsters", true);
        targetWaterMobs = mc.getBoolean("Targeters.Filters.Default.TargetWaterMobs", true);
        targetFlyingMobs = mc.getBoolean("Targeters.Filters.Default.TargetFlyingMobs", true);
        targetSameFaction = mc.getBoolean("Targeters.Filters.Default.TargetSameFaction", true);
        targetOwner = mc.getBoolean("Targeters.Filters.Default.TargetOwner", true);
        targetNonMythic = mc.getBoolean("Targeters.Filters.Default.TargetNonMythic", true);
        targetVillagers = mc.getBoolean("Targeters.Filters.Default.TargetVillagers", true);
        this.mobsDespawnByDefault = mc.getBoolean("Mobs.DespawnByDefault", true);
        this.preventOtherDropsByDefault = mc.getBoolean("Mobs.PreventOtherDropsByDefault", false);
        EnableAIModifiers = mc.getBoolean("Mobs.EnableAIModifiers", true);
        EnableTimerSkills = mc.getBoolean("Mobs.EnableTimerSkills", true);
        EnableLegacySkills = mc.getBoolean("Mobs.EnableLegacySkills", false);
        EnableThreatTables = mc.getBoolean("Mobs.EnableThreatTables", true);
        EnablePlayerFactions = mc.getBoolean("Mobs.EnablePlayerFactions", true);
        ShowHealthRadius = mc.getInteger("Mobs.ShowHealth.Radius", 25);
        ShowHealthFormat = mc.getString("Mobs.ShowHealth.Format", ShowHealthFormat);
        KillMessagePrefix = SkillString.parseMessageSpecialChars(mc.getString("Mobs.KillMessagePrefix", KillMessagePrefix));
        int barUpdateInterval = mc.getInteger("Mobs.BossBar.UpdateInterval", 20);
        bossBarUpdateInterval = barUpdateInterval <= 0 ? 20 : barUpdateInterval;
        rsGeneratePoints = mc.getBoolean("RandomSpawning.GenerateSpawnPoints", false);
        rsMaxMobsPerChunk = mc.getInteger("RandomSpawning.MaxMobsPerChunk", 2);
        this.randomSpawningPlayerRadiusMax = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayer", 64);
        this.randomSpawningPlayerRadiusMin = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerMin", 16);
        this.randomSpawningPlayerRadiusY = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerY", 16);
        rsPointsPerSecondLand = mc.getInteger("RandomSpawning.PointsPerSecond.Land", 10);
        rsPointsPerSecondAir = mc.getInteger("RandomSpawning.PointsPerSecond.Air", 1);
        rsPointsPerSecondSea = mc.getInteger("RandomSpawning.PointsPerSecond.Sea", 1);
        rsPointsPerSecondLava = mc.getInteger("RandomSpawning.PointsPerSecond.Lava", 0);
        rsPointsPerSecondGround = mc.getInteger("RandomSpawning.PointsPerSecond.Ground", 0);
        rsDespawnVanillaOutsideRadius = mc.getBoolean("RandomSpawning.DespawnLazyRandomMobs", true);
        rsMaxGenerationTimeMillis = mc.getInteger("RandomSpawning.MaxGenerationTime", 20);
        vanillaSpawnsDisabled = mc.getBoolean("RandomSpawning.DisableVanillaSpawns", false);
        compatHeroesXPEnable = mc.getBoolean("Compatibility.Heroes.Enabled", compatHeroesXPEnable);
        compatHeroesShowXPMessage = mc.getBoolean("Compatibility.Heroes.ShowXPMessage", compatHeroesShowXPMessage);
        compatHeroesXPMessageFormat = mc.getString("Compatibility.Heroes.XPMessageFormat", compatHeroesXPMessageFormat);
        compatMcMMOShowXPMessage = mc.getBoolean("Compatibility.McMMO.ShowXPMessage", compatMcMMOShowXPMessage);
        compatMcMMOXPMessageFormat = mc.getString("Compatibility.McMMO.XPMessageFormat", compatMcMMOXPMessageFormat);
        compatSkillAPIShowXPMessage = mc.getBoolean("Compatibility.SkillAPI.ShowXPMessage", compatSkillAPIShowXPMessage);
        compatSkillAPIXPMessageFormat = mc.getString("Compatibility.SkillAPI.XPMessageFormat", compatSkillAPIXPMessageFormat);
        compatVaultShowMoneyMessage = mc.getBoolean("Compatibility.Vault.ShowMoneyMessage", compatVaultShowMoneyMessage);
        compatVaultMoneyMessageFormat = mc.getString("Compatibility.Vault.MoneyMessageFormat", compatVaultMoneyMessageFormat);
        compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
        compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
        compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
        compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        updateItems = mc.getBoolean("ItemUpdating.Enabled", true);
        loadExampleConfigs = mc.getBoolean("LoadExampleConfigs", true);
        if (MythicBukkit.isVolatile()) {
            String strScalingEquationHealth;
            String strScalingEquationDamage = mc.getString("Mobs.ScalingEquations.Damage", null);
            if (strScalingEquationDamage != null && !strScalingEquationDamage.equalsIgnoreCase("NONE")) {
                strScalingEquationDamage = strScalingEquationDamage.toLowerCase();
                this.scalingEquationDamage = new ExpressionBuilder(strScalingEquationDamage).variables("l", "v").build();
            }
            if ((strScalingEquationHealth = mc.getString("Mobs.ScalingEquations.Health", null)) != null && !strScalingEquationHealth.equalsIgnoreCase("NONE")) {
                strScalingEquationHealth = strScalingEquationHealth.toLowerCase();
                this.scalingEquationHealth = new ExpressionBuilder(strScalingEquationHealth).variables("l", "v").build();
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading WorldScaling Settings...", new Object[0]);
        WorldScaling.reset();
        if (this.settings.getCustomConfig().contains("Configuration.Mobs.Scaling")) {
            for (String world : this.settings.getCustomConfig().getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "*** Loading WorldScaling for world " + world, new Object[0]);
                MythicConfigImpl wmc = new MythicConfigImpl("Configuration.Mobs.Scaling." + world, this.settings.getCustomConfig());
                WorldScaling.initialize(world, wmc);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Default Level Modifiers...", new Object[0]);
        defaultLevelModifierHealth = mc.getString("Mobs.DefaultLevelModifiers.Health", "0.1");
        defaultLevelModifierDamage = mc.getString("Mobs.DefaultLevelModifiers.Damage", "0");
        defaultLevelModifierPower = mc.getString("Mobs.DefaultLevelModifiers.Power", "0");
        defaultLevelModifierArmor = mc.getString("Mobs.DefaultLevelModifiers.Armor", "0");
        defaultLevelModifierKBR = mc.getString("Mobs.DefaultLevelModifiers.KnockbackResistance", "0");
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Health: " + defaultLevelModifierHealth, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Damage: " + defaultLevelModifierDamage, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Power: " + defaultLevelModifierPower, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Armor: " + defaultLevelModifierArmor, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - KBR: " + defaultLevelModifierKBR, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Finished Load Default Level Modifiers!", new Object[0]);
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public static boolean generateRSPoints() {
        return rsGeneratePoints;
    }

    public static int getRSMaxMobsPerChunk() {
        return rsMaxMobsPerChunk;
    }

    public static int getRSPointsPerSecondLand() {
        return rsPointsPerSecondLand;
    }

    public static int getRSPointsPerSecondAir() {
        return rsPointsPerSecondAir;
    }

    public static int getRSPointsPerSecondSea() {
        return rsPointsPerSecondSea;
    }

    public static int getRSPointsPerSecondLava() {
        return rsPointsPerSecondLava;
    }

    public static int getRSPointsPerSecondGround() {
        return rsPointsPerSecondGround;
    }

    public static int getRSMaxGenerationTimeMillis() {
        return rsMaxGenerationTimeMillis;
    }

    public static boolean getRSDespawnVanillaOutsideRadius() {
        return rsDespawnVanillaOutsideRadius;
    }

    public static boolean loadExampleConfigs() {
        return loadExampleConfigs;
    }

    public boolean getDespawnMobsByDefault() {
        return this.mobsDespawnByDefault;
    }

    public boolean getPreventOtherDropsByDefault() {
        return this.preventOtherDropsByDefault;
    }

    public HashSet<Material> getTransparentBlocks() {
        return transparentBlocks;
    }

    public boolean shouldUpdateItems() {
        return updateItems;
    }

    @Override
    public MythicConfig createConfig(FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(fileConfiguration);
    }

    @Override
    public MythicConfig createConfig(String node, FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(node, fileConfiguration);
    }

    @Override
    public MythicConfig createConfig(String node, File file) {
        return new MythicConfigImpl(node, file);
    }

    @Override
    public MythicConfig createConfig(String node, File file, FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(node, file, fileConfiguration);
    }

    @Override
    public MythicLineConfig createLineConfig(File file, String line) {
        return new MythicLineConfigImpl(file, line);
    }

    @Override
    public MythicLineConfig createLineConfig(String line) {
        return new MythicLineConfigImpl(line);
    }

    public int getClockIntervalMain() {
        return this.clockIntervalMain;
    }

    public int getClockIntervalRandomSpawning() {
        return this.clockIntervalRandomSpawning;
    }

    public Boolean getAllowMetrics() {
        return this.allowMetrics;
    }

    public static int getBossBarUpdateInterval() {
        return bossBarUpdateInterval;
    }

    public Boolean getSkillsIgnoreArmorStandsByDefault() {
        return this.skillsIgnoreArmorStandsByDefault;
    }

    public Boolean getMobsDespawnByDefault() {
        return this.mobsDespawnByDefault;
    }

    public static boolean isTargetSelf() {
        return targetSelf;
    }

    public static boolean isTargetPlayers() {
        return targetPlayers;
    }

    public static boolean isTargetArmorStands() {
        return targetArmorStands;
    }

    public static boolean isTargetMarkers() {
        return targetMarkers;
    }

    public static boolean isTargetCreativeMode() {
        return targetCreativeMode;
    }

    public static boolean isTargetSpectatorMode() {
        return targetSpectatorMode;
    }

    public static boolean isTargetCitizensNPCs() {
        return targetCitizensNPCs;
    }

    public static boolean isTargetAnimals() {
        return targetAnimals;
    }

    public static boolean isTargetCreatures() {
        return targetCreatures;
    }

    public static boolean isTargetMonsters() {
        return targetMonsters;
    }

    public static boolean isTargetWaterMobs() {
        return targetWaterMobs;
    }

    public static boolean isTargetFlyingMobs() {
        return targetFlyingMobs;
    }

    public static boolean isTargetSameFaction() {
        return targetSameFaction;
    }

    public static boolean isTargetOwner() {
        return targetOwner;
    }

    public static boolean isTargetNonMythic() {
        return targetNonMythic;
    }

    public static boolean isTargetVillagers() {
        return targetVillagers;
    }

    public int getRandomSpawningPlayerRadiusMax() {
        return this.randomSpawningPlayerRadiusMax;
    }

    public int getRandomSpawningPlayerRadiusMin() {
        return this.randomSpawningPlayerRadiusMin;
    }

    public int getRandomSpawningPlayerRadiusY() {
        return this.randomSpawningPlayerRadiusY;
    }

    public static boolean isVanillaSpawnsDisabled() {
        return vanillaSpawnsDisabled;
    }

    public Expression getScalingEquationDamage() {
        return this.scalingEquationDamage;
    }

    public Expression getScalingEquationHealth() {
        return this.scalingEquationHealth;
    }

    static {
        ShowHealthRadius = 25;
        ScanInterval = 10;
        ClnrInterval = 600;
        UseCompatibilityMode = false;
        UseVolatileFeatures = true;
        ShowHealthFormat = "$mobname: $mobhp / $mobmaxhp";
        KillMessagePrefix = "";
        AllowUpdateChecking = true;
        SpawnerRange = 40;
        bossBarUpdateInterval = 20;
        EnableAIModifiers = true;
        EnableTimerSkills = true;
        EnableThreatTables = true;
        EnablePlayerFactions = true;
        EnableLegacySkills = true;
        targetSelf = false;
        targetPlayers = true;
        targetArmorStands = false;
        targetMarkers = false;
        targetCreativeMode = true;
        targetSpectatorMode = true;
        targetCitizensNPCs = false;
        targetAnimals = true;
        targetCreatures = true;
        targetMonsters = true;
        targetWaterMobs = true;
        targetFlyingMobs = true;
        targetSameFaction = true;
        targetOwner = true;
        targetNonMythic = true;
        targetVillagers = true;
        apiUseDeathEvent = true;
        apiUseSkillEvent = true;
        apiUseCustomSkillEvent = true;
        compatHeroesXPEnable = false;
        compatHeroesShowXPMessage = true;
        compatHeroesXPMessageFormat = "";
        compatSkillAPIShowXPMessage = true;
        compatSkillAPIXPMessageFormat = "";
        compatVaultShowMoneyMessage = true;
        compatVaultMoneyMessageFormat = "";
        compatMcMMOShowXPMessage = true;
        compatMcMMOXPMessageFormat = "";
        rsGeneratePoints = false;
        rsMaxMobsPerChunk = 20;
        rsPointsPerSecondLand = 10;
        rsPointsPerSecondAir = 0;
        rsPointsPerSecondSea = 1;
        rsPointsPerSecondLava = 0;
        rsPointsPerSecondGround = 0;
        rsMaxGenerationTimeMillis = 20;
        rsDespawnVanillaOutsideRadius = false;
        vanillaSpawnsDisabled = false;
        loadExampleConfigs = true;
        updateItems = true;
        transparentBlocks = new HashSet();
        for (Material m4 : Material.values()) {
            if (!m4.isTransparent() && m4.isSolid() && m4.isOccluding()) continue;
            transparentBlocks.add(m4);
        }
    }
}

