/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.adapters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.potion.PotionEffect;

public class VirtualEntity
implements AbstractEntity {
    private final UUID uniqueId = new UUID(0L, 0L);
    private AbstractLocation location;

    public VirtualEntity(AbstractLocation location) {
        this.location = location;
    }

    @Override
    public void setCustomName(String name) {
    }

    @Override
    public Entity getBukkitEntity() {
        return null;
    }

    @Override
    public AbstractLocation getLocation() {
        return this.location;
    }

    @Override
    public AbstractWorld getWorld() {
        return this.getLocation().getWorld();
    }

    @Override
    public boolean isLiving() {
        return false;
    }

    @Override
    public boolean isMob() {
        return false;
    }

    @Override
    public boolean isCreature() {
        return false;
    }

    @Override
    public boolean isMonster() {
        return false;
    }

    @Override
    public boolean isDamageable() {
        return false;
    }

    @Override
    public boolean isPlayer() {
        return false;
    }

    @Override
    public boolean hasLineOfSight(AbstractEntity e) {
        return ((LivingEntity)e.getBukkitEntity()).hasLineOfSight(BukkitAdapter.adapt(this.location));
    }

    @Override
    public boolean hasLineOfSight(AbstractLocation location) {
        return !((LivingEntity)this.getBukkitEntity()).hasLineOfSight(BukkitAdapter.adapt(location));
    }

    @Override
    public void teleport(AbstractLocation l) {
        this.location = l;
    }

    @Override
    public void setRemoveWhenFarAway(boolean bool) {
    }

    @Override
    public void setSaveToDisk(boolean bool) {
    }

    @Override
    public double getHealth() {
        return 0.0;
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean remove() {
        return true;
    }

    @Override
    public double getMaxHealth() {
        return 0.0;
    }

    @Override
    public void setFireTicks(int ticks) {
    }

    @Override
    public String getCustomName() {
        return "Server";
    }

    @Override
    public void addPotionEffect(PotionEffect effect) {
    }

    @Override
    public void setPassenger(Entity entity) {
    }

    @Override
    public boolean hasGravity() {
        return false;
    }

    @Override
    public void setGravity(boolean bool) {
    }

    @Override
    public boolean hasAI() {
        return false;
    }

    @Override
    public void setAI(boolean bool) {
    }

    @Override
    public boolean isAware() {
        return false;
    }

    @Override
    public void setAware(boolean bool) {
    }

    @Override
    public AbstractLocation getEyeLocation() {
        return this.location;
    }

    @Override
    public double getEyeHeight() {
        return 0.0;
    }

    @Override
    public AbstractEntity getTarget() {
        return null;
    }

    @Override
    public AbstractEntity getPassenger() {
        return null;
    }

    @Override
    public AbstractEntity getVehicle() {
        return null;
    }

    @Override
    public void eject() {
    }

    @Override
    public void setHealth(double d) {
    }

    @Override
    public String getName() {
        return "Server";
    }

    @Override
    public Optional<String> getFaction() {
        return Optional.empty();
    }

    @Override
    public void setMaxHealth(double health) {
    }

    @Override
    public void damage(float damage) {
    }

    @Override
    public void setPassenger(AbstractEntity entity) {
    }

    @Override
    public AbstractPlayer asPlayer() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractEntity) {
            return this.getUniqueId().equals(((AbstractEntity)o).getUniqueId());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
    }

    @Override
    public boolean isCitizensNPC() {
        return false;
    }

    @Override
    public boolean isAnimal() {
        return false;
    }

    @Override
    public boolean isWaterMob() {
        return false;
    }

    @Override
    public boolean isFlyingMob() {
        return false;
    }

    @Override
    public boolean isGliding() {
        return false;
    }

    @Override
    public boolean hasPotionEffect(String type) {
        return false;
    }

    @Override
    public boolean hasPotionEffect(String type, RangedDouble level, RangedDouble duration) {
        return false;
    }

    @Override
    public boolean hasPotionEffect() {
        return false;
    }

    @Override
    public boolean hasScoreboardTag(String tag) {
        return false;
    }

    @Override
    public void addScoreboardTag(String tag) {
    }

    @Override
    public void removeScoreboardTag(String tag) {
        this.getBukkitEntity().removeScoreboardTag(tag);
    }

    @Override
    public void equipItemHead(AbstractItemStack item) {
    }

    @Override
    public void equipItemChest(AbstractItemStack item) {
    }

    @Override
    public void equipItemLegs(AbstractItemStack item) {
    }

    @Override
    public void equipItemFeet(AbstractItemStack item) {
    }

    @Override
    public void equipItemMainHand(AbstractItemStack item) {
    }

    @Override
    public void equipItemOffHand(AbstractItemStack item) {
    }

    @Override
    public void setDamage(double damage) {
    }

    @Override
    public void setArmor(double armor) {
    }

    @Override
    public double getDamage() {
        return 0.0;
    }

    @Override
    public double getDamageBase() {
        return 0.0;
    }

    @Override
    public void setMovementSpeed(double speed) {
    }

    @Override
    public void setAttackSpeed(double speed) {
    }

    @Override
    public int getLuck() {
        return 0;
    }

    @Override
    public int getEnchantmentLevel(String enchantmentName) {
        return 0;
    }

    @Override
    public int getEnchantmentLevelHeld(String enchantmentName) {
        return 0;
    }

    @Override
    public void setMetadata(String key, Object value) {
    }

    @Override
    public boolean hasMetadata(String key) {
        return false;
    }

    @Override
    public void removeMetadata(String key) {
    }

    @Override
    public synchronized boolean isLoaded() {
        return true;
    }

    @Override
    public Optional<Object> getMetadata(String key) {
        return Optional.empty();
    }

    @Override
    public AbstractVector getVelocity() {
        return new AbstractVector(0, 0, 0);
    }

    @Override
    public void setVelocity(AbstractVector velocity) {
    }

    @Override
    public boolean isOnGround() {
        return false;
    }

    @Override
    public void setFreezingTicks(int i) {
    }

    @Override
    public boolean isFreezing() {
        return false;
    }

    @Override
    public int getFreezingTicks() {
        return 0;
    }

    @Override
    public int getMaxFreezingTicks() {
        return 0;
    }

    @Override
    public void setSavesToDisk(boolean b) {
    }

    @Override
    public PersistentDataContainer getDataContainer() {
        return null;
    }

    @Override
    public double getArmor() {
        return 0.0;
    }

    @Override
    public double getArmorBase() {
        return 0.0;
    }

    @Override
    public double getArmorToughness() {
        return 0.0;
    }

    @Override
    public double getArmorToughnessBase() {
        return 0.0;
    }

    @Override
    public void setArmorToughness(double armor) {
    }

    @Override
    public void setHealthAndMax(double d) {
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }
}

