/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.text;

import io.lumine.mythic.bukkit.utils.adventure.audience.Audience;
import io.lumine.mythic.bukkit.utils.adventure.inventory.Book;
import io.lumine.mythic.bukkit.utils.adventure.text.Component;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.MiniMessage;
import io.lumine.mythic.bukkit.utils.plugin.LoaderUtils;
import java.util.Collection;
import org.bukkit.entity.Player;

public final class Books {
    private static final MiniMessage bookParser = MiniMessage.miniMessage();

    public static Book createBook(String title, String author, Collection<String> pages) {
        Object bookTitle = bookParser.deserialize(title);
        Object bookAuthor = bookParser.deserialize(author);
        Book.Builder builder = Book.builder().title((Component)bookTitle).author((Component)bookAuthor);
        for (String page : pages) {
            builder.addPage((Component)bookParser.deserialize(page));
        }
        return builder.build();
    }

    public static Book createBook(String title, String author, String ... pages) {
        Object bookTitle = bookParser.deserialize(title);
        Object bookAuthor = bookParser.deserialize(author);
        Book.Builder builder = Book.builder().title((Component)bookTitle).author((Component)bookAuthor);
        for (String page : pages) {
            builder.addPage((Component)bookParser.deserialize(page));
        }
        return builder.build();
    }

    public static void openBook(Player player, Book book) {
        Audience audience = LoaderUtils.getPlugin().adventure().player(player);
        audience.openBook(book);
    }
}

