/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.storage.players;

import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.storage.players.Profile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public interface ProfileRepository<P extends Profile> {
    public P getProfile(@Nonnull Player var1);

    @Nonnull
    public Optional<P> getProfile(@Nonnull UUID var1);

    @Nonnull
    public Optional<P> getProfile(@Nonnull String var1);

    @Nonnull
    public Collection<P> getKnownProfiles();

    @Nonnull
    default public Map<UUID, P> getProfiles(@Nonnull Iterable<UUID> uniqueIds) {
        Objects.requireNonNull(uniqueIds, "uniqueIds");
        HashMap<UUID, Profile> ret = new HashMap<UUID, Profile>();
        for (UUID uniqueId : uniqueIds) {
            Optional<P> maybeProfile = this.getProfile(uniqueId);
            if (!maybeProfile.isPresent()) continue;
            ret.put(uniqueId, (Profile)maybeProfile.get());
        }
        return ret;
    }

    @Nonnull
    default public Map<String, P> getProfilesByName(@Nonnull Iterable<String> names) {
        Objects.requireNonNull(names, "names");
        HashMap ret = new HashMap();
        for (String name : names) {
            this.getProfile(name).ifPresent(p -> ret.put(name, p));
        }
        return ret;
    }

    @Nonnull
    public Promise<Optional<P>> lookupProfile(@Nonnull UUID var1);

    @Nonnull
    public Promise<Optional<P>> lookupProfile(@Nonnull String var1);

    public void saveAll();
}

