/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import io.lumine.mythic.bukkit.utils.adventure.text.format.TextColor;
import io.lumine.mythic.bukkit.utils.gson.GsonSerializable;
import io.lumine.mythic.bukkit.utils.gson.JsonBuilder;
import java.awt.Color;
import javax.annotation.Nonnull;
import org.bukkit.DyeColor;
import org.jetbrains.annotations.Range;

public class Chroma
implements GsonSerializable {
    private final int rgb;

    public static Chroma deserialize(String element) {
        Preconditions.checkNotNull((Object)element);
        int r = Integer.parseInt(element);
        return Chroma.of(r);
    }

    public static Chroma of(int rgb) {
        return new Chroma(rgb);
    }

    public static Chroma of(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g2, @Range(from=0L, to=255L) int b) {
        return new Chroma(r, g2, b);
    }

    public static Chroma of(float r, float g2, float b) {
        return new Chroma((int)(r * 255.0f), (int)(g2 * 255.0f), (int)(b * 255.0f));
    }

    public static Chroma of(String input) {
        int b;
        int g2;
        int r;
        if (input.startsWith("#")) {
            Color color = Color.decode(input);
            r = color.getRed();
            g2 = color.getGreen();
            b = color.getBlue();
        } else if (input.contains(",")) {
            String[] rgb = input.split(",");
            r = Integer.parseInt(rgb[0]);
            g2 = Integer.parseInt(rgb[1]);
            b = Integer.parseInt(rgb[2]);
        } else {
            DyeColor dColor = DyeColor.valueOf((String)input.toUpperCase());
            org.bukkit.Color color = dColor.getFireworkColor();
            r = color.getRed();
            g2 = color.getGreen();
            b = color.getBlue();
        }
        return Chroma.of(r, g2, b);
    }

    private Chroma(int rgb) {
        this.rgb = rgb;
    }

    private Chroma(int r, int g2, int b) {
        this.rgb = (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF;
    }

    public int value() {
        return this.rgb;
    }

    public int red() {
        return this.value() >> 16 & 0xFF;
    }

    public int green() {
        return this.value() >> 8 & 0xFF;
    }

    public int blue() {
        return this.value() & 0xFF;
    }

    public org.bukkit.Color toBukkitColor() {
        return org.bukkit.Color.fromRGB((int)this.value());
    }

    public DyeColor toBukkitDyeColor() {
        return DyeColor.getByColor((org.bukkit.Color)this.toBukkitColor());
    }

    public TextColor toComponentColor() {
        return TextColor.color(this.rgb);
    }

    public String toHexString() {
        return String.format("#%06x", this.value());
    }

    public Chroma blend(Chroma with, float i) {
        float clampedT = Math.min(1.0f, Math.max(0.0f, i));
        int ar = this.red();
        int ag = this.green();
        int ab = this.blue();
        int br = with.red();
        int bg = with.green();
        int bb = with.blue();
        return Chroma.of(Math.round((float)ar + clampedT * (float)(br - ar)), Math.round((float)ag + clampedT * (float)(bg - ag)), Math.round((float)ab + clampedT * (float)(bb - ab)));
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("color", this.rgb).build();
    }

    public String serializeShortForm() {
        return String.format("#%06x", this.value());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chroma)) {
            return false;
        }
        Chroma other = (Chroma)o;
        return Double.compare(this.red(), other.red()) == 0 && Double.compare(this.green(), other.green()) == 0 && Double.compare(this.blue(), other.blue()) == 0;
    }

    public int hashCode() {
        return this.value();
    }

    public String toString() {
        return "Chroma(r=" + this.red() + ", g=" + this.green() + ", b=" + this.blue() + ")";
    }
}

