/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.plugin;

import com.google.common.base.Preconditions;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.adventure.platform.bukkit.BukkitAudiences;
import io.lumine.mythic.bukkit.utils.command.CommandMapUtil;
import io.lumine.mythic.bukkit.utils.config.ConfigurationLoader;
import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.maven.LibraryLoader;
import io.lumine.mythic.bukkit.utils.plugin.LoaderUtils;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.terminable.TerminableModule;
import io.lumine.mythic.bukkit.utils.terminable.composite.CompositeTerminable;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class LuminePlugin
extends JavaPlugin
implements Terminable,
TerminableConsumer {
    private LuminePlugin loaderPlugin;
    private CompositeTerminable terminableRegistry = CompositeTerminable.create();
    private Map<String, ConfigurationLoader<LuminePlugin>> propertyFiles = new ConcurrentHashMap<String, ConfigurationLoader<LuminePlugin>>();
    private Set<PropertyType> properties = new HashSet<PropertyType>();
    private BukkitAudiences adventure;

    protected void load() {
    }

    protected void enable() {
    }

    protected void disable() {
    }

    protected void postStartup() {
    }

    public final void onLoad() {
        this.loaderPlugin = LoaderUtils.getPlugin();
        this.terminableRegistry = CompositeTerminable.create();
        LibraryLoader.loadAll(this.getClass());
        this.load();
    }

    public final void onEnable() {
        Schedulers.builder().async().after(10L, TimeUnit.SECONDS).every(30L, TimeUnit.SECONDS).run(this.terminableRegistry::cleanup).bindWith(this.terminableRegistry);
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.enable();
        Schedulers.sync().runLater(() -> this.postStartup(), 1L);
    }

    public final void onDisable() {
        try {
            this.disable();
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
        this.close();
    }

    @Override
    public void close() {
        this.terminableRegistry.closeAndReportException();
    }

    @NonNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public void reloadConfiguration() {
        this.propertyFiles.clear();
        this.properties.forEach(prop -> prop.reload());
    }

    @Override
    @Nonnull
    public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        return this.terminableRegistry.bind(terminable);
    }

    @Override
    @Nonnull
    public <T extends TerminableModule> T bindModule(@Nonnull T module) {
        return this.terminableRegistry.bindModule(module);
    }

    @Nonnull
    public <T extends CommandExecutor & TabCompleter> void registerCommand(String cmd, T handler) {
        PluginCommand command = this.getCommand(cmd);
        if (command != null) {
            command.setExecutor(handler);
            command.setTabCompleter((TabCompleter)handler);
        } else {
            CommandMapUtil.registerCommand((Plugin)this, handler, cmd);
        }
    }

    @Nonnull
    public <T extends CommandExecutor> T registerCommand(@Nonnull T command, String permission, String permissionMessage, String description, String ... aliases) {
        return CommandMapUtil.registerCommand((Plugin)this, command, permission, permissionMessage, description, aliases);
    }

    @Nonnull
    public <T extends Listener> void registerListener(@Nonnull T listener) {
        Preconditions.checkNotNull(listener, (Object)"listener");
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    @Nullable
    public <T> T getService(@Nonnull Class<T> service) {
        return (T)this.getServer().getServicesManager().load(service);
    }

    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance, @Nonnull ServicePriority priority) {
        this.getServer().getServicesManager().register(clazz, instance, (Plugin)this, priority);
        return instance;
    }

    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        Preconditions.checkNotNull(instance, (Object)"instance");
        return this.provideService(clazz, instance, ServicePriority.Normal);
    }

    @Nullable
    public <T> T getPlugin(@Nonnull String name, @Nonnull Class<T> pluginClass) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(pluginClass, (Object)"pluginClass");
        return (T)this.getServer().getPluginManager().getPlugin(name);
    }

    public boolean isPluginPresent(@Nonnull String name) {
        return this.getServer().getPluginManager().getPlugin(name) != null;
    }

    public void registerProperty(PropertyType property) {
        this.properties.add(property);
    }

    public ConfigurationSection getPropertyConfig(String file) {
        return this.getPropertyConfig(file, false);
    }

    public ConfigurationSection getPropertyConfig(String file, boolean isFileAbsolute) {
        ConfigurationLoader<LuminePlugin> loader;
        if (this.propertyFiles.containsKey(file)) {
            loader = this.propertyFiles.get(file);
        } else {
            loader = new ConfigurationLoader<LuminePlugin>(this, (String)(file.contains(".") ? file : file + ".yml"), isFileAbsolute);
            this.propertyFiles.put(file, loader);
        }
        return loader.getCustomConfig();
    }

    public File getPropertyFile(String file) {
        ConfigurationLoader<LuminePlugin> loader;
        if (this.propertyFiles.containsKey(file)) {
            loader = this.propertyFiles.get(file);
        } else {
            loader = new ConfigurationLoader<LuminePlugin>(this, file + ".yml");
            this.propertyFiles.put(file, loader);
        }
        return loader.getFile();
    }

    public ConfigurationSection getPropertyFileInternal(String file) {
        return new ConfigurationLoader<LuminePlugin>(this, this.getClass().getResourceAsStream("/" + file)).getCustomConfig();
    }

    public ConfigurationSection getPropertyFileInternal(InputStream file) {
        return new ConfigurationLoader<LuminePlugin>(this, file).getCustomConfig();
    }

    public File getJarFile() {
        return this.getFile();
    }
}

