/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.MonitoredState;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Icon<T>
implements MonitoredState {
    private final BiFunction<T, Player, ItemFactory> itemBuilderFunc;
    private final BiFunction<T, Player, Material> materialFunc;
    private final BiFunction<T, Player, Integer> modelFunction;
    private final BiFunction<T, Player, Integer> amountFunction;
    private final BiFunction<T, Player, String> nameFunc;
    private final BiFunction<T, Player, List<String>> loreFunc;
    private final Optional<BiConsumer<T, Player>> clickFunc;
    private final Optional<BiConsumer<T, Player>> rightClickFunc;
    private final Optional<BiFunction<T, Player, ItemFactory>> blinkFunc;
    private boolean hideFlags = false;
    private boolean blink = false;

    public Icon(BiFunction<T, Player, ItemFactory> iconFunc, BiFunction<T, Player, Material> materialFunc, BiFunction<T, Player, String> nameFunc, BiFunction<T, Player, List<String>> loreFunc, BiConsumer<T, Player> clickFunc, BiConsumer<T, Player> rclickFunc, BiFunction<T, Player, Integer> byteFunction, BiFunction<T, Player, Integer> amountFunction, BiFunction<T, Player, ItemFactory> blinkFunc, boolean hideFlags) {
        this.itemBuilderFunc = iconFunc;
        this.materialFunc = materialFunc;
        this.nameFunc = nameFunc;
        this.loreFunc = loreFunc;
        this.clickFunc = Optional.ofNullable(clickFunc);
        this.rightClickFunc = Optional.ofNullable(rclickFunc);
        this.modelFunction = byteFunction;
        this.amountFunction = amountFunction;
        this.blinkFunc = Optional.ofNullable(blinkFunc);
        this.hideFlags = hideFlags;
    }

    public ItemStack build(T state, Player player) {
        ItemFactory factory = this.getIconFactory(state, player);
        if (this.modelFunction != null) {
            factory.model(this.modelFunction.apply(state, player));
        }
        if (this.nameFunc != null) {
            factory.name(this.nameFunc.apply(state, player));
        }
        if (this.amountFunction != null) {
            factory.amount(this.amountFunction.apply(state, player));
        }
        if (this.loreFunc != null) {
            factory.clearLore();
            factory.lore((Iterable<String>)this.loreFunc.apply(state, player));
        }
        if (this.hideFlags) {
            factory.hideAttributes();
        } else {
            factory.showAttributes();
        }
        return factory.build();
    }

    private ItemFactory getIconFactory(T state, Player player) {
        ItemFactory factory;
        if (this.blinkFunc.isPresent()) {
            boolean bl = this.blink = !this.blink;
            factory = this.blink ? this.blinkFunc.get().apply(state, player) : (this.itemBuilderFunc != null ? this.itemBuilderFunc.apply(state, player) : ItemFactory.of(this.materialFunc.apply(state, player)));
        } else {
            factory = this.itemBuilderFunc != null ? this.itemBuilderFunc.apply(state, player) : ItemFactory.of(this.materialFunc.apply(state, player));
        }
        return factory;
    }

    public int getAmount(T state, Player player) {
        return this.amountFunction == null ? 1 : this.amountFunction.apply(state, player);
    }

    public boolean isBlinkingIcon() {
        return this.blinkFunc.isPresent();
    }

    public Optional<BiConsumer<T, Player>> getClickFunc() {
        return this.clickFunc;
    }

    public Optional<BiConsumer<T, Player>> getRightClickFunc() {
        return this.rightClickFunc;
    }

    @Override
    public long getMonitorTimestamp() {
        return 0L;
    }
}

