/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Catalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DDLExportConfiguration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Queries;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.UniqueKey;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataAccessException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractMeta;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.InformationSchemaExport;
import io.lumine.mythic.bukkit.utils.lib.jooq.util.xml.jaxb.InformationSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

final class TableMetaImpl
extends AbstractMeta {
    private final Table<?>[] tables;

    TableMetaImpl(Configuration configuration, Table<?>[] tables) {
        super(configuration);
        this.tables = tables;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        LinkedHashSet<Catalog> result = new LinkedHashSet<Catalog>();
        for (Table<?> table : this.tables) {
            if (table.getSchema() == null || table.getSchema().getCatalog() == null) continue;
            result.add(table.getSchema().getCatalog());
        }
        return new ArrayList<Catalog>(result);
    }

    @Override
    final List<Schema> getSchemas0() {
        LinkedHashSet<Schema> result = new LinkedHashSet<Schema>();
        for (Table<?> table : this.tables) {
            if (table.getSchema() == null) continue;
            result.add(table.getSchema());
        }
        return new ArrayList<Schema>(result);
    }

    @Override
    final List<Table<?>> getTables0() {
        return Collections.unmodifiableList(Arrays.asList(this.tables));
    }

    @Override
    final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.tables) {
            if (table.getPrimaryKey() == null) continue;
            result.add(table.getPrimaryKey());
        }
        return result;
    }

    @Override
    public Queries ddl(DDLExportConfiguration exportConfiguration) throws DataAccessException {
        return new DDL(this.dsl(), exportConfiguration).queries(this.tables);
    }

    @Override
    public InformationSchema informationSchema() throws DataAccessException {
        return InformationSchemaExport.exportTables(this.configuration(), this.getTables());
    }
}

