/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AutoAliasTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Dual;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

final class TableList
extends QueryPartList<Table<?>> {
    private static final Set<SQLDialect> UNQUALIFY_FIELDS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB);

    TableList() {
    }

    TableList(List<? extends Table<?>> wrappedList) {
        super(wrappedList);
    }

    @SafeVarargs
    TableList(Table<?> ... wrappedList) {
        super((QueryPart[])wrappedList);
    }

    @Override
    public final boolean rendersContent(Context<?> ctx) {
        return true;
    }

    @Override
    protected void acceptElement(Context<?> ctx, Table<?> part) {
        Table alternative;
        if (ctx.declareTables() && part instanceof AutoAliasTable && (alternative = ((AutoAliasTable)part).autoAlias(ctx)) != null) {
            super.acceptElement(ctx, alternative);
        } else {
            super.acceptElement(ctx, part);
        }
    }

    @Override
    protected void toSQLEmptyList(Context<?> ctx) {
        ctx.visit(new Dual());
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    final List<Field<?>> fields() {
        return Tools.flatMap(this, t2 -> Arrays.asList(t2.fieldsRow().fields()));
    }

    final void toSQLFields(Context<?> ctx) {
        ctx.qualify(!UNQUALIFY_FIELDS.contains((Object)ctx.dialect()) && ctx.qualify(), c -> {
            String sep = "";
            for (Table table : this) {
                for (Field<?> field : table.fieldsRow().fields()) {
                    ctx.sql(sep);
                    ctx.visit(field);
                    sep = ", ";
                }
            }
        });
    }
}

