/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DropViewFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class DropViewImpl
extends AbstractDDLQuery
implements QOM.DropView,
DropViewFinalStep {
    final Table<?> view;
    final boolean ifExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropViewImpl(Configuration configuration, Table<?> view, boolean ifExists) {
        super(configuration);
        this.view = view;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_VIEW_TABLE).visit(Keywords.K_DROP_VIEW).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        ctx.end(Clause.DROP_VIEW_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.DropView $view(Table<?> newValue) {
        return this.constructor().apply(newValue, this.$ifExists());
    }

    @Override
    public final QOM.DropView $ifExists(boolean newValue) {
        return this.constructor().apply(this.$view(), newValue);
    }

    public final Function2<? super Table<?>, ? super Boolean, ? extends QOM.DropView> constructor() {
        return (a1, a2) -> new DropViewImpl(this.configuration(), (Table<?>)a1, (boolean)a2);
    }
}

