/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.events.functional.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import com.google.common.collect.ImmutableSet;
import io.lumine.mythic.bukkit.utils.events.ProtocolSubscription;
import io.lumine.mythic.bukkit.utils.events.functional.ExpiryTestStage;
import io.lumine.mythic.bukkit.utils.events.functional.protocol.ProtocolHandlerList;
import io.lumine.mythic.bukkit.utils.events.functional.protocol.ProtocolHandlerListImpl;
import io.lumine.mythic.bukkit.utils.events.functional.protocol.ProtocolSubscriptionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

class ProtocolSubscriptionBuilderImpl
implements ProtocolSubscriptionBuilder {
    final Set<PacketType> types;
    final ListenerPriority priority;
    BiConsumer<? super PacketEvent, Throwable> exceptionConsumer = DEFAULT_EXCEPTION_CONSUMER;
    final List<Predicate<PacketEvent>> filters = new ArrayList<Predicate<PacketEvent>>(3);
    final List<BiPredicate<ProtocolSubscription, PacketEvent>> preExpiryTests = new ArrayList<BiPredicate<ProtocolSubscription, PacketEvent>>(0);
    final List<BiPredicate<ProtocolSubscription, PacketEvent>> midExpiryTests = new ArrayList<BiPredicate<ProtocolSubscription, PacketEvent>>(0);
    final List<BiPredicate<ProtocolSubscription, PacketEvent>> postExpiryTests = new ArrayList<BiPredicate<ProtocolSubscription, PacketEvent>>(0);

    ProtocolSubscriptionBuilderImpl(Set<PacketType> types, ListenerPriority priority) {
        this.types = ImmutableSet.copyOf(types);
        this.priority = priority;
    }

    @Override
    @Nonnull
    public ProtocolSubscriptionBuilder expireIf(@Nonnull BiPredicate<ProtocolSubscription, PacketEvent> predicate, ExpiryTestStage ... testPoints) {
        Objects.requireNonNull(testPoints, "testPoints");
        Objects.requireNonNull(predicate, "predicate");
        block5: for (ExpiryTestStage testPoint : testPoints) {
            switch (testPoint) {
                case PRE: {
                    this.preExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_FILTER: {
                    this.midExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_HANDLE: {
                    this.postExpiryTests.add(predicate);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ExpiryTestPoint: " + testPoint);
                }
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public ProtocolSubscriptionBuilder filter(@Nonnull Predicate<PacketEvent> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.filters.add(predicate);
        return this;
    }

    @Override
    @Nonnull
    public ProtocolSubscriptionBuilder exceptionConsumer(@Nonnull BiConsumer<? super PacketEvent, Throwable> exceptionConsumer) {
        Objects.requireNonNull(exceptionConsumer, "exceptionConsumer");
        this.exceptionConsumer = exceptionConsumer;
        return this;
    }

    @Override
    @Nonnull
    public ProtocolHandlerList handlers() {
        return new ProtocolHandlerListImpl(this);
    }
}

