/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.Position;

public class PointProp
extends PropertyType<Position> {
    private final Position def;

    public PointProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.def = Position.of(0.0, 0.0, 0.0, "world");
    }

    public PointProp(LuminePlugin plugin, Object file, String node, Position def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected Position compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        String prop = section.getString(node);
        if (prop == null) {
            return this.def;
        }
        try {
            String[] split = prop.split(",");
            double x = Double.valueOf(split[0]);
            double y = Double.valueOf(split[1]);
            double z = Double.valueOf(split[2]);
            String world = split[3];
            return Position.of(x, y, z, world);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void set(String holder, Position value) {
        if (this.config == null) {
            return;
        }
        String val = value.getX() + "," + value.getY() + "," + value.getZ() + "," + value.getWorld();
        if (holder != null) {
            this.config.set(holder + "." + this.node, val);
        } else {
            this.config.set(this.node, val);
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }
}

