/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.file.YamlConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class NodeListProp
extends PropertyType<Set<String>> {
    public NodeListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    @Override
    protected Set<String> compute(ConfigurationSection section, String node) {
        if (section == null || !section.isSet(node)) {
            return Collections.emptySet();
        }
        return section.getConfigurationSection(node).getKeys(false);
    }

    public static Collection<String> getNodes(File file) {
        return NodeListProp.getNodes(file, "");
    }

    public static Collection<String> getNodes(File file, String node) {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration(file);
            return config.getConfigurationSection(node).getKeys(false);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return Collections.emptyList();
        }
    }
}

