/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyScope;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class PropertyType<T> {
    protected final LuminePlugin plugin;
    protected ConfigurationSection config;
    protected final Map<String, ConfigurationSection> holderSections = new HashMap<String, ConfigurationSection>();
    protected String file = null;
    protected Object scope = null;
    protected boolean fileAbsolute;
    protected final String node;

    public PropertyType(LuminePlugin plugin, Object scope, String node) {
        plugin.registerProperty(this);
        this.plugin = plugin;
        this.node = node;
        this.setScope(scope);
    }

    public void reload() {
        this.load();
    }

    public void setScope(Object scope) {
        this.config = null;
        this.scope = scope;
        if (scope == null) {
            this.file = null;
            this.fileAbsolute = false;
        } else if (scope instanceof PropertyScope) {
            this.file = ((PropertyScope)scope).get();
            this.fileAbsolute = false;
        } else if (scope instanceof File) {
            this.file = ((File)scope).getAbsolutePath();
            this.fileAbsolute = true;
        } else if (scope instanceof ConfigurationSection) {
            this.config = (ConfigurationSection)scope;
            this.holderSections.clear();
            this.file = null;
        } else if (scope instanceof String) {
            this.file = (String)scope;
            this.fileAbsolute = false;
        } else {
            this.file = scope.toString();
            this.fileAbsolute = false;
        }
        this.load();
    }

    private void load() {
        if (this.file == null || this.file.isEmpty()) {
            return;
        }
        this.config = this.plugin.getPropertyConfig(this.file, this.fileAbsolute);
        this.holderSections.clear();
    }

    public T get() {
        return this.compute(this.config, this.node);
    }

    public T get(PropertyHolder holder) {
        return this.get(holder.getPropertyNode());
    }

    public T get(String holder) {
        if (this.config == null && (this.file == null || this.file.isEmpty())) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        this.holderSections.computeIfAbsent(holder, _holder -> this.config.getConfigurationSection(holder));
        return this.compute(this.holderSections.get(holder), this.node);
    }

    public T get(ConfigurationSection section) {
        if (this.config == null && (this.file == null || this.file.isEmpty())) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        return this.compute(section, this.node);
    }

    public T fget(Object scope) {
        this.setScope(scope);
        return this.compute(this.config, this.node);
    }

    public T fget(Object scope, PropertyHolder holder) {
        this.setScope(scope);
        return this.get(holder.getPropertyNode());
    }

    public T fget(Object scope, String holder) {
        this.setScope(scope);
        if (this.config == null && this.file == null) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        this.holderSections.computeIfAbsent(holder, _holder -> this.config.getConfigurationSection(holder));
        return this.compute(this.holderSections.get(holder), this.node);
    }

    public T fget(Object scope, ConfigurationSection section) {
        this.setScope(scope);
        if (this.config == null && this.file == null) {
            throw new IllegalArgumentException("Scope has not been set on property " + this.node);
        }
        return this.compute(section, this.node);
    }

    protected abstract T compute(ConfigurationSection var1, String var2);

    public void set(PropertyHolder holder, T value) {
        this.set(holder.getPropertyNode(), value);
    }

    public void set(T value) {
        this.set((String)null, value);
    }

    public void set(String holder, T value) {
        if (this.config == null) {
            return;
        }
        if (holder != null) {
            this.config.set(holder + "." + this.node, value);
        } else {
            this.config.set(this.node, value);
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fset(Object scope, PropertyHolder holder, T value) {
        this.fset(scope, holder.getPropertyNode(), value);
    }

    public void fset(Object scope, T value) {
        this.setScope(scope);
        this.set(value);
    }

    public void fset(Object scope, String holder, T value) {
        this.setScope(scope);
        this.set(holder, value);
    }

    public LuminePlugin getPlugin() {
        return this.plugin;
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }

    public String getFile() {
        return this.file;
    }

    public Object getScope() {
        return this.scope;
    }

    public boolean isFileAbsolute() {
        return this.fileAbsolute;
    }

    public String getNode() {
        return this.node;
    }
}

