/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.adventure.text.minimessage.internal.parser;

import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.ParsingException;
import io.lumine.mythic.bukkit.utils.adventure.text.minimessage.internal.parser.Token;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ParsingExceptionImpl
extends ParsingException {
    private static final long serialVersionUID = 2507190809441787202L;
    private final String originalText;
    private Token @NotNull [] tokens;
    private final boolean withStackTrace;

    public ParsingExceptionImpl(String message, @Nullable String originalText, Token ... tokens) {
        super(message);
        this.tokens = tokens;
        this.originalText = originalText;
        this.withStackTrace = false;
    }

    public ParsingExceptionImpl(String message, @Nullable String originalText, @Nullable Throwable cause, boolean withStackTrace, Token ... tokens) {
        super(message, cause);
        this.tokens = tokens;
        this.originalText = originalText;
        this.withStackTrace = withStackTrace;
    }

    @Override
    public String getMessage() {
        String arrowInfo = this.tokens().length != 0 ? "\n\t" + this.arrow() : "";
        String messageInfo = this.originalText() != null ? "\n\t" + this.originalText() + arrowInfo : "";
        return super.getMessage() + messageInfo;
    }

    @Override
    @Nullable
    public String detailMessage() {
        return super.getMessage();
    }

    @Override
    @Nullable
    public String originalText() {
        return this.originalText;
    }

    @NotNull
    public @NotNull Token @NotNull [] tokens() {
        return this.tokens;
    }

    public void tokens(@NotNull @NotNull Token @NotNull [] tokens) {
        this.tokens = tokens;
    }

    private String arrow() {
        @NotNull Token[] ts = this.tokens();
        char[] chars = new char[ts[ts.length - 1].endIndex()];
        int i = 0;
        for (Token t2 : ts) {
            Arrays.fill(chars, i, t2.startIndex(), ' ');
            chars[t2.startIndex()] = 94;
            Arrays.fill(chars, t2.startIndex() + 1, t2.endIndex() - 1, '~');
            chars[t2.endIndex() - 1] = 94;
            i = t2.endIndex();
        }
        return new String(chars);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        if (this.withStackTrace) {
            return super.fillInStackTrace();
        }
        return this;
    }

    @Override
    public int startIndex() {
        if (this.tokens.length == 0) {
            return -1;
        }
        return this.tokens[0].startIndex();
    }

    @Override
    public int endIndex() {
        if (this.tokens.length == 0) {
            return -1;
        }
        return this.tokens[this.tokens.length - 1].endIndex();
    }
}

