/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.adventure.text;

import io.lumine.mythic.bukkit.utils.adventure.text.BuildableComponent;
import io.lumine.mythic.bukkit.utils.adventure.text.Component;
import io.lumine.mythic.bukkit.utils.adventure.text.ComponentBuilder;
import io.lumine.mythic.bukkit.utils.adventure.text.ComponentLike;
import io.lumine.mythic.bukkit.utils.adventure.text.ScopedComponent;
import io.lumine.mythic.bukkit.utils.adventure.translation.Translatable;
import io.lumine.mythic.bukkit.utils.text.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TranslatableComponent
extends BuildableComponent<TranslatableComponent, Builder>,
ScopedComponent<TranslatableComponent> {
    @NotNull
    public String key();

    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent key(@NotNull Translatable translatable) {
        return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
    }

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent key(@NotNull String var1);

    @NotNull
    public List<Component> args();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent args(ComponentLike ... var1);

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent args(@NotNull List<? extends ComponentLike> var1);

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("key", this.key()), ExaminableProperty.of("args", this.args())), BuildableComponent.super.examinableProperties());
    }

    public static interface Builder
    extends ComponentBuilder<TranslatableComponent, Builder> {
        @Contract(pure=true)
        @NotNull
        default public Builder key(@NotNull Translatable translatable) {
            return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull String var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull ComponentBuilder<?, ?> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(ComponentBuilder<?, ?> ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(ComponentLike ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull List<? extends ComponentLike> var1);
    }
}

