/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.events;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class MythicMobDeathEvent
extends Event {
    private final ActiveMob mob;
    private final LivingEntity killer;
    private List<ItemStack> drops;
    private static final HandlerList handlers = new HandlerList();

    public MythicMobDeathEvent(ActiveMob am, LivingEntity killer, List<ItemStack> drops) {
        this.mob = am;
        this.killer = killer;
        this.drops = drops;
    }

    public ActiveMob getMob() {
        return this.mob;
    }

    public Entity getEntity() {
        return BukkitAdapter.adapt(this.mob.getEntity());
    }

    public MythicMob getMobType() {
        return this.mob.getType();
    }

    public double getMobLevel() {
        return this.mob.getLevel();
    }

    public LivingEntity getKiller() {
        return this.killer;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public void setDrops(List<ItemStack> list) {
        this.drops = list;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MythicMobDeathEvent)) {
            return false;
        }
        MythicMobDeathEvent other = (MythicMobDeathEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ActiveMob this$mob = this.getMob();
        ActiveMob other$mob = other.getMob();
        if (this$mob == null ? other$mob != null : !this$mob.equals(other$mob)) {
            return false;
        }
        LivingEntity this$killer = this.getKiller();
        LivingEntity other$killer = other.getKiller();
        if (this$killer == null ? other$killer != null : !this$killer.equals(other$killer)) {
            return false;
        }
        List<ItemStack> this$drops = this.getDrops();
        List<ItemStack> other$drops = other.getDrops();
        return !(this$drops == null ? other$drops != null : !((Object)this$drops).equals(other$drops));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MythicMobDeathEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActiveMob $mob = this.getMob();
        result = result * 59 + ($mob == null ? 43 : ((Object)$mob).hashCode());
        LivingEntity $killer = this.getKiller();
        result = result * 59 + ($killer == null ? 43 : $killer.hashCode());
        List<ItemStack> $drops = this.getDrops();
        result = result * 59 + ($drops == null ? 43 : ((Object)$drops).hashCode());
        return result;
    }

    public String toString() {
        return "MythicMobDeathEvent(mob=" + this.getMob() + ", killer=" + this.getKiller() + ", drops=" + this.getDrops() + ")";
    }
}

