/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties.display;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.entities.properties.display.DisplayProperty;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;

public class ItemDisplayProperty
extends DisplayProperty {
    private BukkitItemStack itemStack;
    private ItemDisplay.ItemDisplayTransform transform;

    public ItemDisplayProperty(MythicConfig config) {
        super(config);
        String item = config.getString("DisplayOptions.Item", "grass_block");
        this.itemStack = new BukkitItemStack(item);
        this.transform = config.getEnum("DisplayOptions.Transform", ItemDisplay.ItemDisplayTransform.class, ItemDisplay.ItemDisplayTransform.NONE);
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if ((entity = super.applyProperties(entity)) instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            itemDisplay.setItemStack(this.itemStack.build());
            itemDisplay.setItemDisplayTransform(this.transform);
        }
        return entity;
    }
}

