/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties.display;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.entities.properties.EntityPropertySet;
import io.lumine.mythic.core.logging.MythicLogger;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.util.Transformation;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public abstract class DisplayProperty
implements EntityPropertySet {
    private float viewRange;
    private float width;
    private float height;
    private float shadowRadius;
    private float shadowStrength;
    private Display.Billboard billboard;
    private int interpolationDelay;
    private int interpolationDuration;
    private Transformation transformation;
    private Display.Brightness brightness;
    private Color colorOverride;

    public DisplayProperty(MythicConfig config) {
        MythicConfig displayOption = config.getNestedConfig("DisplayOptions");
        this.viewRange = displayOption.getFloat("ViewRange", 1.0f);
        this.width = displayOption.getFloat("Width", 0.0f);
        this.height = displayOption.getFloat("Height", 0.0f);
        this.shadowRadius = displayOption.getFloat("ShadowRadius", 0.0f);
        this.shadowStrength = displayOption.getFloat("ShadowStrength", 1.0f);
        this.billboard = displayOption.getEnum("Billboard", Display.Billboard.class, Display.Billboard.FIXED);
        this.interpolationDelay = displayOption.getInt("InterpolationDelay", 0);
        this.interpolationDuration = displayOption.getInt("InterpolationDuration", 0);
        Vector3f translation = new Vector3f();
        String[] trans = displayOption.getString("Translation", "0,0,0").split(",");
        try {
            translation.x = Float.parseFloat(trans[0]);
            translation.y = Float.parseFloat(trans[1]);
            translation.z = Float.parseFloat(trans[2]);
        }
        catch (Exception e) {
            MythicLogger.errorGenericConfig(config, "Invalid Translation. Format must be 'DisplayOptions.Translation: x,y,z");
        }
        Vector3f scale = new Vector3f();
        String[] s2 = displayOption.getString("Scale", "1,1,1").split(",");
        try {
            scale.x = Float.parseFloat(s2[0]);
            scale.y = Float.parseFloat(s2[1]);
            scale.z = Float.parseFloat(s2[2]);
        }
        catch (Exception e) {
            MythicLogger.errorGenericConfig(config, "Invalid Scale. Format must be 'DisplayOptions.Scale: x,y,z");
        }
        Quaternionf leftRotation = new Quaternionf();
        String[] leftRot = displayOption.getString("LeftRotation", "0,0,0,1").split(",");
        try {
            leftRotation.x = Float.parseFloat(leftRot[0]);
            leftRotation.y = Float.parseFloat(leftRot[1]);
            leftRotation.z = Float.parseFloat(leftRot[2]);
            leftRotation.w = Float.parseFloat(leftRot[3]);
        }
        catch (Exception e) {
            MythicLogger.errorGenericConfig(config, "Invalid LeftRotation. Format must be 'DisplayOptions.LeftRotation: x,y,z,w");
        }
        Quaternionf rightRotation = new Quaternionf();
        String[] rightRot = displayOption.getString("RightRotation", "0,0,0,1").split(",");
        try {
            rightRotation.x = Float.parseFloat(rightRot[0]);
            rightRotation.y = Float.parseFloat(rightRot[1]);
            rightRotation.z = Float.parseFloat(rightRot[2]);
            rightRotation.w = Float.parseFloat(rightRot[3]);
        }
        catch (Exception e) {
            MythicLogger.errorGenericConfig(config, "Invalid RightRotation. Format must be 'DisplayOptions.RightRotation: x,y,z,w");
        }
        this.transformation = new Transformation(translation, leftRotation, scale, rightRotation);
        if (displayOption.isSet("BlockLight") && displayOption.isSet("SkyLight")) {
            int blockLight = displayOption.getInt("BlockLight");
            int skyLight = displayOption.getInt("SkyLight");
            this.brightness = new Display.Brightness(Math.clamp((int)0, (int)15, (int)blockLight), Math.clamp((int)0, (int)15, (int)skyLight));
        }
        String colorStr = displayOption.getString("ColorOverride", "255,255,255,255");
        try {
            String[] splitStr = colorStr.split(",");
            int a = Integer.parseInt(splitStr[0]);
            int r = Integer.parseInt(splitStr[1]);
            int g2 = Integer.parseInt(splitStr[2]);
            int b = Integer.parseInt(splitStr[3]);
            this.colorOverride = Color.fromARGB((int)a, (int)r, (int)g2, (int)b);
        }
        catch (Throwable e) {
            this.colorOverride = Color.fromARGB((int)-1);
            MythicLogger.errorGenericConfig(config, "Invalid ColorOverride: " + colorStr);
        }
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if (!(entity instanceof Display)) {
            return entity;
        }
        Display display = (Display)entity;
        display.setViewRange(this.viewRange);
        display.setDisplayWidth(this.width);
        display.setDisplayHeight(this.height);
        display.setShadowRadius(this.shadowRadius);
        display.setShadowStrength(this.shadowStrength);
        display.setBillboard(this.billboard);
        display.setInterpolationDelay(this.interpolationDelay);
        display.setInterpolationDuration(this.interpolationDuration);
        display.setTransformation(this.transformation);
        display.setGlowColorOverride(this.colorOverride);
        return entity;
    }
}

