/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;

public class BukkitTNT
extends BukkitEntityType {
    private static final int height = 1;
    private int explosionFuseTicks = -1;
    private int explosionYield = -1;
    private boolean explosionIncendiary = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.explosionFuseTicks = mc.getInteger("Options.FuseTicks", -1);
        this.explosionYield = mc.getInteger("Options.ExplosionYield", -1);
        this.explosionIncendiary = mc.getBoolean("Options.Incendiary", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.PRIMED_TNT, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        TNTPrimed tnt = (TNTPrimed)entity;
        if (this.explosionFuseTicks > -1) {
            tnt.setFuseTicks(this.explosionFuseTicks);
        }
        if (this.explosionYield > -1) {
            tnt.setYield((float)this.explosionYield);
        }
        tnt.setIsIncendiary(this.explosionIncendiary);
        return tnt;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof TNTPrimed;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

