/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;

public class BukkitFallingBlock
extends BukkitEntityType {
    private final int height = 1;
    private final String headString = "";
    private ItemStack head;
    private Material type = Material.STONE;
    private boolean dropsItem = true;
    private boolean hurtsEntities = true;
    private boolean replaceSpawnLocationBlock = false;
    private boolean mimicPositionBlock = false;

    @Override
    public void instantiate(MythicConfig mc) {
        String mat = mc.getString("Options.Block", "STONE");
        try {
            this.type = Material.getMaterial((String)mat.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("Invalid falling block material specified");
        }
        this.head = ItemFactory.of(this.type).build();
        this.dropsItem = mc.getBoolean("Options.DropsItem", true);
        this.hurtsEntities = mc.getBoolean("Options.HurtsEntities", true);
        this.replaceSpawnLocationBlock = mc.getBoolean("Options.ReplaceSpawnLocationBlock", false);
        this.mimicPositionBlock = mc.getBoolean("Options.UseSpawnLocationType", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Material type = this.mimicPositionBlock && location.getBlock().getType().isBlock() && !location.getBlock().getType().isAir() ? location.getBlock().getType() : this.type;
        if (this.replaceSpawnLocationBlock) {
            location.getBlock().setType(Material.AIR);
        }
        return location.getWorld().spawnFallingBlock(location, type.createBlockData());
    }

    @Override
    public Entity applyOptions(Entity entity) {
        FallingBlock fallingBlock = (FallingBlock)entity;
        fallingBlock.setDropItem(this.dropsItem);
        fallingBlock.setHurtEntities(this.hurtsEntities);
        return fallingBlock;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof FallingBlock;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }
}

