/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import com.kirelcodes.miniaturepets.MiniaturePets;
import com.kirelcodes.miniaturepets.config.Config;
import com.kirelcodes.miniaturepets.mob.Mob;
import com.kirelcodes.miniaturepets.mob.MobContainer;
import com.kirelcodes.miniaturepets.utils.APIUtils;
import com.kirelcodes.miniaturepets.utils.EntityAttributes;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.File;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MPetCompat {
    public MiniaturePetType getModel(MythicConfig config) {
        return new MiniaturePetType(config);
    }

    public static class MiniaturePetType {
        private MythicMPet pet;
        private MobContainer container;
        private String display;
        private boolean showName;
        private boolean valid = false;

        public MiniaturePetType(MythicConfig mc) {
            String path;
            File file;
            String id = mc.getString("Model.Id", null);
            double speed = mc.getDouble("Options.MovementSpeed", 0.17);
            this.showName = mc.getBoolean("Model.ShowName", false);
            this.showName = mc.getBoolean("MiniaturePet.ShowName", this.showName);
            this.showName = mc.getBoolean("MPet.ShowName", this.showName);
            this.display = mc.getColorString("DisplayName", "");
            this.display = mc.getColorString("Display", this.display);
            if (id == null && (id = mc.getString("MPet.Id", null)) == null) {
                id = mc.getString("MiniaturePet.Id", null);
            }
            if (!(file = new File(path = MiniaturePets.getInstance().getDataFolder().getAbsolutePath() + "/pets/" + id + ".mpet")).exists()) {
                MythicLogger.errorCompatibility("MiniaturePets", "Could not find file for pet type '" + id + "' at '" + path + "'");
                return;
            }
            this.container = APIUtils.loadContainer((File)file);
            this.container.setAnchor(EntityType.PIG);
            this.container.setSpeed(speed);
            this.valid = true;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void applyModel(AbstractEntity entity) {
            if (!entity.isLiving()) {
                return;
            }
            this.pet = new MythicMPet(BukkitAdapter.adapt(entity.getLocation()), this.container, entity);
            entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, true, false));
            if (this.showName) {
                this.pet.setCustomName(this.display);
            }
        }

        public void removeModel() {
            if (this.pet != null) {
                this.pet.remove();
                this.pet = null;
            }
        }
    }

    private static class MythicMPet
    extends Mob {
        public MythicMPet(@NonNull Location loc, MobContainer type, AbstractEntity entity) {
            LivingEntity oldNav;
            block3: {
                super(loc, type);
                if (loc == null) {
                    throw new NullPointerException("loc is marked non-null but is null");
                }
                oldNav = this.navigator;
                this.navigator = (LivingEntity)entity.getBukkitEntity();
                this.navigator.setCanPickupItems(false);
                try {
                    EntityAttributes.miniatureId.setValue(this.navigator, (double)this.getID());
                }
                catch (Exception exception) {
                    Bukkit.getLogger().warning("Setting of pet attributes failed for... some reason! Type: " + type.getAnchor());
                    if (!Config.isDebug()) break block3;
                    exception.printStackTrace();
                }
            }
            Schedulers.sync().runLater(() -> {
                if (this.navigator != null && this.navigator.isValid()) {
                    this.navigator.setFallDistance(0.0f);
                    this.navigator.teleport(loc);
                    if (this.getStructure() != null) {
                        this.getStructure().run();
                    }
                }
            }, 2L);
            oldNav.remove();
        }
    }
}

