/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.api.skills.IDummySkill;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.conditions.IEntityComparisonCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.utility.ActiveInfoCommand;
import io.lumine.mythic.bukkit.commands.utility.ActiveRemoveCommand;
import io.lumine.mythic.bukkit.commands.utility.AddEntityNBTCommand;
import io.lumine.mythic.bukkit.commands.utility.BroadcastCommand;
import io.lumine.mythic.bukkit.commands.utility.GetBlockCoordinatesCommand;
import io.lumine.mythic.bukkit.commands.utility.GetBlockInfoCommand;
import io.lumine.mythic.bukkit.commands.utility.GetItemInfoCommand;
import io.lumine.mythic.bukkit.commands.utility.GetLightLevelCommand;
import io.lumine.mythic.bukkit.commands.utility.GetPathStringCommand;
import io.lumine.mythic.bukkit.commands.utility.GetSpawnStateCommand;
import io.lumine.mythic.bukkit.commands.utility.GetStatsCommand;
import io.lumine.mythic.bukkit.commands.utility.GetStructuresCommand;
import io.lumine.mythic.bukkit.commands.utility.GetTargetInfoCommand;
import io.lumine.mythic.bukkit.commands.utility.GetTargetNBTCommand;
import io.lumine.mythic.bukkit.commands.utility.ListAllEntitiesCommand;
import io.lumine.mythic.bukkit.commands.utility.ListValidStructuresCommand;
import io.lumine.mythic.bukkit.commands.utility.PluginDumpCommand;
import io.lumine.mythic.bukkit.commands.utility.TestEntityNBTCommand;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class UtilitiesCommand
extends Command<MythicBukkit> {
    public UtilitiesCommand(Command<MythicBukkit> parent) {
        super(parent);
        this.addSubCommands(new BroadcastCommand(this), new GetBlockCoordinatesCommand(this), new GetBlockInfoCommand(this), new GetItemInfoCommand(this), new GetTargetInfoCommand(this), new AddEntityNBTCommand(this), new TestEntityNBTCommand(this), new GetTargetNBTCommand(this), new GetPathStringCommand(this), new ActiveInfoCommand(this), new ActiveRemoveCommand(this), new ListAllEntitiesCommand(this), new GetLightLevelCommand(this), new GetStructuresCommand(this), new GetStatsCommand(this), new ListValidStructuresCommand(this), new GetSpawnStateCommand(this), new PluginDumpCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("generatedocs")) {
            String docsFolder = ((MythicBukkit)this.getPlugin()).getDataFolder() + System.getProperty("file.separator") + "Docs";
            String mechanicsFolder = docsFolder + System.getProperty("file.separator") + "Mechanics";
            String mechanicsFile = docsFolder + System.getProperty("file.separator") + "mechanics.txt";
            File file = new File(docsFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(mechanicsFolder)).exists()) {
                file.mkdir();
            }
            if ((file = new File(mechanicsFile)).exists()) {
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (PrintWriter out = new PrintWriter(mechanicsFile);){
                Collection<Class<?>> mechanicsClasses = AnnotationUtil.getAnnotatedClasses((JavaPlugin)this.plugin, "io.lumine.mythic.core.skills.mechanics", MythicMechanic.class);
                for (Class clazz : mechanicsClasses.stream().sorted((a, b) -> a.getAnnotation(MythicMechanic.class).name().compareTo(b.getAnnotation(MythicMechanic.class).name())).collect(Collectors.toList())) {
                    try {
                        String name = StringUtils.capitalize((String)clazz.getAnnotation(MythicMechanic.class).name());
                        String author = clazz.getAnnotation(MythicMechanic.class).author();
                        CharSequence[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                        String description = clazz.getAnnotation(MythicMechanic.class).description();
                        String version = clazz.getAnnotation(MythicMechanic.class).version();
                        Object type = "";
                        if (Aura.class.isAssignableFrom(clazz)) {
                            type = (String)type + "Aura";
                        } else {
                            if (IDummySkill.class.isAssignableFrom(clazz)) {
                                type = "Dummy";
                            }
                            if (IMetaSkill.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "Meta";
                            }
                            if (INoTargetSkill.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "No-Target";
                            } else if (ITargetedEntitySkill.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "Entity";
                            } else if (ITargetedLocationSkill.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "Location";
                            }
                        }
                        out.println("| [[:skills:mechanics:" + name.toLowerCase() + "|" + name + "]] | " + (String)type + " | " + description + " |");
                        String cFile = name.toLowerCase() + ".txt";
                        File cfile = new File(mechanicsFolder + System.getProperty("file.separator") + cFile);
                        if (cfile.exists()) {
                            cfile.delete();
                        }
                        cfile.createNewFile();
                        try (PrintWriter cout = new PrintWriter(cfile);){
                            ArrayList<Field> fields = new ArrayList<Field>();
                            for (Field f : clazz.getDeclaredFields()) {
                                if (f.getAnnotations().length <= 0) continue;
                                fields.add(f);
                            }
                            cout.println("<WRAP infobox right>");
                            cout.println("<WRAP infoboxheader>" + name + "</WRAP>");
                            cout.println("<WRAP infoboxtable>");
                            cout.println("^Type| " + (String)type + "|");
                            if (aliases.length > 0) {
                                cout.println("^Aliases| " + String.join((CharSequence)", ", aliases) + "|");
                            }
                            cout.println("^Added In| " + version + "|");
                            cout.println("^Author| " + author + "|");
                            cout.println("</WRAP>");
                            cout.println("</WRAP>");
                            cout.println("====== Mechanic: " + name + " ======");
                            cout.println(" ");
                            cout.println(description);
                            cout.println(" ");
                            cout.println("===== Attributes =====");
                            cout.println("^Attribute ^Aliases ^Description ^Default ^");
                            if (fields.size() == 0) {
                                cout.println("|  |  |  |");
                            } else {
                                for (Field field : fields) {
                                    String aName = field.getAnnotation(MythicField.class).name();
                                    CharSequence[] aAliases = field.getAnnotation(MythicField.class).aliases();
                                    String aDescription = field.getAnnotation(MythicField.class).description();
                                    String defValue = field.getAnnotation(MythicField.class).defValue();
                                    cout.println("| " + aName + " | " + String.join((CharSequence)", ", aAliases) + " | " + aDescription + " | " + defValue + " |");
                                }
                            }
                            cout.println("\\\\");
                            cout.println(" ");
                            cout.println("===== Examples =====");
                            cout.println(" ");
                            cout.println("<code>");
                            cout.println("Skills:");
                            cout.println("- " + name.toLowerCase() + "{} true");
                            cout.println("</code>");
                            cout.println(" ");
                            cout.println(" ");
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            String conditionsFolder = docsFolder + System.getProperty("file.separator") + "Conditions";
            String conditionsFile = docsFolder + System.getProperty("file.separator") + "conditions.txt";
            file = new File(docsFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(conditionsFolder)).exists()) {
                file.mkdir();
            }
            if ((file = new File(conditionsFile)).exists()) {
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (PrintWriter out = new PrintWriter(conditionsFile);){
                Collection<Class<?>> conditionsClasses = AnnotationUtil.getAnnotatedClasses((JavaPlugin)this.plugin, "io.lumine.mythic.core.skills.conditions.all", MythicCondition.class);
                for (Class clazz : conditionsClasses.stream().sorted((a, b) -> a.getAnnotation(MythicCondition.class).name().compareTo(b.getAnnotation(MythicCondition.class).name())).collect(Collectors.toList())) {
                    try {
                        String name = StringUtils.capitalize((String)clazz.getAnnotation(MythicCondition.class).name());
                        String author = clazz.getAnnotation(MythicCondition.class).author();
                        CharSequence[] aliases = clazz.getAnnotation(MythicCondition.class).aliases();
                        String description = clazz.getAnnotation(MythicCondition.class).description();
                        String version = clazz.getAnnotation(MythicCondition.class).version();
                        Object type = "";
                        if (ISkillMetaCondition.class.isAssignableFrom(clazz)) {
                            type = (String)type + "Meta";
                        } else {
                            if (IEntityCondition.class.isAssignableFrom(clazz)) {
                                type = "Entity";
                            }
                            if (ILocationCondition.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "Location";
                            }
                            if (IEntityComparisonCondition.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "Compare";
                            } else if (ILocationComparisonCondition.class.isAssignableFrom(clazz)) {
                                if (((String)type).length() > 0) {
                                    type = (String)type + ", ";
                                }
                                type = (String)type + "Compare";
                            }
                        }
                        out.println("| [[:conditions:" + name.toLowerCase() + "|" + name + "]] | " + (String)type + " | " + description + " |");
                        String cFile = name.toLowerCase() + ".txt";
                        File cfile = new File(conditionsFolder + System.getProperty("file.separator") + cFile);
                        if (cfile.exists()) {
                            cfile.delete();
                        }
                        cfile.createNewFile();
                        try (PrintWriter cout = new PrintWriter(cfile);){
                            ArrayList<Field> fields = new ArrayList<Field>();
                            for (Field f : clazz.getDeclaredFields()) {
                                if (f.getAnnotations().length <= 0) continue;
                                fields.add(f);
                            }
                            cout.println("<WRAP infobox right>");
                            cout.println("<WRAP infoboxheader>" + name + "</WRAP>");
                            cout.println("<WRAP infoboxtable>");
                            cout.println("^Type| " + (String)type + "|");
                            if (aliases.length > 0) {
                                cout.println("^Aliases| " + String.join((CharSequence)", ", aliases) + "|");
                            }
                            cout.println("^Added In| " + version + "|");
                            cout.println("^Author| " + author + "|");
                            cout.println("</WRAP>");
                            cout.println("</WRAP>");
                            cout.println("====== Condition: " + name + " ======");
                            cout.println(" ");
                            cout.println(description);
                            cout.println(" ");
                            cout.println("===== Attributes =====");
                            cout.println("^Attribute ^Aliases ^Description ^");
                            if (fields.size() == 0) {
                                cout.println("|  |  |  |");
                            } else {
                                for (Field field : fields) {
                                    String aName = field.getAnnotation(MythicField.class).name();
                                    CharSequence[] aAliases = field.getAnnotation(MythicField.class).aliases();
                                    String aDescription = field.getAnnotation(MythicField.class).description();
                                    cout.println("| " + aName + " | " + String.join((CharSequence)", ", aAliases) + " | " + aDescription + " |");
                                }
                            }
                            cout.println("\\\\");
                            cout.println(" ");
                            cout.println("===== Examples =====");
                            cout.println(" ");
                            cout.println("<code>");
                            cout.println("Conditions:");
                            cout.println("- " + name.toLowerCase() + "{} true");
                            cout.println("</code>");
                            cout.println(" ");
                            cout.println(" ");
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "utilities";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"utility", "u"};
    }
}

