/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GetStatsCommand
extends Command<MythicBukkit> {
    public GetStatsCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        Player target = args.length > 0 ? Bukkit.getPlayer((String)args[0]) : p;
        if (target == null) {
            CommandHelper.sendError(sender, "Target not found");
            return true;
        }
        PlayerData profile = (PlayerData)((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(target);
        StatRegistry stats = profile.getStats();
        CommandHelper.send(sender, "Stats for player " + target.getName() + ":");
        for (StatType stat : stats.getApplicableStats()) {
            double value = stats.get(stat);
            CommandHelper.send(sender, "- " + stat.getDisplay() + " " + value);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities.getstats";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "getstats";
    }
}

